# RustyBT Brownfield Enhancement Architecture

## 🚨 Critical Architecture Documents (Epic 6 - Live Trading)

**MUST READ** before implementing any Epic 6 stories:

1. **[Strategy Reusability Guarantee](./strategy-reusability-guarantee.md)** ⭐️ **MANDATORY**
   - Confirms strategies written for backtest run in live/paper trading without code changes
   - Defines the TradingAlgorithm API contract that must be preserved
   - Shows code examples: same strategy in backtest, paper, and live modes
   - **Referenced in:** Story 6.1 (AC10), Story 6.2 (AC8), Story 6.7 (AC9, AC10)

2. **[Shadow Trading Validation Framework](./shadow-trading-summary.md)** ⭐️ **CRITICAL**
   - Architecture overview for continuous backtest-live alignment monitoring
   - Defines components: ShadowBacktestEngine, SignalAlignmentValidator, ExecutionQualityTracker, AlignmentCircuitBreaker
   - Documents production deployment workflow and alignment metrics
   - **Referenced in:** Story 6.1 (AC9), Story 6.12 (primary reference)

3. **[Enhancement Scope - API Integration](./enhancement-scope-and-integration-strategy.md#api-integration)** ⭐️ **IMPORTANT**
   - Documents which APIs are preserved vs. extended for live trading
   - Shows concrete code example of strategy reusability
   - Explains optional live hooks vs. required backtest methods
   - **Referenced in:** Story 6.1, Story 6.2

---

## Table of Contents

- [RustyBT Brownfield Enhancement Architecture](#table-of-contents)
  - [Introduction](./introduction.md)
  - [Existing Project Analysis](./existing-project-analysis.md)
    - [Current Project State](./existing-project-analysis.md#current-project-state)
    - [Available Documentation](./existing-project-analysis.md#available-documentation)
    - [Identified Constraints](./existing-project-analysis.md#identified-constraints)
    - [Zipline-Reloaded Architecture Overview](./existing-project-analysis.md#zipline-reloaded-architecture-overview)
  - [Change Log](./change-log.md)
  - [Enhancement Scope and Integration Strategy](./enhancement-scope-and-integration-strategy.md)
    - [Enhancement Overview](./enhancement-scope-and-integration-strategy.md#enhancement-overview)
    - [Integration Approach](./enhancement-scope-and-integration-strategy.md#integration-approach)
      - [Code Integration Strategy](./enhancement-scope-and-integration-strategy.md#code-integration-strategy)
      - [Database Integration](./enhancement-scope-and-integration-strategy.md#database-integration)
      - [API Integration](./enhancement-scope-and-integration-strategy.md#api-integration)
      - [UI Integration](./enhancement-scope-and-integration-strategy.md#ui-integration)
    - [Compatibility Requirements](./enhancement-scope-and-integration-strategy.md#compatibility-requirements)
      - [Existing API Compatibility](./enhancement-scope-and-integration-strategy.md#existing-api-compatibility)
      - [Database Schema Compatibility](./enhancement-scope-and-integration-strategy.md#database-schema-compatibility)
      - [UI/UX Consistency](./enhancement-scope-and-integration-strategy.md#uiux-consistency)
      - [Performance Impact](./enhancement-scope-and-integration-strategy.md#performance-impact)
  - [Tech Stack](./tech-stack.md)
    - [Existing Technology Stack (Preserved from Zipline-Reloaded)](./tech-stack.md#existing-technology-stack-preserved-from-zipline-reloaded)
    - [New Technology Additions (RustyBT Enhancements)](./tech-stack.md#new-technology-additions-rustybt-enhancements)
    - [Technology Stack Rationale](./tech-stack.md#technology-stack-rationale)
      - [Polars over Pandas](./tech-stack.md#polars-over-pandas)
      - [Parquet over bcolz/HDF5](./tech-stack.md#parquet-over-bcolzhdf5)
      - [FastAPI for REST API (Epic 9)](./tech-stack.md#fastapi-for-rest-api-epic-9)
      - [Multiple Broker Libraries (Not Just CCXT)](./tech-stack.md#multiple-broker-libraries-not-just-ccxt)
    - [Removed Technologies (Deprecated from Zipline)](./tech-stack.md#removed-technologies-deprecated-from-zipline)
  - [Data Models and Schema Changes](./data-models-and-schema-changes.md)
    - [New Database Tables (Extend Zipline Asset DB)](./data-models-and-schema-changes.md#new-database-tables-extend-zipline-asset-db)
      - [broker_connections](./data-models-and-schema-changes.md#broker_connections)
      - [live_positions](./data-models-and-schema-changes.md#live_positions)
      - [order_audit_log](./data-models-and-schema-changes.md#order_audit_log)
      - [strategy_state](./data-models-and-schema-changes.md#strategy_state)
    - [Decimal Finance Models (Replaces float64)](./data-models-and-schema-changes.md#decimal-finance-models-replaces-float64)
      - [DecimalLedger](./data-models-and-schema-changes.md#decimalledger)
      - [DecimalPosition](./data-models-and-schema-changes.md#decimalposition)
      - [DecimalTransaction](./data-models-and-schema-changes.md#decimaltransaction)
    - [Polars Data Layer Models](./data-models-and-schema-changes.md#polars-data-layer-models)
      - [PolarsBarReader](./data-models-and-schema-changes.md#polarsbarreader)
      - [PolarsDataPortal](./data-models-and-schema-changes.md#polarsdataportal)
    - [Asset Model Extensions](./data-models-and-schema-changes.md#asset-model-extensions)
      - [Cryptocurrency Asset Type](./data-models-and-schema-changes.md#cryptocurrency-asset-type)
  - [Component Architecture](./component-architecture.md)
    - [Decimal Finance Components](./component-architecture.md#decimal-finance-components)
      - [DecimalLedger](./component-architecture.md#decimalledger)
      - [DecimalPosition](./component-architecture.md#decimalposition)
      - [DecimalTransaction](./component-architecture.md#decimaltransaction)
    - [Polars Data Components](./component-architecture.md#polars-data-components)
      - [PolarsParquetDailyReader](./component-architecture.md#polarsparquetdailyreader)
      - [PolarsParquetMinuteReader](./component-architecture.md#polarsparquetminutereader)
      - [PolarsDataPortal](./component-architecture.md#polarsdataportal)
    - [Live Trading Components](./component-architecture.md#live-trading-components)
      - [LiveTradingEngine](./component-architecture.md#livetradingengine)
      - [BrokerAdapter (Abstract Base)](./component-architecture.md#brokeradapter-abstract-base)
      - [CCXTAdapter](./component-architecture.md#ccxtadapter)
      - [IBAdapter](./component-architecture.md#ibadapter)
    - [Data Adapter Components](./component-architecture.md#data-adapter-components)
      - [BaseDataAdapter](./component-architecture.md#basedataadapter)
      - [CCXTDataAdapter](./component-architecture.md#ccxtdataadapter)
      - [YFinanceAdapter](./component-architecture.md#yfinanceadapter)
      - [CSVAdapter](./component-architecture.md#csvadapter)
  - [External API Integration](./external-api-integration.md)
    - [Broker API Integration](./external-api-integration.md#broker-api-integration)
      - [Interactive Brokers (ib_async)](./external-api-integration.md#interactive-brokers-ib_async)
      - [Binance (binance-connector)](./external-api-integration.md#binance-binance-connector)
      - [Bybit (pybit)](./external-api-integration.md#bybit-pybit)
      - [Hyperliquid (hyperliquid-python-sdk)](./external-api-integration.md#hyperliquid-hyperliquid-python-sdk)
      - [CCXT (Generic Multi-Exchange)](./external-api-integration.md#ccxt-generic-multi-exchange)
    - [Data API Integration](./external-api-integration.md#data-api-integration)
      - [Yahoo Finance (yfinance)](./external-api-integration.md#yahoo-finance-yfinance)
      - [CCXT (Market Data)](./external-api-integration.md#ccxt-market-data)
      - [Optional: Polygon.io, Alpaca, Alpha Vantage](./external-api-integration.md#optional-polygonio-alpaca-alpha-vantage)
    - [WebSocket Streaming (Epic 6)](./external-api-integration.md#websocket-streaming-epic-6)
  - [Source Tree](./source-tree.md)
    - [RustyBT Directory Structure](./source-tree.md#rustybt-directory-structure)
    - [Integration with Zipline Structure](./source-tree.md#integration-with-zipline-structure)
  - [Infrastructure and Deployment Integration](./infrastructure-and-deployment-integration.md)
    - [Self-Hosted Deployment Strategy](./infrastructure-and-deployment-integration.md#self-hosted-deployment-strategy)
      - [Deployment Modes](./infrastructure-and-deployment-integration.md#deployment-modes)
      - [Infrastructure Components](./infrastructure-and-deployment-integration.md#infrastructure-components)
      - [High Availability Setup](./infrastructure-and-deployment-integration.md#high-availability-setup)
      - [Performance Considerations](./infrastructure-and-deployment-integration.md#performance-considerations)
  - [Coding Standards](./coding-standards.md)
    - [Python Coding Standards](./coding-standards.md#python-coding-standards)
    - [Zero-Mock Enforcement (MANDATORY)](./coding-standards.md#zero-mock-enforcement-mandatory)
    - [Code Quality Guardrails (MANDATORY)](./coding-standards.md#code-quality-guardrails-mandatory)
    - [Testing Standards](./coding-standards.md#testing-standards)
    - [Documentation Standards](./coding-standards.md#documentation-standards)
  - [Testing Strategy](./testing-strategy.md)
    - [Test Coverage Targets](./testing-strategy.md#test-coverage-targets)
    - [Test Pyramid](./testing-strategy.md#test-pyramid)
    - [Property-Based Testing (Hypothesis)](./testing-strategy.md#property-based-testing-hypothesis)
    - [Regression Testing](./testing-strategy.md#regression-testing)
    - [Temporal Isolation Tests](./testing-strategy.md#temporal-isolation-tests)
    - [Continuous Integration](./testing-strategy.md#continuous-integration)
    - [Test Data Management](./testing-strategy.md#test-data-management)
  - [Security Integration](./security-integration.md)
    - [Credential Management](./security-integration.md#credential-management)
    - [API Rate Limiting](./security-integration.md#api-rate-limiting)
    - [Audit Logging](./security-integration.md#audit-logging)
    - [Input Validation and Sanitization](./security-integration.md#input-validation-and-sanitization)
    - [Network Security](./security-integration.md#network-security)
    - [Secrets Management](./security-integration.md#secrets-management)
    - [Security Updates](./security-integration.md#security-updates)
  - [Checklist Results Report](./checklist-results-report.md)
    - [Executive Summary](./checklist-results-report.md#executive-summary)
    - [Section Analysis](./checklist-results-report.md#section-analysis)
    - [Top 5 Risks and Mitigations](./checklist-results-report.md#top-5-risks-and-mitigations)
    - [Recommendations](./checklist-results-report.md#recommendations)
    - [AI Implementation Readiness](./checklist-results-report.md#ai-implementation-readiness)
    - [Validation Checklist Details](./checklist-results-report.md#validation-checklist-details)
  - [Next Steps](./next-steps.md)
    - [Handoff to Development Teams](./next-steps.md#handoff-to-development-teams)
    - [Architecture Validation](./next-steps.md#architecture-validation)
    - [Continuous Architecture Updates](./next-steps.md#continuous-architecture-updates)
