# Agent Prompts Directory

**Purpose**: This directory stores specialized prompts for AI agents working on RustyBT project tasks.

---

## What Goes Here

Prompts for:
- Expert review sessions
- Specialized task execution
- Quality assurance workflows
- Documentation creation assistance
- Code review automation

---

## Current Prompts

### Task 3.2: Expert Review Prompt
- **File**: `task-3.2-expert-review-prompt.md`
- **Purpose**: Prompt for Expert Developer agents to review Documentation Quality Framework (Story 11.1)
- **Usage**: Provide this prompt to 2 expert AI agents for independent framework review
- **Output**: Completed expert reviews saved to `story-artifacts/expert-reviews/11.1-expert-review.md`

---

## Naming Convention

Format: `{task-id}-{purpose}-prompt.md`

Examples:
- `task-3.2-expert-review-prompt.md`
- `story-11.2-documentation-creation-prompt.md`
- `qa-validation-prompt.md`

---

## Usage Guidelines

1. **Copy Prompt**: Copy the entire prompt file contents
2. **Provide to Agent**: Give prompt to appropriate AI agent(s)
3. **Collect Output**: Receive completed work from agent
4. **Store Artifacts**: Save agent outputs to appropriate locations

---

## Prompt Quality Standards

All prompts in this directory should:
- Clearly define the task and objective
- Specify deliverables and formats
- Include completion criteria
- Provide necessary context and file locations
- Include examples where helpful
- Define success metrics

---

**Created**: 2025-10-15
**Part of**: Story 11.1 - Documentation Quality Framework
**Maintained By**: Dev Agent (James)
