/*
MIT License

Copyright (c) 2022 Vanilagy

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

Source: https://github.com/Vanilagy/webm-muxer/blob/40aa073c2247f0cbe1dea484be1e4f985e1159ca/build/webm-muxer.min.mjs
*/
var wt=(f,e,i)=>{if(!e.has(f))throw TypeError("Cannot "+i)};var t=(f,e,i)=>(wt(f,e,"read from private field"),i?i.call(f):e.get(f)),a=(f,e,i)=>{if(e.has(f))throw TypeError("Cannot add the same private member more than once");e instanceof WeakSet?e.add(f):e.set(f,i)},d=(f,e,i,r)=>(wt(f,e,"write to private field"),r?r.call(f,i):e.set(f,i),i);var o=(f,e,i)=>(wt(f,e,"access private method"),i);var J=class{constructor(e){this.value=e}},_=class{constructor(e){this.value=e}};var pt=f=>f<1<<8?1:f<1<<16?2:f<1<<24?3:f<2**32?4:f<2**40?5:6,Dt=f=>{if(f<(1<<7)-1)return 1;if(f<(1<<14)-1)return 2;if(f<(1<<21)-1)return 3;if(f<(1<<28)-1)return 4;if(f<2**35-1)return 5;if(f<2**42-1)return 6;throw new Error("EBML VINT size not supported "+f)};var O=(f,e,i)=>{let r=0;for(let s=e;s<i;s++){let n=Math.floor(s/8),u=f[n],m=7-(s&7),p=(u&1<<m)>>m;r<<=1,r|=p}return r},Rt=(f,e,i,r)=>{for(let s=e;s<i;s++){let n=Math.floor(s/8),u=f[n],m=7-(s&7);u&=~(1<<m),u|=(r&1<<i-s-1)>>i-s-1<<m,f[n]=u}};var ni=Symbol("isTarget"),W=class{};ni;var we=class extends W{constructor(){super(...arguments);this.buffer=null}},H=class extends W{constructor(i){super();this.options=i;if(typeof i!="object")throw new TypeError("StreamTarget requires an options object to be passed to its constructor.");if(i.onData){if(typeof i.onData!="function")throw new TypeError("options.onData, when provided, must be a function.");if(i.onData.length<2)throw new TypeError("options.onData, when provided, must be a function that takes in at least two arguments (data and position). Ignoring the position argument, which specifies the byte offset at which the data is to be written, can lead to broken outputs.")}if(i.onHeader&&typeof i.onHeader!="function")throw new TypeError("options.onHeader, when provided, must be a function.");if(i.onCluster&&typeof i.onCluster!="function")throw new TypeError("options.onCluster, when provided, must be a function.");if(i.chunked!==void 0&&typeof i.chunked!="boolean")throw new TypeError("options.chunked, when provided, must be a boolean.");if(i.chunkSize!==void 0&&(!Number.isInteger(i.chunkSize)||i.chunkSize<=0))throw new TypeError("options.chunkSize, when provided, must be a positive integer.")}},pe=class extends W{constructor(i,r){super();this.stream=i;this.options=r;if(!(i instanceof FileSystemWritableFileStream))throw new TypeError("FileSystemWritableFileStreamTarget requires a FileSystemWritableFileStream instance.");if(r!==void 0&&typeof r!="object")throw new TypeError("FileSystemWritableFileStreamTarget's options, when provided, must be an object.");if(r&&r.chunkSize!==void 0&&(!Number.isInteger(r.chunkSize)||r.chunkSize<=0))throw new TypeError("options.chunkSize, when provided, must be a positive integer")}};var S,c,Ke,Ft,qe,Mt,Ie,Pt,Te,gt,Ge,Nt,$e=class{constructor(){a(this,Ke);a(this,qe);a(this,Ie);a(this,Te);a(this,Ge);this.pos=0;a(this,S,new Uint8Array(8));a(this,c,new DataView(t(this,S).buffer));this.offsets=new WeakMap;this.dataOffsets=new WeakMap}seek(e){this.pos=e}writeEBMLVarInt(e,i=Dt(e)){let r=0;switch(i){case 1:t(this,c).setUint8(r++,1<<7|e);break;case 2:t(this,c).setUint8(r++,1<<6|e>>8),t(this,c).setUint8(r++,e);break;case 3:t(this,c).setUint8(r++,1<<5|e>>16),t(this,c).setUint8(r++,e>>8),t(this,c).setUint8(r++,e);break;case 4:t(this,c).setUint8(r++,1<<4|e>>24),t(this,c).setUint8(r++,e>>16),t(this,c).setUint8(r++,e>>8),t(this,c).setUint8(r++,e);break;case 5:t(this,c).setUint8(r++,1<<3|e/2**32&7),t(this,c).setUint8(r++,e>>24),t(this,c).setUint8(r++,e>>16),t(this,c).setUint8(r++,e>>8),t(this,c).setUint8(r++,e);break;case 6:t(this,c).setUint8(r++,1<<2|e/2**40&3),t(this,c).setUint8(r++,e/2**32|0),t(this,c).setUint8(r++,e>>24),t(this,c).setUint8(r++,e>>16),t(this,c).setUint8(r++,e>>8),t(this,c).setUint8(r++,e);break;default:throw new Error("Bad EBML VINT size "+i)}this.write(t(this,S).subarray(0,r))}writeEBML(e){if(e!==null)if(e instanceof Uint8Array)this.write(e);else if(Array.isArray(e))for(let i of e)this.writeEBML(i);else if(this.offsets.set(e,this.pos),o(this,Te,gt).call(this,e.id),Array.isArray(e.data)){let i=this.pos,r=e.size===-1?1:e.size??4;e.size===-1?o(this,Ke,Ft).call(this,255):this.seek(this.pos+r);let s=this.pos;if(this.dataOffsets.set(e,s),this.writeEBML(e.data),e.size!==-1){let n=this.pos-s,u=this.pos;this.seek(i),this.writeEBMLVarInt(n,r),this.seek(u)}}else if(typeof e.data=="number"){let i=e.size??pt(e.data);this.writeEBMLVarInt(i),o(this,Te,gt).call(this,e.data,i)}else typeof e.data=="string"?(this.writeEBMLVarInt(e.data.length),o(this,Ge,Nt).call(this,e.data)):e.data instanceof Uint8Array?(this.writeEBMLVarInt(e.data.byteLength,e.size),this.write(e.data)):e.data instanceof J?(this.writeEBMLVarInt(4),o(this,qe,Mt).call(this,e.data.value)):e.data instanceof _&&(this.writeEBMLVarInt(8),o(this,Ie,Pt).call(this,e.data.value))}};S=new WeakMap,c=new WeakMap,Ke=new WeakSet,Ft=function(e){t(this,c).setUint8(0,e),this.write(t(this,S).subarray(0,1))},qe=new WeakSet,Mt=function(e){t(this,c).setFloat32(0,e,!1),this.write(t(this,S).subarray(0,4))},Ie=new WeakSet,Pt=function(e){t(this,c).setFloat64(0,e,!1),this.write(t(this,S))},Te=new WeakSet,gt=function(e,i=pt(e)){let r=0;switch(i){case 6:t(this,c).setUint8(r++,e/2**40|0);case 5:t(this,c).setUint8(r++,e/2**32|0);case 4:t(this,c).setUint8(r++,e>>24);case 3:t(this,c).setUint8(r++,e>>16);case 2:t(this,c).setUint8(r++,e>>8);case 1:t(this,c).setUint8(r++,e);break;default:throw new Error("Bad UINT size "+i)}this.write(t(this,S).subarray(0,r))},Ge=new WeakSet,Nt=function(e){this.write(new Uint8Array(e.split("").map(i=>i.charCodeAt(0))))};var ke,V,ee,Ce,yt,Be=class extends $e{constructor(i){super();a(this,Ce);a(this,ke,void 0);a(this,V,new ArrayBuffer(2**16));a(this,ee,new Uint8Array(t(this,V)));d(this,ke,i)}write(i){o(this,Ce,yt).call(this,this.pos+i.byteLength),t(this,ee).set(i,this.pos),this.pos+=i.byteLength}finalize(){o(this,Ce,yt).call(this,this.pos),t(this,ke).buffer=t(this,V).slice(0,this.pos)}};ke=new WeakMap,V=new WeakMap,ee=new WeakMap,Ce=new WeakSet,yt=function(i){let r=t(this,V).byteLength;for(;r<i;)r*=2;if(r===t(this,V).byteLength)return;let s=new ArrayBuffer(r),n=new Uint8Array(s);n.set(t(this,ee),0),d(this,V,s),d(this,ee,n)};var $,y,T,D,E=class extends $e{constructor(i){super();this.target=i;a(this,$,!1);a(this,y,void 0);a(this,T,void 0);a(this,D,void 0)}write(i){if(!t(this,$))return;let r=this.pos;if(r<t(this,T)){if(r+i.byteLength<=t(this,T))return;i=i.subarray(t(this,T)-r),r=0}let s=r+i.byteLength-t(this,T),n=t(this,y).byteLength;for(;n<s;)n*=2;if(n!==t(this,y).byteLength){let u=new Uint8Array(n);u.set(t(this,y),0),d(this,y,u)}t(this,y).set(i,r-t(this,T)),d(this,D,Math.max(t(this,D),r+i.byteLength))}startTrackingWrites(){d(this,$,!0),d(this,y,new Uint8Array(2**10)),d(this,T,this.pos),d(this,D,this.pos)}getTrackedWrites(){if(!t(this,$))throw new Error("Can't get tracked writes since nothing was tracked.");let r={data:t(this,y).subarray(0,t(this,D)-t(this,T)),start:t(this,T),end:t(this,D)};return d(this,y,void 0),d(this,$,!1),r}};$=new WeakMap,y=new WeakMap,T=new WeakMap,D=new WeakMap;var R,xe,Se,ge=class extends E{constructor(i,r){super(i);a(this,R,[]);a(this,xe,0);a(this,Se,void 0);d(this,Se,r)}write(i){super.write(i),t(this,R).push({data:i.slice(),start:this.pos}),this.pos+=i.byteLength}flush(){if(t(this,R).length===0)return;let i=[],r=[...t(this,R)].sort((s,n)=>s.start-n.start);i.push({start:r[0].start,size:r[0].data.byteLength});for(let s=1;s<r.length;s++){let n=i[i.length-1],u=r[s];u.start<=n.start+n.size?n.size=Math.max(n.size,u.start+u.data.byteLength-n.start):i.push({start:u.start,size:u.data.byteLength})}for(let s of i){s.data=new Uint8Array(s.size);for(let n of t(this,R))s.start<=n.start&&n.start<s.start+s.size&&s.data.set(n.data,n.start-s.start);if(t(this,Se)&&s.start<t(this,xe))throw new Error("Internal error: Monotonicity violation.");this.target.options.onData?.(s.data,s.start),d(this,xe,s.start+s.data.byteLength)}t(this,R).length=0}finalize(){}};R=new WeakMap,xe=new WeakMap,Se=new WeakMap;var oi=2**24,hi=2,g,w,Ee,Ae,Ue,Tt,Le,_t,Ye,Ot,te,He,ye=class extends E{constructor(i,r){super(i);a(this,Ue);a(this,Le);a(this,Ye);a(this,te);a(this,g,void 0);a(this,w,[]);a(this,Ee,0);a(this,Ae,void 0);if(d(this,g,i.options?.chunkSize??oi),d(this,Ae,r),!Number.isInteger(t(this,g))||t(this,g)<2**10)throw new Error("Invalid StreamTarget options: chunkSize must be an integer not smaller than 1024.")}write(i){super.write(i),o(this,Ue,Tt).call(this,i,this.pos),o(this,te,He).call(this),this.pos+=i.byteLength}finalize(){o(this,te,He).call(this,!0)}};g=new WeakMap,w=new WeakMap,Ee=new WeakMap,Ae=new WeakMap,Ue=new WeakSet,Tt=function(i,r){let s=t(this,w).findIndex(b=>b.start<=r&&r<b.start+t(this,g));s===-1&&(s=o(this,Ye,Ot).call(this,r));let n=t(this,w)[s],u=r-n.start,m=i.subarray(0,Math.min(t(this,g)-u,i.byteLength));n.data.set(m,u);let p={start:u,end:u+m.byteLength};if(o(this,Le,_t).call(this,n,p),n.written[0].start===0&&n.written[0].end===t(this,g)&&(n.shouldFlush=!0),t(this,w).length>hi){for(let b=0;b<t(this,w).length-1;b++)t(this,w)[b].shouldFlush=!0;o(this,te,He).call(this)}m.byteLength<i.byteLength&&o(this,Ue,Tt).call(this,i.subarray(m.byteLength),r+m.byteLength)},Le=new WeakSet,_t=function(i,r){let s=0,n=i.written.length-1,u=-1;for(;s<=n;){let m=Math.floor(s+(n-s+1)/2);i.written[m].start<=r.start?(s=m+1,u=m):n=m-1}for(i.written.splice(u+1,0,r),(u===-1||i.written[u].end<r.start)&&u++;u<i.written.length-1&&i.written[u].end>=i.written[u+1].start;)i.written[u].end=Math.max(i.written[u].end,i.written[u+1].end),i.written.splice(u+1,1)},Ye=new WeakSet,Ot=function(i){let s={start:Math.floor(i/t(this,g))*t(this,g),data:new Uint8Array(t(this,g)),written:[],shouldFlush:!1};return t(this,w).push(s),t(this,w).sort((n,u)=>n.start-u.start),t(this,w).indexOf(s)},te=new WeakSet,He=function(i=!1){for(let r=0;r<t(this,w).length;r++){let s=t(this,w)[r];if(!(!s.shouldFlush&&!i)){for(let n of s.written){if(t(this,Ae)&&s.start+n.start<t(this,Ee))throw new Error("Internal error: Monotonicity violation.");this.target.options.onData?.(s.data.subarray(n.start,n.end),s.start+n.start),d(this,Ee,s.start+n.end)}t(this,w).splice(r--,1)}}};var je=class extends ye{constructor(e,i){super(new H({onData:(r,s)=>e.stream.write({type:"write",data:r,position:s}),chunked:!0,chunkSize:e.options?.chunkSize}),i)}};var ie=1,ve=2,Ze=3,di=1,ui=2,li=17,kt=2**15,ze=2**12,Wt="https://github.com/Vanilagy/webm-muxer",Ht=6,$t=5,fi=["strict","offset","permissive"],l,h,ae,ne,x,B,j,F,K,U,q,I,k,G,L,v,z,M,oe,he,Y,Z,De,de,ue,tt,Bt,it,jt,rt,Kt,st,qt,at,It,nt,Gt,ot,Lt,Re,xt,Fe,St,ht,Yt,P,re,N,se,dt,Zt,ut,Qt,le,Qe,fe,Xe,lt,Xt,C,A,Q,Ve,ce,Je,ft,Jt,Me,Et,me,et,Ct=class{constructor(e){a(this,tt);a(this,it);a(this,rt);a(this,st);a(this,at);a(this,nt);a(this,ot);a(this,Re);a(this,Fe);a(this,ht);a(this,P);a(this,N);a(this,dt);a(this,ut);a(this,le);a(this,fe);a(this,lt);a(this,C);a(this,Q);a(this,ce);a(this,ft);a(this,Me);a(this,me);a(this,l,void 0);a(this,h,void 0);a(this,ae,void 0);a(this,ne,void 0);a(this,x,void 0);a(this,B,void 0);a(this,j,void 0);a(this,F,void 0);a(this,K,void 0);a(this,U,void 0);a(this,q,void 0);a(this,I,void 0);a(this,k,void 0);a(this,G,void 0);a(this,L,0);a(this,v,[]);a(this,z,[]);a(this,M,[]);a(this,oe,void 0);a(this,he,void 0);a(this,Y,-1);a(this,Z,-1);a(this,De,-1);a(this,de,void 0);a(this,ue,!1);o(this,tt,Bt).call(this,e),d(this,l,{type:"webm",firstTimestampBehavior:"strict",...e}),this.target=e.target;let i=!!t(this,l).streaming;if(e.target instanceof we)d(this,h,new Be(e.target));else if(e.target instanceof H)d(this,h,e.target.options?.chunked?new ye(e.target,i):new ge(e.target,i));else if(e.target instanceof pe)d(this,h,new je(e.target,i));else throw new Error(`Invalid target: ${e.target}`);o(this,it,jt).call(this)}addVideoChunk(e,i,r){if(!(e instanceof EncodedVideoChunk))throw new TypeError("addVideoChunk's first argument (chunk) must be of type EncodedVideoChunk.");if(i&&typeof i!="object")throw new TypeError("addVideoChunk's second argument (meta), when provided, must be an object.");if(r!==void 0&&(!Number.isFinite(r)||r<0))throw new TypeError("addVideoChunk's third argument (timestamp), when provided, must be a non-negative real number.");let s=new Uint8Array(e.byteLength);e.copyTo(s),this.addVideoChunkRaw(s,e.type,r??e.timestamp,i)}addVideoChunkRaw(e,i,r,s){if(!(e instanceof Uint8Array))throw new TypeError("addVideoChunkRaw's first argument (data) must be an instance of Uint8Array.");if(i!=="key"&&i!=="delta")throw new TypeError("addVideoChunkRaw's second argument (type) must be either 'key' or 'delta'.");if(!Number.isFinite(r)||r<0)throw new TypeError("addVideoChunkRaw's third argument (timestamp) must be a non-negative real number.");if(s&&typeof s!="object")throw new TypeError("addVideoChunkRaw's fourth argument (meta), when provided, must be an object.");if(o(this,me,et).call(this),!t(this,l).video)throw new Error("No video track declared.");t(this,oe)===void 0&&d(this,oe,r),s&&o(this,dt,Zt).call(this,s);let n=o(this,fe,Xe).call(this,e,i,r,ie);for(t(this,l).video.codec==="V_VP9"&&o(this,ut,Qt).call(this,n),d(this,Y,n.timestamp);t(this,z).length>0&&t(this,z)[0].timestamp<=n.timestamp;){let u=t(this,z).shift();o(this,C,A).call(this,u,!1)}!t(this,l).audio||n.timestamp<=t(this,Z)?o(this,C,A).call(this,n,!0):t(this,v).push(n),o(this,le,Qe).call(this),o(this,P,re).call(this)}addAudioChunk(e,i,r){if(!(e instanceof EncodedAudioChunk))throw new TypeError("addAudioChunk's first argument (chunk) must be of type EncodedAudioChunk.");if(i&&typeof i!="object")throw new TypeError("addAudioChunk's second argument (meta), when provided, must be an object.");if(r!==void 0&&(!Number.isFinite(r)||r<0))throw new TypeError("addAudioChunk's third argument (timestamp), when provided, must be a non-negative real number.");let s=new Uint8Array(e.byteLength);e.copyTo(s),this.addAudioChunkRaw(s,e.type,r??e.timestamp,i)}addAudioChunkRaw(e,i,r,s){if(!(e instanceof Uint8Array))throw new TypeError("addAudioChunkRaw's first argument (data) must be an instance of Uint8Array.");if(i!=="key"&&i!=="delta")throw new TypeError("addAudioChunkRaw's second argument (type) must be either 'key' or 'delta'.");if(!Number.isFinite(r)||r<0)throw new TypeError("addAudioChunkRaw's third argument (timestamp) must be a non-negative real number.");if(s&&typeof s!="object")throw new TypeError("addAudioChunkRaw's fourth argument (meta), when provided, must be an object.");if(o(this,me,et).call(this),!t(this,l).audio)throw new Error("No audio track declared.");t(this,he)===void 0&&d(this,he,r),s?.decoderConfig&&(t(this,l).streaming?d(this,U,o(this,Q,Ve).call(this,s.decoderConfig.description)):o(this,ce,Je).call(this,t(this,U),s.decoderConfig.description));let n=o(this,fe,Xe).call(this,e,i,r,ve);for(d(this,Z,n.timestamp);t(this,v).length>0&&t(this,v)[0].timestamp<=n.timestamp;){let u=t(this,v).shift();o(this,C,A).call(this,u,!0)}!t(this,l).video||n.timestamp<=t(this,Y)?o(this,C,A).call(this,n,!t(this,l).video):t(this,z).push(n),o(this,le,Qe).call(this),o(this,P,re).call(this)}addSubtitleChunk(e,i,r){if(typeof e!="object"||!e)throw new TypeError("addSubtitleChunk's first argument (chunk) must be an object.");if(!(e.body instanceof Uint8Array))throw new TypeError("body must be an instance of Uint8Array.");if(!Number.isFinite(e.timestamp)||e.timestamp<0)throw new TypeError("timestamp must be a non-negative real number.");if(!Number.isFinite(e.duration)||e.duration<0)throw new TypeError("duration must be a non-negative real number.");if(e.additions&&!(e.additions instanceof Uint8Array))throw new TypeError("additions, when present, must be an instance of Uint8Array.");if(typeof i!="object")throw new TypeError("addSubtitleChunk's second argument (meta) must be an object.");if(o(this,me,et).call(this),!t(this,l).subtitles)throw new Error("No subtitle track declared.");i?.decoderConfig&&(t(this,l).streaming?d(this,q,o(this,Q,Ve).call(this,i.decoderConfig.description)):o(this,ce,Je).call(this,t(this,q),i.decoderConfig.description));let s=o(this,fe,Xe).call(this,e.body,"key",r??e.timestamp,Ze,e.duration,e.additions);d(this,De,s.timestamp),t(this,M).push(s),o(this,le,Qe).call(this),o(this,P,re).call(this)}finalize(){if(t(this,ue))throw new Error("Cannot finalize a muxer more than once.");for(;t(this,v).length>0;)o(this,C,A).call(this,t(this,v).shift(),!0);for(;t(this,z).length>0;)o(this,C,A).call(this,t(this,z).shift(),!0);for(;t(this,M).length>0&&t(this,M)[0].timestamp<=t(this,L);)o(this,C,A).call(this,t(this,M).shift(),!1);if(t(this,k)&&!t(this,l).streaming&&o(this,Me,Et).call(this),t(this,h).writeEBML(t(this,I)),!t(this,l).streaming){let e=t(this,h).pos,i=t(this,h).pos-t(this,N,se);t(this,h).seek(t(this,h).offsets.get(t(this,ae))+4),t(this,h).writeEBMLVarInt(i,Ht),t(this,j).data=new _(t(this,L)),t(this,h).seek(t(this,h).offsets.get(t(this,j))),t(this,h).writeEBML(t(this,j)),t(this,x).data[0].data[1].data=t(this,h).offsets.get(t(this,I))-t(this,N,se),t(this,x).data[1].data[1].data=t(this,h).offsets.get(t(this,ne))-t(this,N,se),t(this,x).data[2].data[1].data=t(this,h).offsets.get(t(this,B))-t(this,N,se),t(this,h).seek(t(this,h).offsets.get(t(this,x))),t(this,h).writeEBML(t(this,x)),t(this,h).seek(e)}o(this,P,re).call(this),t(this,h).finalize(),d(this,ue,!0)}};l=new WeakMap,h=new WeakMap,ae=new WeakMap,ne=new WeakMap,x=new WeakMap,B=new WeakMap,j=new WeakMap,F=new WeakMap,K=new WeakMap,U=new WeakMap,q=new WeakMap,I=new WeakMap,k=new WeakMap,G=new WeakMap,L=new WeakMap,v=new WeakMap,z=new WeakMap,M=new WeakMap,oe=new WeakMap,he=new WeakMap,Y=new WeakMap,Z=new WeakMap,De=new WeakMap,de=new WeakMap,ue=new WeakMap,tt=new WeakSet,Bt=function(e){if(typeof e!="object")throw new TypeError("The muxer requires an options object to be passed to its constructor.");if(!(e.target instanceof W))throw new TypeError("The target must be provided and an instance of Target.");if(e.video){if(typeof e.video.codec!="string")throw new TypeError(`Invalid video codec: ${e.video.codec}. Must be a string.`);if(!Number.isInteger(e.video.width)||e.video.width<=0)throw new TypeError(`Invalid video width: ${e.video.width}. Must be a positive integer.`);if(!Number.isInteger(e.video.height)||e.video.height<=0)throw new TypeError(`Invalid video height: ${e.video.height}. Must be a positive integer.`);if(e.video.frameRate!==void 0&&(!Number.isFinite(e.video.frameRate)||e.video.frameRate<=0))throw new TypeError(`Invalid video frame rate: ${e.video.frameRate}. Must be a positive number.`);if(e.video.alpha!==void 0&&typeof e.video.alpha!="boolean")throw new TypeError(`Invalid video alpha: ${e.video.alpha}. Must be a boolean.`)}if(e.audio){if(typeof e.audio.codec!="string")throw new TypeError(`Invalid audio codec: ${e.audio.codec}. Must be a string.`);if(!Number.isInteger(e.audio.numberOfChannels)||e.audio.numberOfChannels<=0)throw new TypeError(`Invalid number of audio channels: ${e.audio.numberOfChannels}. Must be a positive integer.`);if(!Number.isInteger(e.audio.sampleRate)||e.audio.sampleRate<=0)throw new TypeError(`Invalid audio sample rate: ${e.audio.sampleRate}. Must be a positive integer.`);if(e.audio.bitDepth!==void 0&&(!Number.isInteger(e.audio.bitDepth)||e.audio.bitDepth<=0))throw new TypeError(`Invalid audio bit depth: ${e.audio.bitDepth}. Must be a positive integer.`)}if(e.subtitles&&typeof e.subtitles.codec!="string")throw new TypeError(`Invalid subtitles codec: ${e.subtitles.codec}. Must be a string.`);if(e.type!==void 0&&!["webm","matroska"].includes(e.type))throw new TypeError(`Invalid type: ${e.type}. Must be 'webm' or 'matroska'.`);if(e.firstTimestampBehavior&&!fi.includes(e.firstTimestampBehavior))throw new TypeError(`Invalid first timestamp behavior: ${e.firstTimestampBehavior}`);if(e.streaming!==void 0&&typeof e.streaming!="boolean")throw new TypeError(`Invalid streaming option: ${e.streaming}. Must be a boolean.`)},it=new WeakSet,jt=function(){t(this,h)instanceof E&&t(this,h).target.options.onHeader&&t(this,h).startTrackingWrites(),o(this,rt,Kt).call(this),t(this,l).streaming||o(this,nt,Gt).call(this),o(this,ot,Lt).call(this),o(this,st,qt).call(this),o(this,at,It).call(this),t(this,l).streaming||(o(this,Re,xt).call(this),o(this,Fe,St).call(this)),o(this,ht,Yt).call(this),o(this,P,re).call(this)},rt=new WeakSet,Kt=function(){let e={id:440786851,data:[{id:17030,data:1},{id:17143,data:1},{id:17138,data:4},{id:17139,data:8},{id:17026,data:t(this,l).type??"webm"},{id:17031,data:2},{id:17029,data:2}]};t(this,h).writeEBML(e)},st=new WeakSet,qt=function(){d(this,K,{id:236,size:4,data:new Uint8Array(ze)}),d(this,U,{id:236,size:4,data:new Uint8Array(ze)}),d(this,q,{id:236,size:4,data:new Uint8Array(ze)})},at=new WeakSet,It=function(){d(this,F,{id:21936,data:[{id:21937,data:2},{id:21946,data:2},{id:21947,data:2},{id:21945,data:0}]})},nt=new WeakSet,Gt=function(){let e=new Uint8Array([28,83,187,107]),i=new Uint8Array([21,73,169,102]),r=new Uint8Array([22,84,174,107]),s={id:290298740,data:[{id:19899,data:[{id:21419,data:e},{id:21420,size:5,data:0}]},{id:19899,data:[{id:21419,data:i},{id:21420,size:5,data:0}]},{id:19899,data:[{id:21419,data:r},{id:21420,size:5,data:0}]}]};d(this,x,s)},ot=new WeakSet,Lt=function(){let e={id:17545,data:new _(0)};d(this,j,e);let i={id:357149030,data:[{id:2807729,data:1e6},{id:19840,data:Wt},{id:22337,data:Wt},t(this,l).streaming?null:e]};d(this,ne,i)},Re=new WeakSet,xt=function(){let e={id:374648427,data:[]};d(this,B,e),t(this,l).video&&e.data.push({id:174,data:[{id:215,data:ie},{id:29637,data:ie},{id:131,data:di},{id:134,data:t(this,l).video.codec},t(this,K),t(this,l).video.frameRate?{id:2352003,data:1e9/t(this,l).video.frameRate}:null,{id:224,data:[{id:176,data:t(this,l).video.width},{id:186,data:t(this,l).video.height},t(this,l).video.alpha?{id:21440,data:1}:null,t(this,F)]}]}),t(this,l).audio&&(d(this,U,t(this,l).streaming?t(this,U)||null:{id:236,size:4,data:new Uint8Array(ze)}),e.data.push({id:174,data:[{id:215,data:ve},{id:29637,data:ve},{id:131,data:ui},{id:134,data:t(this,l).audio.codec},t(this,U),{id:225,data:[{id:181,data:new J(t(this,l).audio.sampleRate)},{id:159,data:t(this,l).audio.numberOfChannels},t(this,l).audio.bitDepth?{id:25188,data:t(this,l).audio.bitDepth}:null]}]})),t(this,l).subtitles&&e.data.push({id:174,data:[{id:215,data:Ze},{id:29637,data:Ze},{id:131,data:li},{id:134,data:t(this,l).subtitles.codec},t(this,q)]})},Fe=new WeakSet,St=function(){let e={id:408125543,size:t(this,l).streaming?-1:Ht,data:[t(this,l).streaming?null:t(this,x),t(this,ne),t(this,B)]};if(d(this,ae,e),t(this,h).writeEBML(e),t(this,h)instanceof E&&t(this,h).target.options.onHeader){let{data:i,start:r}=t(this,h).getTrackedWrites();t(this,h).target.options.onHeader(i,r)}},ht=new WeakSet,Yt=function(){d(this,I,{id:475249515,data:[]})},P=new WeakSet,re=function(){t(this,h)instanceof ge&&t(this,h).flush()},N=new WeakSet,se=function(){return t(this,h).dataOffsets.get(t(this,ae))},dt=new WeakSet,Zt=function(e){if(!!e.decoderConfig){if(e.decoderConfig.colorSpace){let i=e.decoderConfig.colorSpace;if(d(this,de,i),t(this,F).data=[{id:21937,data:{rgb:1,bt709:1,bt470bg:5,smpte170m:6}[i.matrix]},{id:21946,data:{bt709:1,smpte170m:6,"iec61966-2-1":13}[i.transfer]},{id:21947,data:{bt709:1,bt470bg:5,smpte170m:6}[i.primaries]},{id:21945,data:[1,2][Number(i.fullRange)]}],!t(this,l).streaming){let r=t(this,h).pos;t(this,h).seek(t(this,h).offsets.get(t(this,F))),t(this,h).writeEBML(t(this,F)),t(this,h).seek(r)}}e.decoderConfig.description&&(t(this,l).streaming?d(this,K,o(this,Q,Ve).call(this,e.decoderConfig.description)):o(this,ce,Je).call(this,t(this,K),e.decoderConfig.description))}},ut=new WeakSet,Qt=function(e){if(e.type!=="key"||!t(this,de))return;let i=0;if(O(e.data,0,2)!==2)return;i+=2;let r=(O(e.data,i+1,i+2)<<1)+O(e.data,i+0,i+1);i+=2,r===3&&i++;let s=O(e.data,i+0,i+1);if(i++,s)return;let n=O(e.data,i+0,i+1);if(i++,n!==0)return;i+=2;let u=O(e.data,i+0,i+24);if(i+=24,u!==4817730)return;r>=2&&i++;let m={rgb:7,bt709:2,bt470bg:1,smpte170m:3}[t(this,de).matrix];Rt(e.data,i+0,i+3,m)},le=new WeakSet,Qe=function(){let e=Math.min(t(this,l).video?t(this,Y):1/0,t(this,l).audio?t(this,Z):1/0),i=t(this,M);for(;i.length>0&&i[0].timestamp<=e;)o(this,C,A).call(this,i.shift(),!t(this,l).video&&!t(this,l).audio)},fe=new WeakSet,Xe=function(e,i,r,s,n,u){let m=o(this,lt,Xt).call(this,r,s);return{data:e,additions:u,type:i,timestamp:m,duration:n,trackNumber:s}},lt=new WeakSet,Xt=function(e,i){let r=i===ie?t(this,Y):i===ve?t(this,Z):t(this,De);if(i!==Ze){let s=i===ie?t(this,oe):t(this,he);if(t(this,l).firstTimestampBehavior==="strict"&&r===-1&&e!==0)throw new Error(`The first chunk for your media track must have a timestamp of 0 (received ${e}). Non-zero first timestamps are often caused by directly piping frames or audio data from a MediaStreamTrack into the encoder. Their timestamps are typically relative to the age of the document, which is probably what you want.

If you want to offset all timestamps of a track such that the first one is zero, set firstTimestampBehavior: 'offset' in the options.
If you want to allow non-zero first timestamps, set firstTimestampBehavior: 'permissive'.
`);t(this,l).firstTimestampBehavior==="offset"&&(e-=s)}if(e<r)throw new Error(`Timestamps must be monotonically increasing (went from ${r} to ${e}).`);if(e<0)throw new Error(`Timestamps must be non-negative (received ${e}).`);return e},C=new WeakSet,A=function(e,i){t(this,l).streaming&&!t(this,B)&&(o(this,Re,xt).call(this),o(this,Fe,St).call(this));let r=Math.floor(e.timestamp/1e3),s=i&&e.type==="key"&&r-t(this,G)>=1e3;(!t(this,k)||s)&&o(this,ft,Jt).call(this,r);let n=r-t(this,G);if(n<0)return;if(n>=kt)throw new Error(`Current Matroska cluster exceeded its maximum allowed length of ${kt} milliseconds. In order to produce a correct WebM file, you must pass in a key frame at least every ${kt} milliseconds.`);let m=new Uint8Array(4),p=new DataView(m.buffer);if(p.setUint8(0,128|e.trackNumber),p.setInt16(1,n,!1),e.duration===void 0&&!e.additions){p.setUint8(3,Number(e.type==="key")<<7);let b={id:163,data:[m,e.data]};t(this,h).writeEBML(b)}else{let b=Math.floor(e.duration/1e3),vt={id:160,data:[{id:161,data:[m,e.data]},e.duration!==void 0?{id:155,data:b}:null,e.additions?{id:30113,data:e.additions}:null]};t(this,h).writeEBML(vt)}d(this,L,Math.max(t(this,L),r))},Q=new WeakSet,Ve=function(e){return{id:25506,size:4,data:new Uint8Array(e)}},ce=new WeakSet,Je=function(e,i){let r=t(this,h).pos;t(this,h).seek(t(this,h).offsets.get(e));let s=2+4+i.byteLength,n=ze-s;if(n<0){let u=i.byteLength+n;i instanceof ArrayBuffer?i=i.slice(0,u):i=i.buffer.slice(0,u),n=0}e=[o(this,Q,Ve).call(this,i),{id:236,size:4,data:new Uint8Array(n)}],t(this,h).writeEBML(e),t(this,h).seek(r)},ft=new WeakSet,Jt=function(e){t(this,k)&&!t(this,l).streaming&&o(this,Me,Et).call(this),t(this,h)instanceof E&&t(this,h).target.options.onCluster&&t(this,h).startTrackingWrites(),d(this,k,{id:524531317,size:t(this,l).streaming?-1:$t,data:[{id:231,data:e}]}),t(this,h).writeEBML(t(this,k)),d(this,G,e);let i=t(this,h).offsets.get(t(this,k))-t(this,N,se);t(this,I).data.push({id:187,data:[{id:179,data:e},t(this,l).video?{id:183,data:[{id:247,data:ie},{id:241,data:i}]}:null,t(this,l).audio?{id:183,data:[{id:247,data:ve},{id:241,data:i}]}:null]})},Me=new WeakSet,Et=function(){let e=t(this,h).pos-t(this,h).dataOffsets.get(t(this,k)),i=t(this,h).pos;if(t(this,h).seek(t(this,h).offsets.get(t(this,k))+4),t(this,h).writeEBMLVarInt(e,$t),t(this,h).seek(i),t(this,h)instanceof E&&t(this,h).target.options.onCluster){let{data:r,start:s}=t(this,h).getTrackedWrites();t(this,h).target.options.onCluster(r,s,t(this,G))}},me=new WeakSet,et=function(){if(t(this,ue))throw new Error("Cannot add new video or audio chunks after the file has been finalized.")};var Pe=/(?:(.+?)\n)?((?:\d{2}:)?\d{2}:\d{2}.\d{3})\s+-->\s+((?:\d{2}:)?\d{2}:\d{2}.\d{3})/g,ci=/^WEBVTT.*?\n{2}/,mi=/(?:(\d{2}):)?(\d{2}):(\d{2}).(\d{3})/,ei=/<(?:(\d{2}):)?(\d{2}):(\d{2}).(\d{3})>/g,At=new TextEncoder,X,Ne,_e,Oe,We,be,ct,mt,ti,Ut=class{constructor(e){a(this,be);a(this,mt);a(this,X,void 0);a(this,Ne,void 0);a(this,_e,!1);a(this,Oe,void 0);a(this,We,!1);d(this,X,e)}configure(e){if(e.codec!=="webvtt")throw new Error("Codec must be 'webvtt'.");d(this,Ne,e)}encode(e){if(!t(this,Ne))throw new Error("Encoder not configured.");e=e.replace(`\r
`,`
`).replace("\r",`
`),Pe.lastIndex=0;let i;if(!t(this,_e)){if(!ci.test(e)){let s=new Error("WebVTT preamble incorrect.");throw t(this,X).error(s),s}i=Pe.exec(e);let r=e.slice(0,i?.index??e.length).trimEnd();if(!r){let s=new Error("No WebVTT preamble provided.");throw t(this,X).error(s),s}d(this,Oe,At.encode(r)),d(this,_e,!0),i&&(e=e.slice(i.index),Pe.lastIndex=0)}for(;i=Pe.exec(e);){let r=e.slice(0,i.index),s=i[1]||"",n=i.index+i[0].length,u=e.indexOf(`
`,n)+1,m=e.slice(n,u).trim(),p=e.indexOf(`

`,n);p===-1&&(p=e.length);let b=o(this,be,ct).call(this,i[2]),ii=o(this,be,ct).call(this,i[3])-b,bt=e.slice(u,p),zt=`${m}
${s}
${r}`;ei.lastIndex=0,bt=bt.replace(ei,si=>{let ai=o(this,be,ct).call(this,si.slice(1,-1))-b;return`<${o(this,mt,ti).call(this,ai)}>`}),e=e.slice(p).trimStart(),Pe.lastIndex=0;let ri={body:At.encode(bt),additions:zt.trim()===""?void 0:At.encode(zt),timestamp:b*1e3,duration:ii*1e3},Vt={};t(this,We)||(Vt.decoderConfig={description:t(this,Oe)},d(this,We,!0)),t(this,X).output(ri,Vt)}}};X=new WeakMap,Ne=new WeakMap,_e=new WeakMap,Oe=new WeakMap,We=new WeakMap,be=new WeakSet,ct=function(e){let i=mi.exec(e);if(!i)throw new Error("Expected match.");return 60*60*1e3*Number(i[1]||"0")+60*1e3*Number(i[2])+1e3*Number(i[3])+Number(i[4])},mt=new WeakSet,ti=function(e){let i=Math.floor(e/36e5),r=Math.floor(e%(60*60*1e3)/(60*1e3)),s=Math.floor(e%(60*1e3)/1e3),n=e%1e3;return i.toString().padStart(2,"0")+":"+r.toString().padStart(2,"0")+":"+s.toString().padStart(2,"0")+"."+n.toString().padStart(3,"0")};export{we as ArrayBufferTarget,pe as FileSystemWritableFileStreamTarget,Ct as Muxer,H as StreamTarget,Ut as SubtitleEncoder};
