# -*- coding: UTF-8 -*-

import random

up = 0
down = 0
change = 0
n2str = {1: "天", 2: "泽", 3: "火", 4: "雷", 5: "风", 6: "水", 7: "山", 8: "地", }
m = {
    "11": {
        "name": "乾为天卦",
        "guaci": """
　　《乾》：元，亨，利，贞。
----------------------------
　　 初九：潜龙，勿用。
　　 九二：见龙在田，利见大人。
　　 九三：君子终日乾乾，夕惕若。厉无咎。
　　 九四：或跃在渊，无咎。
　　 九五：飞龙在天，利见大人。
　　 上九：亢龙，有悔。
　　 用九：见群龙无首，吉。
　　 《彖》曰：大哉乾元，万物资始，乃统天。云行雨施，品物流形。大明终始，六位时成。时乘六龙以御天。乾道变化，各正性命。保合大和，乃利贞。首出庶物，万国威宁。
　　 《象》曰：天行健，君子以自强不息。“潜龙勿用”，阳在下也。“见龙在田”，德施普也。“终日乾乾”，反复道也。“或跃在渊”，进无咎也。“飞龙在天”，大人造也。“亢龙有悔”，盈不可久也。“用九”，天德不可为首也。
　　 《文言》曰：“元”者，善之长也；“亨”者，嘉之会也；“利”者，义之和也；“贞”者，事之干也。君子体仁，足以长人；嘉会，足以合礼；利物，足以和义；贞固，足以干事。君子行此四德者，故曰“乾：元、亨、利、贞。”斋
　　 初九曰“潜龙勿用”，何谓也？子曰：“龙，德而隐者也。不易乎世，不成乎名，遯世无闷，不见是而无闷。乐则行之，忧则违之，确乎其不可拔，潜龙也。”知
　　 九二曰“见龙在田，利见大人”，何谓也？子曰：“龙德而正中者也。庸言之信，庸行之谨，闲邪存其诚，善世而不伐，德博而化。《易》曰：‘见龙在田，利见大人’，君德也。”主
　　 九三曰“君子终日乾乾，夕惕若，厉无咎”，何谓也？子曰：“君子进德修业。忠信所以进德也。修辞立其诚，所以居业也。知至至之，可与言几也。知终终之，可与存义也。是故居上位而不骄，在下位而不忧，故乾乾因其时而惕，虽危无咎矣。”主
　　 九四曰“或跃在渊，无咎”，何谓也？子曰：“上下无常，非为邪也。进退无恒，非离群也。君子进德修业，欲及时也，故无咎。”古
　　 九五曰“飞龙在天，利见大人”，何谓也？子曰：“同声相应，同气相求。水流湿，火就燥，云従龙，风従虎，圣人作而万物睹。本乎天者亲上，本乎地者亲下，则各従其类也。”知
　　 上九曰“亢龙有悔”，何谓也？子曰：“贵而无位，高而无民，贤人在下位而无辅，是以动而有悔也。”斋
　　 “潜龙勿用”，下也。“见龙在田”，时舍也。“终日乾乾”，行事也。“或跃在渊”，自试也。“飞龙在天”，上治也。“亢龙有悔”，穷之灾也。乾元“用九”，天下治也。
　　 “潜龙勿用”，阳气潜藏。“见龙在田”，天下文明。“终日乾乾”，与时偕行。“或跃在渊”，乾道乃革。“飞龙在天”，乃位乎天德。“亢龙有悔”，与时偕极。乾元“用九”，乃是天则。
　　 《乾》“元”者，始而亨者也。“利贞”者，性情也。乾始能以美利利天下，不言所利，大矣哉！大哉乾乎！刚健中正，纯粹精也。六爻发挥，旁通情也。“时乘六龙”，以“御天”也。“云行雨施”，天下平也。君子以成德为行，日可见之行也。“潜”之为言也，隐而未见，行而未成，是以君子“弗用”也。
　　 君子学以聚之，问以辩之，宽以居之，仁以行之。《易》曰：见龙在田，利见大人”，君德也。
　　 九三重刚而不中，上不在天，下不在田，故乾乾因其时而惕，虽危无咎矣。
　　 九四重刚而不中，上不在天，下不在田，中不在人，故“或”之。“或”之者，疑之也，故“无咎”。
　　 夫“大人”者，与天地合其德，与日月合其明，与四时合其序，与鬼神合其吉凶，先天而天弗违，后天而奉天时。天且弗违，而况于人乎？况于鬼神乎？主
　　 “亢”之为言也，知进而不知退，知存而不知亡，知得而不知丧。其唯圣人乎！知进退存亡而不失其正者，其唯圣人乎！
----------------------------
[1]乾（读音qián）：卦名。象征天，含有“健”的意思，“健”也称为乾卦的卦德。《周易集解》：“言天之体以健为用，运行不息，应化无穷，故圣人则之。欲使人法天之用，不法天之体，故名‘乾’，不名天也”。
        """},

    "88": {
        "name": "坤为地卦",
        "guaci": """
　　 《坤》：元亨。利牝马之贞。君子有攸往，先迷，後得主，利。西南得朋，东北丧朋。安贞吉。
----------------------------
　　 《彖》曰：至哉坤元，万物资生，乃顺承天。坤厚载物，德合无疆。含弘光大，品物咸亨。牝马地类，行地无疆，柔顺利贞。君子。君子攸行，先迷失道，後顺得常。西南得朋，乃与类行。东北丧朋，乃终有庆。安贞之吉，应地无疆。
　　 《象》曰：地势坤。君子以厚德载物。
　　 初六：履霜，坚冰至。
　　 《象》曰：“履霜坚冰”，阴始凝也，驯致其道，至坚冰也。
　　 六二，直方大，不习，无不利。
　　 《象》曰：六二之动，直以方也。“不习无不利”，地道光也。
　　 六三，含章可贞，或从王事，无成有终。
　　 《象》曰“含章可贞”，以时发也。“或従王事”，知光大也。
　　 六四，括囊，无咎无誉。
　　 《象》曰：“括囊无咎”，慎不害也。
　　 六五，黄裳，元吉。
　　 《象》曰：“黄裳元吉”，文在中也。
　　 上六，龙战于野，其血玄黄。
　　 《象》曰：“龙战于野”，共道穷也。
　　 用六，利永贞。
　　 《象》曰：用六“永贞”，以大终也。
　　 《文言》曰：坤至柔而动也刚，至静而德方，后得主而有常，含万物而化光。坤道其顺乎，承天而时行。积善之家必有余庆，积不善之家必有余殃。臣弑其君，子弑其父，非一朝一夕之故，其所由来者渐矣，由辩之不早辩也。《易》曰：“履霜，坚冰至”，盖言顺也。
　　 “直”其正也，“方”其义也。君子敬以直内，义以方外，敬义立而德不孤。“直、方、大，不习无不利”，则不疑其所行也。
　　 阴虽有美，“含”之以従王事，弗敢成也。地道也，妻道也，臣道也，地道无成而代有终也。
　　 天地变化，草木蕃。天地闭，贤人隐。《易》曰：“括囊，无咎无誉”，盖言谨也。
　　 君子黄中通理，正位居体，美在其中而畅于四支，发于事业，美之至也。
　　 阴疑于阳必战，为其嫌于无阳也，故称“龙”焉。犹未离其类也，故称“血”焉。夫玄黄者，天地之杂也，天玄而地黄。
----------------------------
[1]坤：卦名，象征地。地载万物，也可使万物归隐，所以坤有归与藏的意思。坤卦是唯一的纯阴卦，是“至柔”、“至静”之卦。
充分体现了大地之美，女性之美，阴柔之美。坤为大地，承载万物，顺应天时，化育万物，大地具有宽厚、包容、正直、宏大、安静的胸怀，值得我们好好学习。
        """
    },
    "64": {
        "name": "水雷屯卦。",
        "guaci": """
----------------------------
　　《屯》：元亨，利贞。勿用有攸往。利建侯。
　　 《彖》曰：屯，刚柔始交而难生。动乎险中，大亨贞。雷雨之动满盈，天造草昧。宜寻建侯而不宁。
　　 《象》曰：云雷，屯。君子以经纶。
　　 初九，磐桓，利居贞。利建侯。
　　 《象》曰：虽磐桓，志行正也。以贵下贱，大得民也。
　　 六二，屯如邅如，乘马班如。匪寇，婚媾。女子贞不字，十年乃字。
　　 《象》曰：六二之难，乘刚也。十年乃字，反常也。
　　 六三，即鹿无虞，惟入于林中，君子几不如舍，往吝。
　　 《象》曰：“即鹿无虞”，以従禽也。君子舍之，往吝穷也。
　　 六四，乘马班如，求婚媾。往吉，无不利。
　　 《象》曰：求而往，明也。
　　 九五，屯其膏，小，贞吉；大，贞凶。
　　 《象》曰：“屯其膏”，施未光也。
　　 上六，乘马班如，泣血涟如。
　　 《象》曰：“泣血涟如”，何可长也。
----------------------------
[1]屯：卦名，象征事物的初生与萌芽。屯者，物之初生也。故屯象征初生。像种子萌芽，破土而出，萌生、破土多有艰难，所以有“难”义。
初生之物应当强根固本，不可轻动。但此时也是王者建功立业的时候，所以应该坚定信念产，积极进取，不可安居无事。

        """
    },
    "76": {
        "name": "山水蒙卦",
        "guaci": """
　　 《蒙》：亨。匪我求童蒙，童蒙求我。初筮告，再三渎，渎则不告。利贞。
----------------------------
　　 《彖》曰：蒙，山下有险，险而止，蒙。“蒙亨”，以亨行，时中也。“匪我求童蒙，童蒙求我”。志应也。“初筮告”，以刚中也。“再三渎，渎则不告”，渎蒙也。蒙以养正，圣功也。
　　 《象》曰：山下出泉，蒙。君子以果行育德。
　　 初六，发蒙，利用刑人，用说桎梏，以往吝。
　　 《象》曰：“利用刑人”，以正法也。
　　 九二，包蒙，吉。纳妇，吉。子克家。
　　 《象》曰：“子克家”，刚柔节也。
　　 六三，勿用取女，见金夫，不有躬。无攸利。
　　 《象》曰：“勿用取女”，行不顺也。
　　 六四，困蒙，吝。
　　 《象》曰：“困蒙之吝”，独远实也。
　　 六五，童蒙，吉。
　　 《象》曰：“童蒙”之“吉”，顺以巽也。
　　 上九，击蒙，不利为寇，利御寇。
　　 《象》曰：“利”用“御寇”，上下顺也。
----------------------------
艮为山，坎为泉，山下出泉。泉水始流出山，则必将渐汇成江河，正如蒙稚渐启，又山下有险，因为有险停止不前，所以蒙昧不明。
事物发展的初期阶段，必然蒙昧，所以教育是当务之急，培养学生纯正无邪的品质，是治蒙之道。
        """
    },
    "61": {
        "name": "水天需卦",
        "guaci": """
　　 《需》：有孚，光亨。贞吉，利涉大川。
----------------------------
　　 《彖》曰：“需”，须也。险在前也，刚健而不陷，其义不困穷矣。“需，有孚，光亨，贞吉”，位乎天位，以正中也。“利涉大川”，往有功也。
　　 《象》曰：云上于天，需。君子以饮食宴乐。
　　 初九，需于郊，利用恒，无咎。
　　 《象》曰：“需于郊”，不犯难行也。“利用恒无咎”，未失常也。
　　 九二，需于沙，小有言，终吉。
　　 《象》曰：“需于沙”，衍在中也。虽小有言，以终吉也。
　　 九三，需于泥，致寇至。
　　 《象》曰：“需于泥”，灾在外也。自我致寇，敬慎不败也。
　　 六四，需于血，出自穴。
　　 《象》曰：“需于血，”顺以听也。
　　 九五，需于酒食，贞吉。
　　 《象》曰：“酒食贞吉”，以中正也。
　　 上六，入于穴，有不速之客三人来，敬之终吉。
　　 《象》曰：“不速之客来，敬之终吉”，虽不当位，未大失也。
----------------------------
需卦，等待之意。乾为天，坎为云，云气上集于天，待时降雨，为需。需象征需待。物初蒙稚，得养而成，因此也含有需待饮食的意思。
需卦给我们的启示最重要的是无论在哪里都要耐心等待，顺应天道，伺机而动，是人生的一种智慧。
        """
    },
    "16": {
        "name": "天水讼卦",
        "guaci": """
　　 《讼》：有孚窒惕，中吉，终凶。利见大人。不利涉大川。
----------------------------
　　 《彖》曰：讼，上刚下险，险而健，讼。“讼有孚窒惕，中吉”，刚来而得中也。“终凶”，讼不可成也。“利见大人”，尚中正也。“不利涉大川”，入于渊也。
　　 《象》曰：天与水违行，讼。君子以作事谋始。
　　 初六，不永所事，小有言，终吉。
　　 《象》曰：“不永所事”，讼不可长也。虽“小有言”，其辩明也。
　　 九二，不克讼，归而逋。其邑人三百户，无眚。
　　 《象》曰：“不克讼”，归逋窜也。自下讼上，患至掇也。
　　 六三，食旧德，贞厉，终吉。或従王事，无成。
　　 《象》曰：食旧德，従上吉也。
　　 九四，不克讼，复既命渝。安贞吉。
　　 《象》曰：复即命渝，安贞不失也。
　　 九五：讼，元吉。
　　 《象》曰：“讼，元吉”以中正也。
　　 上九：或锡之鞶带，终朝三褫之。
　　 《象》曰：以讼受服，亦不足敬也。
----------------------------
讼卦，象征争论、诉讼。乾为天，坎为水，天西转与水东流背向而行，像人与人不和而争辩。讼象征争辩争论，
含诉讼之义。当不易和解时，便会导致诉讼。应该找有大德大才的人进行决断，不要逞强冒险。
        """
    },
    "86": {
        "name": "地水师卦",
        "guaci": """
　　 《师》：贞丈人吉，无咎。
----------------------------
　　 《彖》曰：师，众也。贞，正也。能以众正，可以王矣。刚中而应，行险而顺，以此毒天下，而民従之，吉又何咎矣。
　　 《象》曰：地中有水，师。君子以容民畜众。
　　 初六，师出以律，否臧凶。
　　 《象》曰：“师出以律，”失律凶也。
　　 九二，在师中吉，无咎，王三锡命。
　　 《象》曰：“在师中吉”，承天宠也。“王三锡命”，怀万邦也。
　　 六三，师或舆尸，凶。
　　 《象》曰：“师或舆尸”，大无功也。
　　 六四，师左次，无咎。
　　 《象》曰：“左次无咎”，未失常也。
　　 六五，田有禽。利执言，无咎。长子帅师，弟子舆尸，贞凶。
　　 《象》曰：“长子帅师”，以中行也。“弟子舆尸”，使不当也。
　　 上六，大君有命，开国承家，小人勿用。
　　 《象》曰：“大君有命”，以正功也。“小人勿用”，必乱邦也。
----------------------------
坤为地，坎为水，地中有水。地中众者，莫过于水。师为众，部属兵士众多的意思。
持正的“仁义之师”，才可攻伐天下使百姓服从，用兵胜负在于择将选帅，持重老成的人统兵可获吉祥，这样才没有灾祸。
        """
    },
    "68": {
        "name": "水地比卦",
        "guaci": """
　　 《比》：吉。原筮，元，永贞，无咎。不宁方来，后夫凶。
----------------------------
　　 《彖》曰：比，吉也；比，辅也，下顺従也。“原筮，元永贞，无咎”，以刚中也。“不宁方来”，上下应也。“后夫凶”，其道穷也。
　　 《象》曰：地上有水，比。先王以建万国，亲诸侯。
　　 初六，有孚比之，无咎。有孚盈缶，终来有它，吉。
　　 《象》曰：比之初六，有它吉也。
　　 六二，比之自内，贞吉。
　　 《象》曰：“比之自内”，不自失也。
　　 六三，比之匪人。
　　 《象》曰：比之匪人”，不亦伤乎？斋
　　 六四，外比之，贞吉。
　　 《象》曰：外比于贤，以従上也。
　　 九五，显比，王用三驱，失前禽，邑人不诫，吉。
　　 《象》曰：“显比”之吉，位正中也。舍逆取顺，失前禽也。邑人不诫，上使中也。
　　 上六，比之无首，凶。
　　 《象》曰：“比之无首”，无所终也。
----------------------------
比卦，亲比，亲密的辅佐。冲为地，坎为水，地上有水。水得地而蓄而流，地得水而柔而润，水与地亲密无间。比者，辅也，密也。
故比象征亲密比辅。彼此能亲密比辅自然吉祥，但应比辅于守持正固而有德的长者，择善而从。
        """
    },
    "51": {
        "name": "风天小畜卦",
        "guaci": """
　　 《小畜》：亨。密云不雨。自我西郊。
----------------------------
　　 《小畜》：亨。密云不雨。自我西郊。
　　 《彖》曰：“小畜”，柔得位而上下应之，曰小畜。健而巽，刚中而志行，乃亨。“密云不雨”，尚往也。“自我西郊”，施未行也。
　　 《象》曰：风行天上，“小畜”。君子以懿文德。
　　 初九，“复自道，何其咎？吉。
　　 《象》曰：“复自道”，其义“吉”也。
　　 九二，牵复，吉。
　　 《象》曰：牵复在中，亦不自失也。
　　 九三，舆说辐。夫妻反目。
　　 《象》曰：“夫妻反目”，不能正室也。
　　 六四，有孚，血去，惕出无咎。
　　 《象》曰：“有孚惕出”，上合志也。
　　 九五，有孚挛如，富以其邻。
　　 《象》曰：“有孚挛如”，不独富也。
　　 上九，既雨既处，尚德载。妇贞厉。月几望，君子征凶。
　　 《象》曰：“既雨既处”，德积载也。“君子征凶”，有所疑也。
----------------------------
乾为天，巽为风，风飘行天上，微畜而未下行。畜有畜聚、畜养、畜止之义。小畜象征小有畜聚，所畜甚微之象。
以小畜大，以下济上，有利于刚大者之行。但阴气从西方升起聚阳甚微，不足以成雨。
        """
    },
    "12": {
        "name": "天泽履卦",
        "guaci": """
　　 《履》：履虎尾，不咥人。亨。
----------------------------
　　 《彖》曰：“履”，柔履刚也。说而应乎乾，是以“履虎尾，不咥人”。亨，刚中正，履帝位而不疚，光明也。
　　 《象》曰：上天下泽，“履”。君子以辨上下，定民志。
　　 初九，素履往，无咎。
　　 《象》曰：“素履之往”，独行愿也。
　　 九二，履道坦坦，幽人贞吉。
　　 《象》曰：“幽人贞吉”，中不自乱也。
　　 六三，眇能视，跛能履，履虎尾，咥人，凶。武人为于大君。
　　 《象》曰：“眇能视”，不足以有明也。“跛能履”，不足以与行也。“咥人之凶”，位不当也。“武人为于大君”，志刚也。
　　 九四，履虎尾，愬愬，终吉。
　　 《象》曰：“愬愬终吉”。志行也。
　　 九五，夬履，贞厉。
　　 《象》曰：“夬履贞厉”，位正当也。
　　 上九，视履考祥，其旋元吉。
　　 《象》曰：元吉在上，大有庆也。
----------------------------
履卦，象征履行、实践。乾为天，兑为泽，天在上，泽在下，为土下之正理。又乾为刚健，兑为和悦，有和悦应合刚健之象。
履象征慎行，循礼而行的意思。遇事循礼慎行，即使有危也无害，所以诸事顺利。
        """
    },
    "81": {
        "name": "地天泰卦",
        "guaci": """
　　 《泰》：小往大来，吉，亨。
----------------------------
　　 《彖》曰：“泰，小往大来。吉，亨。”则是天地交而万物通也，上下交而其志同也。内阳而外阴，内健而外顺，内君子而外小人，君子道长，小人道消也。
　　 《象》曰：天地交，泰。后以财成天地之道，辅相天地之宜，以左右民。
　　 初九，拔茅茹以其汇。征吉。
　　 《象》曰：“拔茅征吉”，志在外也。
　　 九二，包荒，用冯河，不遐遗。朋亡，得尚于中行。
　　 《象》曰：“包荒，得尚于中行”，以光大也。
　　 九三，无平不陂，无往不复。艰贞无咎。勿恤其孚，于食有福。
　　 《象》曰：“无往不复”，天地际也。
　　 六四，翩翩，不富以其邻，不戒以孚。
　　 《象》曰：“翩翩，不富”，皆失实也。“不戒以孚”，中心愿也。
　　 六五，帝乙归妹，以祉元吉。
　　 《象》曰：“以祉元吉”，中以行愿也。
　　 上六，城复于隍，勿用师，自邑告命。贞吝。
　　 《象》曰：“城复于隍”，其命乱也。
----------------------------
泰卦，象征通泰、平安。乾为天，坤为地，天气下降，地气上升，天地阴阳交合，万物的生养之道畅通。泰为通，泰象征通泰。即安泰亨通。
通泰之时，阴者哀而往，阳者盛而来，所以既吉祥又顺利。
        """
    },
    "18": {
        "name": "天地否卦",
        "guaci": """
　　 《否》：否之匪人，不利君子贞，大往小来。
----------------------------
　　 《彖》曰：“否之匪人，不利君子贞，大往小来。”则是天地不交而万物不通也，上下不交而天下无邦也；内阴而外阳，内柔而外刚，内小人而外君子，小人道长，君子道消也。
　　 《象》曰：天地不交，“否”。君子以俭德辟难，不可荣以禄。
　　 初六，拔茅茹以其汇。贞吉，亨。
　　 《象》曰：“拔茅贞吉”，志在君也。
　　 六二，包承，小人吉，大人否。亨。
　　 《象》曰：“大人否亨”，不乱群也。
　　 六三，包羞。
　　 《象》曰：“包羞”，位不当也。
　　 九四，有命，无咎，畴离祉。
　　 《象》曰：“有命无咎”，志行也。
　　 九五，休否，大人吉。其亡其亡，系于苞桑。
　　 《象》曰：大人之吉，位正当也。
　　 上九，倾否，先否后喜。
　　 《象》曰：否终则倾，何可长也。
----------------------------
否卦，象征闭塞不通。坤下乾上，天气上升，地气下沉，天地阴阳二气互不交合，万物生养不得畅通，为否。否者，闭也。
所以否象征否闭、闭塞。否闭之世，人道不通，天下无利。是小人得势，君子被排斥的形象。
        """,
    },
    "13": {
        "name": "天火同人卦",
        "guaci": """
　　 《同人》：同人于野，亨。利涉大川。利君子贞。
----------------------------
　　 《彖》曰：“同人”，柔得位得中，而应乎乾，曰同人。同人曰：“同人于野，亨。利涉大川”，乾行也。文明以健，中正而应，君子正也。唯君子为能通天下之志。
　　 《象》曰：天与火，同人。君子以类族辨物。
　　 初九，同人于门，无咎。
　　 《象》曰：“出门同人”，又谁咎也。
　　 六二，同人于宗，吝。
　　 《象》曰：“同人于宗”，吝道也。
　　 九三，伏戎于莽，升其高陵，三岁不兴。
　　 《象》曰：“伏戎于莽”，敌刚也。“三岁不兴”，安行也。
　　 九四，乘其墉，弗克攻，吉主
　　 《象》曰：“乘其墉”，义弗克也。其“吉”，则困而反则也。
　　 九五，同人先号咷而后笑，大师克，相遇。
　　 《象》曰：同人之先，以中直也。大师相遇，言相克也。
　　 上九，同人于郊，无悔。
　　 《象》曰：“同人于郊”，志未得也。
----------------------------
同人卦，象征大家同心同德之意。离为火，乾为天，火光上升，即天、火相互亲和，为同人。象征和同于人。天下为公，有和睦、和平之义。
促成世界大同，必须有广阔无私、光明磊落的境界，方顺利畅通，而这也是君子的正道。
        """
    },
    "31": {
        "name": "火天大有卦",
        "guaci": """
　　 《大有》：元亨。
----------------------------
　　 《彖》曰：“大有”，柔得尊位大中，而上下应之，曰“大有”。其德刚健而文明，应乎天而时行，是以元亨。
　　 《象》曰：火在天上，“大有”。君子以遏恶扬善，顺天休命。
　　 初九，无交害匪咎。艰则无咎。
　　 《象》曰：大有初九，无交害也。
　　 九二，大车以载，有攸往，无咎。
　　 《象》曰：“大车以载”，积中不败也。
　　 九三，公用亨于天子，小人弗克。
　　 《象》曰：公用亨于天子，小人害也。
　　 九四，匪其彭，无咎。
　　 《象》曰：“匪其彭，无咎。”明辨晰也。
　　 六五，厥孚交如威如，吉。
　　 《象》曰：“厥孚交如”，信以发志也。“威如之吉”，易而无备也。
　　 上九，自天祐之，吉，无不利。
　　 《象》曰：大有上吉，自天祐也。
----------------------------
大有卦，象征大有收获。离为火，乾为天，火焰高悬天上。即太阳当空照耀，大地五谷丰登，大获所有。
故大有有收获之义，象征大获所有。又卦中一阴居尊位，获五阳之应，故为“大有”。
        """
    },
    "87": {
        "name": "地山谦卦",
        "guaci": """
　　 《谦》：亨。君子有终。
----------------------------
　　 《彖》曰：谦，亨。天道下济而光明，地道卑而上行。天道亏盈而益谦，地道变盈而流谦，鬼神害盈而福谦，人道恶盈而好谦。谦，尊而光，卑而不可逾，君子之终也。
　　 《象》曰：地中有山，谦。君子以裒多益寡，称物平施。
　　 初六，谦谦君子，用涉大川，吉。
　　 《象》曰：“谦谦君子”，卑以自牧也。
　　 六二，鸣谦，贞吉。
　　 《象》曰：“鸣谦贞吉”，中心得也。
　　 九三，劳谦君子，有终，吉。
　　 《象》曰：“劳谦君子”，万民服也。
　　 六四，无不利，捴谦。
　　 《象》曰：“无不利，捴谦”，不违则也。
　　 六五，不富以其邻，利用侵伐，无不利。
　　 《象》曰：“利用侵伐”，征不服也。
　　 上六，鸣谦，利用行师征邑国。
　　 《象》曰：“鸣谦”，志未得也。“可用行师”，征邑国也。
----------------------------
谦卦，象征谦虚、谦逊。艮象征山、止，坤象征地、顺，地中有山。山体高大，但在地下，高能下，下谦之象。卑下之中，蕴其崇高，屈躬下物，先人后己，所以谦象征谦虚。
如此谦虚地待物、待事，所以诸事顺利。但是只有君子才能始终保持谦虚的美德。
        """
    },
    "48": {
        "name": "雷地豫卦",
        "guaci": """
　　 《豫》：利建侯行师。
----------------------------
　　 《彖》曰：豫，刚应而志行，顺以动，豫。豫顺以动，故天地如之，而况建侯行师乎？天地以顺动，故日月不过，而四时不忒。圣人以顺动，则刑罚清而民服，豫之时义大矣哉！古
　　 《象》曰：雷出地奋，豫。先王以作乐崇德，殷荐之上帝，以配祖考。
　　 初六，鸣豫，凶。
　　 《象》曰：“初六鸣豫”，志穷凶也。
　　 六二，介于石，不终日，贞吉。
　　 《象》曰：“不终日贞吉”，以中正也。
　　 六三，盱豫，悔，迟有悔。
　　 《象》曰：“盱豫不悔”，位不当也。
　　 九四，由豫，大有得，勿疑。朋盍簪。
　　 《象》曰：“由豫大有得”，志大行也。
　　 六五，贞疾，恒不死。
　　 《象》曰：“六五贞疾”，乘刚也。“恒不死”，中未亡也。
　　 上六，冥豫，成有渝。无咎。
　　 《象》曰：“冥豫”在上，何可长也？
----------------------------
豫卦，象征和乐、喜悦。震为雷，坤为地，雷生于地，预示春天来临，大地震动。春意盎然，喜悦愉快。
故像象征愉快、欢乐、喜悦。春天来临，大地振奋，充满喜悦、欢乐。此时利于建侯立业，兴兵作战。

        """
    },
    "24": {
        "name": "泽雷随卦",
        "guaci": """
　　 《随》：元亨，利贞，无咎。
----------------------------
　　 《彖》曰：随，刚来而下柔，动而说，随。大亨贞无咎，而天下随时，随时之义大矣哉！古
　　 《象》曰：泽中有雷，随。君子以向晦入宴息。
　　 初九，官有渝，贞吉，出门交有功。
　　 《象》曰：“官有渝”，従正吉也。“出门交有功”，不失也。
　　 六二，系小子，失丈夫。
　　 《象》曰：“系小子”，弗兼与也。
　　 六三，系丈夫，失小子，随有求，得。利居贞。
　　 《象》曰：“系丈夫”，志舍下也。
　　 九四，随有获，贞凶。有孚在道，以明，何咎？古
　　 《象》曰：“随有获”，其义凶也。“有孚在道”，明功也。
　　 九五，孚于嘉，吉。
　　 《象》曰：“孚于嘉吉”，位正中也。
　　 上六，拘系之，乃従维之，王用亨于西山。
----------------------------
随卦，随顺、跟随之意。震为动，兑为悦，内动之以德，外悦之以言，天下人因喜欢他的言行而随从之。随象征随从，随和之义。
又震为雷，兑为泽，雷震于泽中，泽随震而动，为随之象。能虚心随和他人，他人也会来随和自己，这样相互随和通顺畅达，自然没有什么灾祸。
        """
    },
    "75": {
        "name": "山风蛊卦",
        "guaci": """
　　 《蛊》：元亨。利涉大川，先甲三日，后甲三日。
----------------------------
　　 《彖》曰：蛊，刚上而柔下，巽而止，蛊。蛊，元亨而天下治也。“利涉大川”，往有事也。“先甲三日，后甲三日”，终则有始，天行也。
　　 《象》曰：山下有风，蛊。君子以振民育德。
　　 初六，干父之蛊，有子，考无咎。厉，终吉。
　　 《象》曰：“干父之蛊”，意承考也。
　　 九二，干母之蛊，不可贞。
　　 《象》曰：“干母之蛊”，得中道也。
　　 九三，干父之蛊，小有悔，无大咎。
　　 《象》曰：“干父之蛊”，终无咎也。
　　 六四，裕父之蛊，往见吝。
　　 《象》曰：“裕父之蛊”，往未得也。
　　 六五，干父之蛊，用誉。
　　 《象》曰：“干父用誉”，承以德也。
----------------------------
艮为山，巽为风，山下有风，风遇山而回，则万物散乱，为有事之象。蛊者，事也，惑也。物既惑乱，当为治理。
故蛊象征惩弊治乱，革新之义。但革新时，应先考虑革新前的状况，再推断革新后将出现的事态，来制定措施。这样才能根治蛊乱，畅通顺利。
        """
    },
    "82": {
        "name": "地泽临卦",
        "guaci": """
　　 《临》：元亨，利贞。至于八月有凶。
----------------------------
　　 《彖》曰：临，刚浸而长，说而顺，刚中而应。大亨以正，天之道也。“至于八月有凶”，消不久也。
　　 《象》曰：泽上有地，临。君子以教思无穷，容保民无疆。
　　 初九，咸临，贞吉。
　　 《象》曰：“咸临贞吉”，志行正也。
　　 九二，咸临，吉，无不利。
　　 《象》曰：“咸临吉无不利”，未顺命也。
　　 六三，甘临，无攸利；既忧之，无咎。
　　 《象》曰：“甘临”，位不当也。“既忧之”。咎不长也。
　　 六四，至临，无咎。
　　 《象》曰：“至临无咎”，位当也。
　　 六五，知临，大君之宜，吉。
　　 《象》曰：“大君之宜”，行中之谓也。
　　 上六，敦临，吉，无咎。
----------------------------
临卦，象征君临、壮大、来临、临视。
兑为泽，坤为地，泽上有地，泽卑地高，高监下，为临。
临象征监视、监察。含有由上视下，以尊临卑之义，也有统治的意思。
以德临人、临事、临天下，必然亨通顺利，但阴阳消长，监临盛极，就有转向衰落的危险。
        """
    },
    "58": {
        "name": "风地观卦",
        "guaci": """
　　 《观》：盥而不荐。有孚颙若。
----------------------------
　　 《彖》曰：大观在上，顺而巽，中正以观天下，观。“盥而不荐，有孚颙若”，下观而化也。观天之神道，而四时不忒，圣人以神道设教，而天下服矣。
　　 《象》曰：风行地上，观。先王以省方观民设教。
　　 初六，童观，小人无咎，君子吝。
　　 《象》曰：“初六童观”，“小人”道也。
　　 六二，窥观，利女贞。
　　 《象》曰：“窥观女贞”，亦可丑也。
　　 六三，观我生，进退。
　　 《象》曰：“观我生进退”，未失道也。
　　 六四，观国之光，利用宾于王。
　　 《象》曰：“观国之光”，尚宾也。
　　 九五，观我生，君子无咎。
　　 《象》曰：“观我生”，观民也。
　　 上九，观其生，君子无咎。
　　 《象》曰：“观其生”，志未平也。
----------------------------
观卦，象征观看、观仰之意。坤为地，巽为风，风行地上，万物广受感化，为观。
观象征观仰，含有展示的意思。以伟大的德行，被万民瞻仰，使天下人顺从美好的教化。
而下者看到盛德，在不知不觉中信服。观仰重形象更重心诚。
        """
    },
    "34": {
        "name": "火雷噬嗑卦",
        "guaci": """
　　 《噬嗑》：亨。利用狱。
----------------------------
　　 《彖》曰：颐中有物曰噬嗑。噬嗑而亨，刚柔分，动而明，雷电合而章。柔得中而上行，虽不当位，利用狱也。
　　 《象》曰：雷电，噬嗑。先王以明罚敕法。
　　 初九，屦校灭趾，无咎。
　　 《象》曰：“屦校灭趾”，不行也。
　　 六二，噬肤灭鼻，无咎。
　　 《象》曰：“噬肤灭鼻”，乘刚也。
　　 六三，噬腊肉遇毒，小吝，无咎。
　　 《象》曰：“遇毒”，位不当也。
　　 九四，“噬干胏，得金矢。利艰贞，吉。
　　 《象》曰：“利艰贞吉”，未光也。
　　 六五，噬干肉得黄金。贞厉，无咎。
　　 《象》曰：“贞厉无咎”，得当也。
----------------------------
噬嗑卦，象征有合着嘴嚼东西的形象，引申为弄狱的意思。震为雷，离为电，雷动而威，电动而明。
用刑之道，威明相兼。雷电咬合而为噬磕。噬，啮也。磕，合也。象征啮合，含有刑罚的意思。
这一卦的升形似口腔，口中有物，正可啮合。
事物在相间相隔之时，利于施用刑罚，除去间隔之物，若能咬合嚼碎，则亨通顺利。
        """
    },
    "73": {
        "name": "山火贲卦",
        "guaci": """
　　 《贲》：亨。小利有攸往。
----------------------------
　　 《彖》曰：贲亨，柔来而文刚，故亨。分，刚上而文柔，故小利有攸往。刚柔交错，天文也。文明以止，人文也。观乎天文，以察时变；观乎人文，以化成天下。
　　 《象》曰：山下有火，贲。君子以明庶政，无敢折狱。
　　 初九，贲其趾，舍车而徒。
　　 《象》曰：“舍车而徒”，义弗乘也。
　　 六二，贲其须。
　　 《象》曰：“贲其须”，与上兴也。
　　 九三，贲如，濡如，永贞吉。
　　 《象》曰：“永贞之吉”，终莫之陵也。
　　 六四，贲如皤如，白马翰如。匪寇，婚媾。
　　 《象》曰：六四，当位疑也。“匪寇婚媾”，终无尤也。
　　 六五，贲于丘园，束帛戋戋，吝，终吉。
　　 《象》曰：“六五之吉”，有喜也。
　　 上九，白贲，无咎。
　　 《象》曰：“白贲无咎”，上得志也。
----------------------------
贲卦，有修饰、装饰的意思。离为火，艮为山，山下有火。山下燃烧着火焰，山形焕彩，为贲。
贲为贝壳的光泽，引申为饰。故贲象征文饰。
事物加一些必要的文饰，可以亨通，特别是柔小的东西加以文饰，才更显其美。
        """
    },
    "78": {
        "name": "山地剥卦",
        "guaci": """
　　 《剥》：不利有攸往。
----------------------------
　　 《彖》曰：剥，剥也。柔变刚也。“不利有攸往”，小人长也。顺而止之，观象也。君子尚消息盈虚，天行也。
　　 《象》曰：山附于地，剥。上以厚下安宅。
　　 初六：剥床以足，蔑贞凶。
　　 《象》曰：“剥床以足”，以灭下也。
　　 六二：剥床以辨，蔑贞凶。
　　 《象》曰：“剥床以辨”，未有与也。
　　 六三：剥之，无咎。
　　 《象》曰：“剥之无咎”，失上下也。
　　 六四：剥床以肤，凶。
　　 《象》曰：“剥床以肤”，切近灾也。
　　 六五：贯鱼以宫人宠，无不利。
　　 《象》曰：“以宫人宠”，终无尤也。
　　 上九：硕果不食，君子得舆，小人剥庐。
　　 《象》曰：“君子得舆”，民所载也。“小人剥庐”，终不可用也。
----------------------------
剥卦，象征剥落、侵蚀。坤为地，艮为山，山石风化，崩塌于地，为剥。剥为剥落，有侵蚀的含义。
又本卦五阴一阳，即小人极盛，万物零落，所以称为剥。阴盛阳衰，小人壮而君子病。
内顺而外止，此时应顺从隐忍，不宜采取任何行动。
        """
    },
    "84": {
        "name": "地雷复卦",
        "guaci": """
　　 《复》：亨。出入无疾。朋来无咎。反复其道，七日来复，利有攸往。
----------------------------
　　 《彖》曰：“复，亨”。刚反，动而以顺行。是以“出入无疾，朋来无咎”。“反复其道，七日来复”，天行也。“利有攸往”，刚长也。复，其见天地之心乎。
　　 《象》曰：雷在地中，复。先王以至日闭关，商旅不行，后不省方。
　　 初九，不远复，无祗悔，元吉。
　　 《象》曰：“不远之复”，以修身也。
　　 六二，休复，吉。
　　 《象》曰：“休复之吉”，以下仁也。
　　 六三，频复，厉，无咎。
　　 《象》曰：“频复之厉”，义无咎也。
　　 六四，中行独复。
　　 《象》曰：“中行独复”，以従道也。
　　 六五，敦复，无悔。
　　 《象》曰：“敦复无悔”，中以自考也。
　　 上六，迷复，凶，有灾眚。用行师，终有大败，以其国君凶，至于十年不克征。
　　 《象》曰：“迷复之凶”，反君道也。
----------------------------
震为雷，性动，坤为地，性顺。震雷在地中微动，阳动土复而能顺行。复为归本，故复象征回复、复归。
又上卦剥，诸阴剥阳，而本升一阳来下，阳气复反，故称复。此时阳刚开始伸长，有利于积极行为。
        """
    },
    "14": {
        "name": "天雷无妄卦",
        "guaci": """
　　《无妄》：元亨，利贞。其匪正有眚，不利有攸往。
----------------------------
　　 《彖》曰：无妄，刚自外来而为主于内，动而健，刚中而应。大亨以正，天之命也。“其匪正有眚，不利有攸往”，无妄之往何之矣？天命不祐，行矣哉！知
　　 《象》曰：天下雷行，物与无妄。先王以茂对时育万物。
　　 初九，无妄往，吉。
　　 《象》曰：“无妄之往”，得志也。
　　 六二，不耕获，不菑畬，则利用攸往。
　　 《象》曰：“不耕获”，未富也。
　　 六三，无妄之灾，或系之牛，行人之得，邑人之灾。
　　 《象》曰：行人得牛，邑人灾也。
　　 九四，可贞。无咎。
　　 《象》曰：“可贞无咎”，固有之也。
　　 九五，无妄之疾，勿药有喜。
　　 《象》曰：“无妄之药”，不可试也。
　　 上九，无妄行，有眚，无攸利。
　　 《象》曰：“无妄之行”，穷之灾也。
----------------------------
无妄，不虚妄，不妄为的意思。乾为天，震为雷，天下雷行，万物不敢妄为，为无妄。
无妄象征不妄为，合乎客观规律，不违事实。什么事情均不妄为时，亨通顺利，否则就会发生祸患，不利于发展。
        """
    },
    "71": {
        "name": "山天大畜卦",
        "guaci": """
　　 《大畜》：利贞。不家食吉。利涉大川。
----------------------------
　　 《彖》曰：大畜，刚健笃实，辉光日新。其德刚上而尚贤，能止健，大正也。“不家食吉”，养贤也。“利涉大川”，应乎天也。
　　 《象》曰：天在山中，大畜。君子以多识前贤往行，以畜其德。
　　 初九，有厉，利已。
　　 《象》曰：“有厉利已”，不犯灾也。
　　 九二，舆说輹。
　　 《象》曰：“舆说輹”，中无尤也。
　　 九三，良马逐，利艰贞，曰闲舆卫，利有攸往。
　　 《象》曰：“利有攸往”，上合志也。
　　 六四，童牛之牿，元吉。
　　 《象》曰：“六四元吉”，有喜也。
　　 六五，豮豕之牙，吉。
　　 《象》曰：“六五之吉”，有庆也。
　　 上九，何天之衢，亨。
　　 《象》曰：“何天之衢”，道大行也。
----------------------------
乾为天，艮为山，天包含在山中，为大畜。畜有畜聚、畜止、畜养等义。大畜象征大为畜聚，有大量积蓄之义。
这一卦，不坐食在家中，外出谋生定会吉利。宜于克服艰险。
        """
    },
    "74": {
        "name": "山雷颐卦",
        "guaci": """
　　 《颐》：贞吉。观颐，自求口实。
----------------------------
　　 《彖》曰：颐，贞吉，养正则吉也。观颐，观其所养也。自求口实，观其自养也。天地养万物，圣人养贤以及万民，颐之时大矣哉！知
　　 《象》曰：山下有雷，颐。君子以慎言语，节饮食。
　　 初九，舍尔灵龟，观我朵颐，凶。
　　 《象》曰：“观我朵颐”，亦不足贵也。
　　 六二，颠颐拂经于丘颐，征凶。
　　 《象》曰：“六二征凶”，行失类也。
　　 六三，拂颐，贞凶，十年勿用，无攸利。
　　 《象》曰：“十年勿用”，道大悖也。
　　 六四，颠颐，吉。虎视眈眈，其欲逐逐，无咎。
　　 《象》曰：“颠颐之吉”，上施光也。
　　 六五，拂经，居贞吉，不可涉大川。
　　 《象》曰：“居贞之吉”，顺以従上也。
　　 上九，由颐，厉，吉。利涉大川。
　　 《象》曰：“由颐厉吉”，大有庆也。
----------------------------
震为雷，艮为山，山下有雷。山止于上，雷动于下，下动上止，如口嚼食物，供给营养，为颐。
颐为养，故颐象征颐养。观察事物的颐养现象，当以正道自力更生来养活自己。
        """
    },
    "25": {
        "name": "泽风大过卦",
        "guaci": """
　　 《大过》：栋挠，利有攸往，亨。
----------------------------
　　 《彖》曰：“大过”，大者过也。“栋挠”，本末弱也。刚过而中，巽而说，行。利有攸往，乃亨。“大过”之时大矣哉！知
　　 《象》曰：泽灭木，大过。君子以独立不惧，遯世无闷。
　　 初六，藉用白茅，无咎。
　　 《象》曰：“藉用白茅”，柔在下也。
　　 九二，枯杨生稊，老夫得其女妻，无不利。
　　 《象》曰：“老夫女妻，”，过以相与也。
　　 九三，栋桡，凶。
　　 《象》曰：“栋桡”之“凶”，不可以有辅也。
　　 九四，栋隆，吉。有它，吝。
　　 《象》曰：“栋隆之吉”，不桡乎下也。
　　 九五，枯杨生华，老妇得其士夫，无咎无誉。
　　 《象》曰：“枯杨生华”，何可久也。“无妇士夫”，亦可丑也。
　　 上六，过涉灭顶，凶。无咎。
　　 《象》曰：“过涉之凶”，不可咎也。
----------------------------
大过卦，象征大的过度。巽为木，兑为泽，泽本润木，但泽在树上，为大水淹没了树木，则过甚。过者，越也。大过象征大为过甚，含有过失的意思。
大过内巽外兑，中庸、顺从、使人喜悦，能够得到协助，有可行之道，故前进亨通。
        """
    },
    "66": {
        "name": "坎为水卦",
        "guaci": """
　　 《习坎》：有孚维心，亨。行有尚。
----------------------------
　　 《彖》曰：“习坎”，重险也。水流而不盈。行险而不失其信。维心亨，乃以刚中也。“行有尚”，往有功也。天险，不可升也。地险，山川丘陵也。王公设险以守其国。险之时用大矣哉！古
　　 《象》曰：水洊至，习坎。君子以常德行，习教事。
　　 初六，习坎，入于坎，窞，凶。
　　 《象》曰：“习坎入坎”，失道，凶也。
　　 九二，坎有险，求小得。
　　 《象》曰：“求小得”，未出中也。
　　 六三，来之坎，坎险且枕，入于坎，窞，勿用。
　　 《象》曰：“来之坎坎”，终无功也。
　　 六四，樽酒簋贰用缶，纳约自牖，终无咎。
　　 《象》曰：“樽酒簋贰”，刚柔际也。
　　 九五，坎不盈，祗既平，无咎。
　　 《象》曰：“坎不盈”，中未大也。
　　 上六，系用徽纆，窴于丛棘，三岁不得，凶。
　　 《象》曰：上六失道，凶三岁也。
----------------------------
坎为水，特性陷，坎下坎上，水上加水，陷而再陷，坎象征险难。越是在艰险中越是向前的行为是崇高的，而退缩则没有出路。
坎卦预示在凶险的环境中，要保持住水之德、中正之德，要反复地去求福、去演习，这样才能脱离险境。
        """
    },
    "33": {
        "name": "离为火卦",
        "guaci": """
　　 《离》：利贞。亨。畜牝牛吉。
----------------------------
　　 《彖》曰：离，丽也。日月丽乎天，百谷草木丽乎土。重明以丽乎正，乃化成天下。柔丽乎中正，故，是以“畜牝牛吉”也。
　　 《象》曰：明两作，离。大人以继明照于四方。
　　 初九，履错然，敬之无咎。
　　 《象》曰：“履错之敬”，以辟咎也。
　　 六二，黄离，元吉。
　　 《象》曰：“黄离元吉”，得中道也。
　　 九三，日昃之离，不鼓缶而歌，则大耋之嗟，凶。
　　 《象》曰：“日昃之离”，何可久也？知
　　 九四，突如，其来如，焚如，死如，弃如。
　　 《象》曰：“突如其来如”，无所容也。
　　 六五，出涕沱若，戚嗟若，吉。
　　 《象》曰：六五之吉，离王公也。
　　 上九，王用出征，有嘉折首，获匪其丑，无咎。
　　 《象》曰：“王用出征”，以正邦也。
----------------------------
离为日，日为光，离上离下，光明接连升起悬附空中，即日附丽于天。离，为丽。象征附丽，有附着、结合的意义。但附看的对象必须正当，具备柔顺的德行，才能获吉。离卦要求我们年少时要心地纯正，行中道，守礼仪；
人到中年以后，要保持快乐的心，不忧伤，在身处逆境、坎坷艰险的时候，要增强信心，能容忍，胸襟宽广；
        """
    },
    "27": {
        "name": "泽山咸卦",
        "guaci": """
　　 咸：亨。利贞。取女吉。
----------------------------
　　 《彖》曰：咸，感也。柔上而刚下，二气感应以相与。止而说，男下女，是以“亨利贞，取女吉”也。天地感而万物化生，圣人感人心而天下和平。观其所感，而天地万物之情可见矣。
　　 《象》曰：山上有泽，咸。君子以虚受人。
　　 初六，咸其拇。
　　 《象》曰“咸其拇”，志在外也。
　　 六二，咸其腓，凶。居吉。
　　 《象》曰虽“凶居吉”，顺不害也。
　　 九三，咸其股，执其随，往吝。
　　 《象》曰：“咸其股”，亦不处也。志在随人，所执下也。
　　 九四，贞吉。悔亡。憧憧往来，朋従尔思。
　　 《象》曰：“贞吉悔亡”，未感害也。“憧憧往来”，未光大也。
　　 九五，咸其脢，无悔。
　　 《象》曰：“咸其脢”，志末也。
　　 上六，咸其辅颊舌。
　　 《象》曰：“咸其辅颊舌”，滕口说也。
----------------------------
艮为山，兑为泽，山上有泽。泽性下流，以山感泽，为咸。
咸为无心之感，象征无心的感应，这是异性间自然、必然的现象。男女共相感应成夫妻可获吉祥。
        """
    },
    "45": {
        "name": "雷风恒卦",
        "guaci": """
　　 恒：亨。无咎。利贞。利有攸往。
----------------------------
　　 《彖》曰：恒，久也。刚上而柔下。雷风相与，巽而动，刚柔皆应，恒。“恒亨无咎利贞”，久于其道也。天地之道恒久而不已也。“利有攸往”，终则有始也。日月得天而能久照，四时变化而能久成。圣人久于其道而天下化成。观其所恒，而天地万物之情可见矣。
　　 《象》曰：雷风，恒。君子以立不易方。
　　 初六，浚恒，贞凶，无攸利。
　　 《《象》曰：“浚恒”之“凶”，始求深也。
　　 九二，悔亡。
　　 《象》曰：九二“悔亡”，能久中也。
　　 九三，不恒其德，或承之羞，贞吝。
　　 《象》曰：“不恒其德”，无所容也。
　　 九四，田无禽。
　　 《象》曰：久非其位，安得禽也。
　　 六五，恒其德，贞，妇人吉，夫子凶。
　　 《象》曰：妇人贞吉，従一而终也。夫子制义，従妇凶也。
　　 上六，振恒，凶。
　　 《象》曰：振恒在上，大无功也。
----------------------------
恒卦，象征恒久。巽为风，震为雷，雷震则风发，二者相依相助恒常不变，为恒。
恒象征恒久。又震刚在上，巽柔在下，说明尊卑序次是恒常不变之事。有恒必然有成，所以亨通，不会有灾难。但必须以坚持纯贞为前提，才会有利。


        """
    },
    "17": {
        "name": "天山遁卦",
        "guaci": """
　　 《遁》：亨。小利贞。
----------------------------
　　 《彖》曰：“遁亨”，遁而亨也。刚当位而应，与时行也。“小利贞”，浸而长也。遁之时义大矣哉！斋
　　 《象》曰：天下有山，遁。君子以远小人，不恶而严。
　　 初六，遁尾，厉，勿用有攸往。
　　 《象》曰：“遁尾”之“厉”，不往何灾也？古
　　 六二，执之用黄牛之革，莫之胜说。
　　 《象》曰：“执用黄牛”，固志也。
　　 九三，系遁，有疾厉，畜臣妾吉。
　　 《象》曰：“系遁”之“厉”，有疾惫也。“畜臣妾吉”，不可大事也。
　　 九四，好遁，君子吉，小人否。
　　 《象》曰：“君子好遁，小人否”也。
　　 九五，嘉遁，贞吉。
　　 《象》曰：“嘉遁贞吉”，以正志也。
　　 上九，肥遁，无不利。
　　 《象》曰：“肥遁无不利”，无所疑也。
----------------------------
遁卦，象征隐退、躲避。艮为山，乾为天，天下有山。天若君子，山比小人，小人渐长，君子退避，若天远避山。故为遁。又作“通”，故遁象征退避。
退避之时，阴渐长而阳渐衰，君子退而顺利亨通，柔小者宜持正，不宜妄动以害阳刚获吉。
        """
    },
    "41": {
        "name": "雷天大壮卦",
        "guaci": """
　　 《大壮》：利贞。
----------------------------
　　 《彖》曰：大壮，大者壮也。刚以动，故壮。“大壮利贞”，大者正也。正大，而天地之情可见矣。
　　 《象》曰：雷在天上，大壮。君子以非礼弗履。
　　 初九，壮于趾，征凶，有孚。
　　 《象》曰：“壮于趾”，其孚穷也。
　　 九二，贞吉。
　　 《象》曰：九二“贞吉”，以中也。
　　 九三，小人用壮，君子用罔，贞厉。羝羊触藩，羸其角。
　　 《象》曰：“小人用壮”，君子以罔也。
　　 九四，贞吉，悔亡。藩决不羸，壮于大舆之輹。
　　 《象》曰：“藩决不羸”，尚往也。
　　 六五，丧羊于易，无悔。
　　 《象》曰：“丧羊于易”，位不当也。
　　 上六，羝羊触藩，不能退，不能遂，无攸利，艰则吉。
　　 《象》曰：“不能退，不能遂”，不详也。“艰则吉”，咎不长也。
----------------------------
大壮：象征状大、强盛。乾为天，震为雷，震雷响彻天上，为大壮。壮，强盛。大壮象征大为强盛。又乾刚震动，阳气从下上升，阳气大动，为壮。
君子壮大，当然亨通，然而，声势隆盛壮大，就必须严守纯正;否则，就有陷于横基的可能。所以说，坚守纯正，才会有利。
        """
    },
    "38": {
        "name": "火地晋卦",
        "guaci": """
　　 《晋》：康侯用锡马蕃庶，昼日三接。
----------------------------
　　 《彖》曰：晋，进也，明出地上。顺而丽乎大明，柔进而上行，是以“康侯用锡马蕃庶，昼日三接”也。
　　 《象》曰：明出地上，《晋》。君子以自昭明德。
　　 初六，晋如摧如，贞吉。罔孚，裕无咎。
　　 《象》曰：“晋如摧如”，独行正也。“裕无咎”。未受命也。
　　 六二，晋如，愁如，贞吉。受兹介福于，其王母。
　　 《象》曰：“受兹介福”，以中正也。
　　 六三，众允，悔亡。
　　 《象》曰：“众允”之志，上行也。
　　 九四，晋如鼫鼠，贞厉。
　　 《象》曰：“鼫鼠贞厉”，位不当也。
　　 六五，悔亡，失得，勿恤。往吉，无不利。
　　 《象》曰：“失得勿恤”，往有庆也。
　　 上九，晋其角，维用伐邑，厉吉，无咎，贞吝。
　　 《象》曰：“维用伐邑”，道未光也。
----------------------------
晋卦，象征前进、晋升。坤为地，离为日，为光，日之出地上。即光明出现在地面，万物柔顺依附的样子。
就像臣下依附天子，得到晋升。晋，为进，含进长、前进的意思，故晋象征进长，主吉祥。
        """
    },
    "83": {
        "name": "地火明夷卦",
        "guaci": """
　　 《明夷》：利艰贞。
----------------------------
　　 《彖》曰：明入地中，“明夷”。内文明而外柔顺，以蒙大难，文王以之。“利艰贞”，晦其明也，内难而能正其志，箕子以之。
　　 《象》曰：明入地中，“明夷”。君子以莅众用晦而明。
　　 初九，明夷，于飞垂其翼。君子于行，三日不食。有攸往，主人有言。
　　 《象》曰：“君子于行”，义不食也。
　　 六二，明夷夷于左股，用拯马壮，吉。
　　 《象》曰：六二之吉，顺以则也。
　　 九三，明夷于南狩，得其大首，不可疾贞。
　　 《象》曰：“南狩”之志，乃得大也。
　　 六四，入于左腹，获明夷之心，于出门庭。
　　 《象》曰：“入于左腹”，获心意也。
　　 六五，箕子之明夷，利贞。
　　 《象》曰：箕子之贞，明不可息也。
　　 上六，不明，晦，初登于天，后入于地。
　　 《象》曰：“初登于天”，照四国也。“后入天地”，失则也。
----------------------------
明夷卦，象征受伤、倒霉。离为日，为明；坤为地。日落地下，光明没入地中，为明夷。夷者，伤也。
明夷象征光明损伤。暗主在上，明臣在下，不敢显其明智，引申为天下昏暗。
在光明受队之时，贤者以明德被创伤，面对的局势非常艰难，惟有守持正固，刻苦忍而寸，韬光养晦以自保。
        """
    },
    "53": {
        "name": "风火家人卦",
        "guaci": """
　　 《家人》：利女贞。
----------------------------
　　 《彖》曰：家人，女正位乎内，男正位乎外。男女正，天地之大义也。家人有严君焉，父母之谓也。父父，子子，兄兄，弟弟，夫夫，妇妇，而家道正。正家而天下定矣。
　　 《象》曰：风自火出，家人。君子以言有物而行有恒。
　　 初九，闲有家，悔亡。
　　 《象》曰：“闲有家”，志未变也。
　　 六二，无攸遂，在中馈，贞吉。
　　 《象》曰：六二之吉，顺以巽也。
　　 九三，家人嗃々，悔厉吉；妇子嘻嘻，终吝。
　　 《象》曰：“家人嗃々”，未失也。“妇子嘻嘻”，失家节也。
　　 九四，富家，大吉。
　　 《象》曰：“富家大吉”，顺在位也。
　　 九五，王假有家，勿恤，吉。
　　 《象》曰：“王假有家”，交相爱也。
　　 上九，有孚威如，终吉。
　　 《象》曰：威如之吉，反身之谓也。
----------------------------
离为火， 巽为风。内火外风，风自火出，似家事自内影响至外，谓之家人。故家人象征一家人。含家庭之义。
又六二阴柔居内卦中正，似女子主家内事，九五阳刚居外卦中正，似男子主家外事，谓“家人”。家道之事，女子为主要因素，因此，女子应以正持家。
        """
    },
    "32": {
        "name": "火泽睽卦",
        "guaci": """
　　 《睽》：小事吉。
----------------------------
　　 《彖》曰：睽，火动而上，泽动而下。二女同居，其志不同行。说而丽乎明，柔进而上行，得中而应乎刚，是以小事吉。天地睽而其事同也。男女睽而其志通也。万物睽而其事类也，睽之时用大矣哉！知
　　 《象》曰：上火下泽，睽。君子以同而异。
　　 初九，悔亡。丧马勿逐自复。见恶人无咎。
　　 《象》曰：“见恶人”，以辟咎也。
　　 九二，遇主于巷，无咎。
　　 《象》曰：“遇主于巷”，未失道也。
　　 六三，见舆曳，其牛掣，其人天且劓，无初有终。
　　 《象》曰：“见舆曳”，位不当也。“无初有终”，遇刚也。
　　 九四，睽孤遇元夫，交孚，厉，无咎。
　　 《象》曰：“交孚无咎”，志行也。
　　 六五，悔亡。厥宗噬肤，往何咎？斋
　　 《象》曰：“厥宗噬肤”，往有庆也。
　　 上九，睽孤见豕负涂，载鬼一车，先张之弧，后说之弧，匪寇，婚媾。往遇雨则吉。
　　 《象》曰：“遇雨之吉”，群疑亡也。
----------------------------
睽卦，象征乖异、离异。兑为泽，离为火，火焰向上烧，泽水向下浸，两性相背，为睽。睽者，乖，两目相背，不和谐。故睽象征睽异、离散。
以万物的事理来说，形态虽然违背，但却有看不到的同一性存在，所以应以柔顺的方法。细心寻求可合之处，才能转离为合，变摩擦为和谐。
        """
    },
    "76": {
        "name": "水山蹇卦",
        "guaci": """
　　 《蹇》：利西南，不利东北。利见大人。贞吉。
----------------------------
　　 《彖》曰：蹇，难也，险在前也。见险而能止，知矣哉！蹇，利西南”，往得中也。“不利东北”，其道穷也。“利见大人”，往有功也。当位”贞吉”，以正邦也。蹇之时用大矣哉！斋
　　 《象》曰：山上有水，蹇。君子以反身修德。
　　 初六，往蹇来誉。
　　 《象》曰：“往蹇来誉”，宜待也。
　　 六二，王臣蹇蹇，匪躬之故。
　　 《象》曰：“王臣蹇蹇”，终无尤也。
　　 九三，往蹇来反。
　　 《象》曰：“往蹇来反”，内喜之也。
　　 六四，往蹇来连。
　　 《象》曰：“往蹇来连”，当位实也。
　　 九五，大蹇朋来。
　　 《象》曰：“大蹇朋来”，以中节也。
　　 上六，往蹇来硕，吉，利见大人。
　　 《象》曰：“往蹇来硕”，志在内也。“利见大人”，以従贵也。
----------------------------
蹇卦，象征跛足、行走困难、不顺利。艮为山，坎为水，山上有水。山路本就艰险，水积山上，行路更难，为蹇。蹇为跋，行走不便，引申为难。
故蹇象征行走艰难，是困难的意思，在困难的时刻，需要伟大人物的协助，而且必须坚持正道，才能得救。
        """
    },
    "46": {
        "name": "雷水解卦",
        "guaci": """
　　 《解》：利西南。无所往，其来复吉。有攸往，夙吉。
----------------------------
　　 《彖》曰：解，险以动，动而免乎险，解。“解，利西南”，往得众也。“其来复吉”，乃得中也。“有攸往夙吉。”，往有功也。天地解而雷雨作，雷雨作而百果草木皆甲坼。解之时大矣哉！主
　　 《象》曰：雷雨作，解。君子以赦过宥罪。
　　 初六，无咎。
　　 《象》曰：刚柔之际，义无咎也。
　　 九二，田获三狐，得黄矢，贞吉。
　　 《象》曰：九二贞吉，得中道也。
　　 六三，负且乘，致寇至，贞吝。
　　 《象》曰：“负且乘”，亦可丑也。自我致戎，又谁咎也？斋
　　 九四，解而拇，朋至斯孚。
　　 《象》曰：“解而拇”，未当位也。
　　 六五，君子维有解，吉，有孚于小人。
　　 《象》曰：君子有解，小人退也。
　　 上六，公用射隼于高墉之上，获之，无不利。
　　 《象》曰：“公用射隼”，以解悖也。
----------------------------
解卦，象征解脱、解除险难。坎为雨，震为雷，雷雨兴起，万物当春，纷纷舒发生机，为解。解为缓。故解象征舒缓，舒缓解散。
舒解险难，应当用柔，使群情共获舒缓，与民休息，不再烦琐百姓，才有利。不使纷扰延续下去，才获吉。
        """
    },
    "72": {
        "name": "山泽损卦",
        "guaci": """
　　 《损》：有孚，元吉，无咎。可贞，利有攸往。曷之用？二簋可用享。
----------------------------
　　 《彖》曰：损，损下益上，其道上行。损而有孚，元吉，无咎，可贞，利有攸往，曷之用？二簋可用享。二簋应有时。损刚益柔有时，损益盈虚，与时偕行。
　　 《象》曰：山下有泽，损。君子以惩忿窒欲。
　　 初九，已事遄往，无咎。酌损之。
　　 《象》曰：“已事遄往”，尚合志也。
　　 九二，利贞。征凶，弗损，益之。
　　 《象》曰：“九二利贞”，中以为志也。
　　 六三，三人行则损一人，一人行则得其友。
　　 《象》曰：“一人行”，“三”则疑也。
　　 六四，损其疾，使遄有喜，无咎。
　　 《象》曰：“损其疾”，亦可喜也。
　　 六五，或益之十朋之龟，弗克违，元吉。
　　 《象》曰：六五元吉，自上祐也。
　　 上九，弗损，益之，无咎，贞吉，利有攸往，得臣无家。
　　 《象》曰：“弗损，益之”，大得志也。
----------------------------
兑为泽，艮为山，泽在山下。泽卑山高，以泽之自损以增山高，所以损象征减损。
减损之时，只要心存诚信，就会获得吉祥而没有什么灾难；
只要守持正固，就利于有所前往。损之道只要心诚，微薄之物也可以奉献出来，但须合时。
        """
    },
    "54": {
        "name": "风雷益卦",
        "guaci": """
　　 《益》：利有攸往。利涉大川。
----------------------------
　　 《彖》曰：“益”，损上益下，民说无疆。自上下下，其道大光。“利有攸往”，中正有庆。“利涉大川”，木道乃行。益动而巽，日进无疆。天施地生，其益无方。凡益之道，与时偕行。
　　 《象》曰：风雷，益。君子以见善则迁，有过则改。
　　 初九，利用为大作，元吉，无咎。
　　 《象》曰：“元吉无咎”，下不厚事也。
　　 六二，或益之十朋之龟，弗克违。永贞吉。王用享于帝，吉。
　　 《象》曰：“或益之”，自外来也。
　　 六三，益之用凶事，无咎。有孚。中行告公用圭。
　　 《象》曰：“益用凶事”，固有之也。
　　 六四，中行告公，従，利用为依迁国。
　　 《象》曰：“告公従”，以益志也。
　　 九五，有孚惠心，勿问，元吉。有孚，惠我德。
　　 《象》曰：“有孚惠心”，勿问之矣。“惠我德”，大得志也。
　　 上九，莫益之，或击之，立心勿恒，凶。
　　 《象》曰：“莫益之”，偏辞也。“或击之”，自外来也。
----------------------------
益卦，象征增多、补益。震为雷，巽为风，风烈则雷迅，雷激则风怒。即风雷相益。益者，增长。故益象征增益
。为损上益下。象征统治者减损财富，使人民增益。既行损上益下之道，利于有所前往，排难涉险。
        """
    },
    "21": {
        "name": "泽天夬卦",
        "guaci": """
　　 《夬》：扬于王庭，孚号。有厉，告自邑。不利即戎，利有攸往。
----------------------------
　　 《彖》曰：“夬”，决也，刚决柔也。健而说，决而和。“扬于王庭”，柔乘五刚也。“孚号有厉”，其危乃光也。“告自邑，不利即戎”，所尚乃穷也。“利有攸往”，刚长乃终也。
　　 《象》曰：泽上于天，夬。君子以施禄及下，居德则忌。
　　 初九，壮于前趾，往不胜，为咎。
　　 《象》曰：不胜而往，咎也。
　　 九二，惕号，莫夜有戎，勿恤。
　　 《象》曰：“有戎勿恤”，得中道也。
　　 九三，壮于頄，有凶。君子夬夬独行，遇雨若濡，有愠无咎。
　　 《象》曰：“君子夬夬”，终无咎也。
　　 九四，臀无肤，其行次且。牵羊悔亡，闻言不信。
　　 《象》曰：“其行次且”，位不当也。“闻言不信”，聪不明也。
　　 九五，苋陆夬夬中行，无咎。
　　 《象》曰：“中行无咎”，中未光也。
　　 上六，无号，终有凶。
　　 《象》曰：“无号之凶”，终不可长也。
----------------------------
夬卦，象征决裂、决断。乾为天，兑为泽，天上水气腾腾，欲降成雨，为夬，夬为决断、果决。有清除邪恶的意思。
君子制裁小人时，应光明正大，公开公布小人的罪过，并告诫人们引以为戒。施“仁政”，建章立法，不乱用武施慕。这样才会有利。
        """
    },
    "15": {
        "name": "天风姤卦",
        "guaci": """
　　 《姤》：女壮，勿用取女。
----------------------------
　　 《彖》曰：姤，遇也，柔遇刚也。勿用取女”，不可与长也。天地相遇，品物咸章也。刚遇中正，天下大行也。姤之时义大矣哉！
　　 《象》曰：天下有风，姤。后以施命诰四方。
　　 初六，系于金柅，贞吉。有攸往，见凶，羸豕孚蹢躅。
　　 《象》曰：“系于金柅”，柔道牵也。
　　 九二，包有鱼，无咎，不利宾。
　　 《象》曰：“包有鱼”，义不及宾也。
　　 九三，臀无肤，其行次且，厉，无大咎。
　　 《象》曰：“其行次且”，行未牵也。
　　 九四，包无鱼，起凶。
　　 《象》曰：“无鱼之凶”，远民也。
　　 九五，以杞包瓜，含章，有陨自天。
　　 《象》曰：九五含章，中正也。有陨自天，志不舍命也。
　　 上九，姤其角，吝，无咎。
　　 《象》曰：“姤其角”，上穷吝也。
----------------------------
巽为风，乾为天，风行天下，无物不遇，为姤，同逅，即邂逅，意外相遇。
本卦一阴丈周旋在五阳爻之间，疑此女不守贞节，而且身体强壮，相遇不可娶其为妻。
但也不一定都恶劣，刚遇到中正的柔，刚柔相济，才能使其抱负大行于天下。
        """
    },
    "28": {
        "name": "泽地萃卦",
        "guaci": """
　　 《萃》：亨，王假有庙。利见大人。亨，利贞，用大牲吉。利有攸往。
----------------------------
　　 《彖》曰：“萃”，聚也。顺以说，刚中而应，故聚也。“王假有庙”，致孝享也。“利见大人亨”，聚以正也。“用大牲吉，利有攸往”，顺天命也。观其所聚，而天地万物之情可见矣。
　　 《象》曰：泽上于地，萃。君子以除戎器，戒不虞。
　　 初六，有孚不终，乃乱乃萃，若号，一握为笑，勿恤，往无咎。
　　 《象》曰：“乃乱乃萃”，其志乱也。
　　 六二，引吉，无咎，孚乃利用禴。
　　 《象》曰：“引吉无咎”，中未变也。
　　 六三，萃如嗟如，无攸利，往无咎，小吝。
　　 《象》曰：“往无咎”，上巽也。
　　 九四，大吉无咎。
　　 《象》曰：“大吉无咎”，位不当也。
　　 九五，萃有位，无咎。匪孚，元永贞，悔亡。
　　 《象》曰：“萃有位”，志未光也。
　　 上六，赍咨涕洟，无咎。
　　 《象》曰：“赍咨涕洟”，未安上也。
----------------------------
萃卦，象征聚集、相聚。坤为地，性顺，兑为泽，性悦。泽居地上，即水在地上聚集成泽，滋润万物，为革。故萃象征会聚。天下会聚，顺利亨通。
德高望重者主持会聚必遵循正道，用大的栖牲祭祀祖先会吉祥，聚集使物资丰富，民心一致，可积极前进，从事大的事业。
        """
    },
    "85": {
        "name": "地风升卦",
        "guaci": """
　　 《升》：元亨。用见大人，勿恤。南征吉。
----------------------------
　　 《彖》曰：柔以时升，巽而顺，刚中而应，是以大亨，“用见大人勿恤”，有庆也。“南征吉”，志行也。
　　 《象》曰：地中生木，升。君子以顺德，积小以高大。
　　 初六，允升，大吉。
　　 《象》曰：“允升大吉”，上合志也。
　　 九二，孚乃利用禴，无咎。
　　 《象》曰：九二之孚，有喜也。
　　 九三，升虚邑。
　　 《象》曰：“升虚邑”，无所疑也。
　　 六四，王用亨于岐山，吉，无咎。
　　 《象》曰：“王用亨于岐山”，顺事也。
　　 六五，贞吉，升阶。
　　 《象》曰：“贞吉升阶”，大得志也。
　　 上六，冥升，利于不息之贞。
　　 《象》曰：冥升在上，消不富也。
----------------------------
升卦，象征上升、发展。巽为木，坤为地。地中生出树木，为升。升象征上升。事物上升，亨通吉利。
但卦中阳丈不当尊位，有所忧虑，故须德高望重者才能长保刚中美德。朝着光明前进，必获吉祥。
        """
    },
    "26": {
        "name": "泽水困卦",
        "guaci": """
　　 《困》：亨。贞大人吉，无咎。有言不信。
----------------------------
　　 《彖》曰：“困”，刚掩也。险以说，因而不失其所，亨，其唯君子乎。“贞大人吉”，以刚中也。“有言不信”，尚口乃穷也。
　　 《象》曰：泽无水，困。君子以致命遂志。
　　 初六，臀困于株木，入于幽谷，三岁不觌。
　　 《象》曰：“入于幽谷”，幽不明也。
　　 九二，困于酒食，朱绂方来。利用享祀。征凶，无咎。
　　 《象》曰：“困于酒食”，中有庆也。
　　 六三，困于石，据于蒺藜，入于其宫，不见其妻，凶。
　　 《象》曰：“据于蒺藜”，乘刚也。“入于其宫，不见其妻”，不祥也。
　　 九四，来徐徐，困于金车，吝，有终。
　　 《象》曰：“来徐徐”，志在下也。虽不当位，有与也。
　　 九五，劓刖，困于赤绂，乃徐有说，利用祭祀。
　　 《象》曰：“劓刖”，志未得也。“乃徐有说”，以中直也。“利用祭祀”，受福也。
　　 上六，困于葛藟，于臲<臬兀>，曰动悔有悔，征吉。
　　 《象》曰：“困于葛藟”，未当也。“动悔有悔”，吉行也。
----------------------------
困卦，象征穷困、受困。坎为水，兑为泽，水在泽下，泽中无水，干泽，为困。困象征困穷。
君子处困之时，能努力自济必顺矛」亨通。
只有持正之德高望重者才能获吉而无灾难。此时所言必难取信于人，当多修己德，少说为佳。
        """
    },
    "65": {
        "name": "水风井卦",
        "guaci": """
　　 《井》：改邑不改井，无丧无得。往来井井。汔至，亦未繘井，羸其瓶，凶。
----------------------------
　　 《彖》曰：巽乎水而上水，井。井养而不穷也。“改邑不改井，”乃以刚中也。“汔至，亦未繘井”，未有功也。“羸其瓶”，是以凶也。
　　 《象》曰：木上有水，井。君子以劳民劝相。
　　 初六，井泥不食。旧井无禽。
　　 《象》曰：“井泥不食”，下也。“占井无禽”，时舍也。
　　 九二，井谷射鲋，瓮敝漏。
　　 《象》曰：“井谷射鲋”，无与也。
　　 九三，井渫不食，为我心恻。可用汲，王明并受其福。
　　 《象》曰：“井渫不食”，行恻也。求“王明”，受福也。
　　 六四，井甃，无咎。
　　 《象》曰：“井甃无咎”，修井也。
　　 九五，井洌，寒泉食。
　　 《象》曰：“寒泉之食”，中正也。
　　 上六，井收勿幕，有孚元吉。
　　 《象》曰：“元吉”在“上”，大成也。
----------------------------
井卦，象征水井。巽为木，坎为水，木上有水。即以木捅汲水。故井象征水井。村落可以变迁，但井不会变动，人们来来往往汲水，井水依然洁净不变。
当汲水的瓦罐，快到达水面时，吊绳没有伸开，而翻度破裂，所以凶险。用人事比喻为修德惠人者应善始善终，不可功败垂成。
        """
    },
    "23": {
        "name": "泽火革卦",
        "guaci": """
　　 《革》：已日乃孚。元亨。利贞，悔亡。
----------------------------
　　 《彖》曰：革，水火相息，二女同居，其志不相得曰革。“已日乃孚”，革而信之。文明以说，大亨以正。革而当，其悔乃亡。天地革而四时成，汤武革命，顺乎天而应乎人。革之时大矣哉！古
　　 《象》曰：泽中有火，革。君子以治历明时。
　　 初九，巩用黄牛之革。
　　 《象》曰：“巩用黄牛”，不可以有为也。
　　 六二，巳日乃革之，征吉，无咎。
　　 《象》曰：“巳日革之”，行有嘉也。
　　 九三，征凶。贞厉。革言三就，有孚。
　　 《象》曰：“革言三就”，又何之矣。
　　 九四，悔亡。有孚改命，吉。
　　 《象》曰：“改命之吉”，信志也。
　　 九五，大人虎变，未占有孚。
　　 《象》曰：“大人虎变”，其文炳也。
　　 上六，君子豹变，小人革面，征凶，居贞吉。
　　 《象》曰：“君子豹变”，其文蔚也。“小人革面”，顺以从君也。
----------------------------
革卦，象征改革，变革。离为火，兑为泽，泽中有火。火性燥，泽性湿，二物不相得，会有变动，所以泽中有火，为革。革，是改的意思，象征变革。
在面临必须变革的时刻，应果断采取行动。只要变革的动机纯正，群众就会拥护，变革就会成功。后悔也可以消除。
        """
    },
    "35": {
        "name": "火风鼎卦",
        "guaci": """
　　 《鼎》：元吉，亨。
----------------------------
　　 《彖》曰：鼎，象也。以木巽火，亨饪也。圣人亨以享上帝，而大亨以养圣贤。巽而耳目聪明，柔进而上行，得中而应乎刚，是以元亨。
　　 《象》曰：木上有火，鼎。君子以正位凝命。
　　 初六，鼎颠趾，利出否。得妾以其子，无咎。
　　 《象》曰：“鼎颠趾”，未悖也。“利出否”，以従贵也。
　　 九二，鼎有实，我仇有疾，不我能即，吉。
　　 《象》曰：“鼎有实”，慎所之也。“我仇有疾”，终无尤也。
　　 九三，鼎耳革，其行塞，雉膏不食，方雨，亏悔，终吉。
　　 《象》曰：“鼎耳革”，失其义也。
　　 九四，鼎折足，覆公餗，其形渥，凶。
　　 《象》曰：“覆公餗”，信如何也。
　　 六五，鼎黄耳金铉，利贞。
　　 《象》曰：“鼎黄耳”，中以为实也。
　　 上九，鼎玉铉，大吉，无不利。
　　 《象》曰：玉铉在上，刚柔节也。
----------------------------
巽为木，离为火，木上有火，即木上燃烧着火焰，呈烹饪的状态，为鼎。鼎者，烹饪的器皿。故鼎象征鼎器。
鼎器既可烹物，又是权力法制的象征。君子持鼎意味着执行权力，贤士会被君王赏识，所以此时必大吉而后亨通顺利。
        """
    },
    "44": {
        "name": "震为雷卦",
        "guaci": """
　　 《震》：亨。震来虩虩，笑言哑哑，震惊百里，不丧匕鬯。
----------------------------
　　 《彖》曰：震，亨。“震来虩虩”，恐致福也。“笑言哑哑”，后有则也。“震惊百里”，惊远而惧迩也。“不丧匕鬯”，出可以守宗庙社稷，以为祭主也。
　　 《象》曰：洊雷，震。君子以恐惧修省。
　　 初九，震来虩虩，后笑言哑哑，吉。
　　 《象》曰：“震来虩虩”，恐致福也。“笑言哑哑”，后有则也。
　　 六二，震来厉，亿丧贝，跻于九陵，勿逐，七日得。
　　 《象》曰：“震来厉”，乘刚也。
　　 六三，震苏苏，震行无眚。
　　 《象》曰：“震苏苏”，位不当也。
　　 九四，震遂泥。
　　 《象》曰：“震遂泥”，未光也。
　　 六五，震往来，厉，意无丧，有事。
　　 《象》曰：“震往来厉”，危行也。其事在中，大无丧也。
　　 上六，震索索，视矍矍，征凶。震不于其躬，于其邻，无咎。婚媾有言。
　　 《象》曰：“震索索”，中未得也。虽凶无咎，畏邻戒也。
----------------------------
震卦，象征雷声、震动。震为雷，上下均为震，叠连轰响着巨雷，谓震。震象征雷声震动。
雷声震动，使万物皆惧而知道戒备，因此顺利亨通而致福。这样遇到大事从容镇定，就可以出头主持祭祀，担当保家卫国的重任了。
        """
    },
    "77": {
        "name": "艮为山卦",
        "guaci": """
　　 《艮》：艮其背，不获其身，行其庭，不见其人，无咎。
----------------------------
　　 《彖》曰：艮，止也。时止则止，时行则行，动静不失其时，其道光明。“艮其止”，止其所也。上下敌应，不相与也。是以“不获其身，行其庭，不见其人，无咎”也。
　　 《象》曰：兼山，艮。君子以思不出其位。
　　 初六，艮其趾，无咎。利永贞。
　　 《象》曰：“艮其趾”，未失正也。
　　 六二，艮其腓，不拯其随，其心不快。
　　 《象》曰：“不拯其随”，未退听也。
　　 九三，艮其限，列其夤，厉，熏心。
　　 《象》曰：“艮其限”，危熏心也。
　　 六四，艮其身，无咎。
　　 《象》曰：“艮其身”，止诸躬也。
　　 六五，艮其辅，言有序，悔亡。
　　 《象》曰：“艮其辅”，以中正也。
　　 上九，敦艮，吉。
　　 《象》曰：“敦艮之吉”，以厚终也。
----------------------------
艮为山，特性止，一山已能镇止，两山重叠，止义更大。故民象征抑止。
艮卦所说的止，是在应当止的时候止，应当行的时候行，动静不失时机，前途必然光明。抑止人的邓欲，应内心宁静。止得其所，才无过失。
        """
    },
    "57": {
        "name": "风山渐卦",
        "guaci": """
　　 《渐》：女归吉，利贞。
----------------------------
　　 《彖》曰：渐之进也，女归吉也。进得位，往有功也。进以正，可以正邦也。其位刚得中也。止而巽，动不穷也。
　　 《象》曰：山上有木，渐。君子以居贤德善俗。
　　 初六，鸿渐于干。小子厉，有言，无咎。
　　 《象》曰：“小子之厉”，义无咎也。
　　 六二，鸿渐于磐，饮食衎衎，吉。
　　 《象》曰：“饮食衎衎”，不素饱也。
　　 九三，鸿渐于陆。夫征不复，妇孕不育，凶。利御寇。
　　 《象》曰：“夫征不复”，离群丑也。“妇孕不育”，失其道也。“利用御寇”，顺相保也。
　　 六四，鸿渐于木，或得其桷，无咎。
　　 《象》曰：“或得其桷”，顺以巽也。
　　 九五，鸿渐于陵，妇三岁不孕，终莫之胜，吉。
　　 《象》曰：“终莫之胜吉”，得所愿也。
　　 上九，鸿渐于陆，其羽可用为仪，吉。
　　 《象》曰：“其羽可用为仪，吉”，不可乱也。
----------------------------
渐卦，象征渐进。艮为山，巽为木，山上之木为高大之木，高大之木慢慢成长，徐而不速，为渐，渐者，徐缓慢进。
故渐象征渐进。渐渐地在前进，如同女子出长家，循礼渐行可获吉祥。并且渐进需遵循正道，才会有利。
        """
    },
    "42": {
        "name": "雷泽归妹卦",
        "guaci": """
　　 《归妹》：征凶，无攸利。
----------------------------
　　 《彖》曰：归妹，天地之大义也。天地不交而万物不兴。归妹，人之终始也。说以动，所归妹也。“征凶”，位不当也。“无攸利”，柔乘刚也。
　　 《象》曰：泽上有雷，归妹。君子以永终知敝。
　　 初九，归妹以娣。跛能履，征吉。
　　 《象》曰：“归妹以娣”，以恒也。“跛能履吉”，相承也。
　　 九二，眇能视，利幽人之贞。
　　 《象》曰：“利幽人之贞”，未变常也。
　　 六三，归妹以须，反归以娣。
　　 《象》曰：“归妹以须”，未当也。
　　 九四，归妹愆期，迟归有时。
　　 象曰：“愆期”之志，有待而行也。
　　 六五，帝乙归妹，其君之袂不如其娣之袂良。月几望，吉。
　　 《象》曰：“帝乙归妹，不如其娣之袂良”也。其位在中，以贵行也。
　　 上六，女承筐无实，士刲羊无血，无攸利。
　　 《象》曰：上六无实，承虚筐也。
----------------------------
归妹卦，象征出嫁、婚嫁。兑为泽、为阴，性悦，震为雷、为阳，性动。雷震于上，泽随而动，为女从男之象，为归妹。归妹象征少女出嫁。
婚嫁是天地间最正当的事，但是必须遵循正道，才会吉祥。但少女与长男不相配，行为不当的婚嫁，会有凶险，没有什么利益。
        """
    },
    "43": {
        "name": "雷火丰卦",
        "guaci": """
　　 《丰》：亨，王假之。勿忧，宜日中。
----------------------------
　　 《彖》曰：丰，大也。明以动，故丰。“王假之”，尚大也。“勿忧宜日中”，宜照天下也。日中则昃，月盈则食，天地盈虚，与时消息，而况于人乎，况于鬼神乎？知
　　 《象》曰：雷电皆至，丰。君子以折狱致刑。
　　 初九，遇其配主，虽旬无咎，往有尚。
　　 《象》曰：“虽旬无咎”，过旬灾也。
　　 六二，丰其蔀，日中见斗。往得疑疾，有孚发若，吉。
　　 《象》曰：“有孚发若”，信以发志也。
　　 九三，丰其沛，日中见沫，折其右肱，无咎。
　　 《象》曰：“丰其沛”，不可大事也。“折其右肱”，终不可用也。
　　 九四，丰其蔀，日中见斗，遇其夷主，吉。
　　 《象》曰：“丰其蔀”，位不当也。“日中见斗”，幽不明也。“遇其夷主”，吉行也。
　　 六五，来章有庆誉，吉。
　　 《象》曰：六五之吉，有庆也。
　　 上六，丰其屋，蔀其家，窥其户，阒其无人，三岁不觌，凶。
　　 《象》曰：“丰其屋”，天际翔也。“窥其户，阒其无人”，自藏也。
----------------------------
丰卦，象征丰盛，硕大。离为电、火，震为雷。雷电俱至，威明备足，为丰。丰含有丰大、丰硕、丰盛、丰满之义。
象征丰盈硕大。丰盛之时，自然亨通。但致丰之道，必须有德者才能获得。故有德君王能使天下丰盛，并让盛德之光普照天下。
        """
    },
    "37": {
        "name": "火山旅卦",
        "guaci": """
　　 《旅》：小亨。旅贞吉。
----------------------------
　　 《彖》曰：“旅小亨”，柔得中乎外，而顺乎刚，止而丽乎明，是以“小亨旅贞吉”也。旅之时义大矣哉！古
　　 《象》曰：山上有火，旅。君子以明慎用刑而不留狱。
　　 初六，旅琐琐，斯其所取灾。
　　 《象》曰：“旅琐琐”，志穷灾也。
　　 六二，旅即次，怀其资，得童仆，贞。
　　 《象》曰：“得童仆贞”，终无尤也。
　　 九三，旅焚其次，丧其童仆，贞厉。
　　 《象》曰：“旅焚其次”，亦以伤矣。以旅与下，其义丧也。
　　 九四，旅于处，得其资斧，我心不快。
　　 《象》曰：“旅于处”，未得位也。“得其资斧”，心未快也。
　　 六五，射雉，一矢亡，终以誉命。
　　 《象》曰：“终以誉命”，上逮也。
　　 上九，鸟焚其巢，旅人先笑后号咷。丧牛于易，凶。
　　 《象》曰：以旅在上，其义焚也。“丧牛于易”，终莫之闻也。
----------------------------
艮为山，离为火，火在山上燃烧，势非长久，为旅。旅者，失其本居，而寄他方，所以旅象征旅行。
在外旅行，只会小有亨通。能遵循正道，才会吉祥。
        """
    },
    "55": {
        "name": "巽为风卦",
        "guaci": """
　　 《巽》：小亨。利有攸往。利见大人。
----------------------------
　　 《彖》曰：重巽以申命。刚巽乎中正而志行。柔皆顺乎刚，是以“小亨，利有攸往，利见大人”。
　　 《象》曰：随风，巽。君子以申命行事。
　　 初六，进退，利武人之贞。
　　 《象》曰：“进退”，志疑也。“利武人之贞”，志治也。
　　 九二，巽在床下，用史巫纷若，吉，无咎。
　　 《象》曰：“纷若之吉”，得中也。
　　 九三，频巽，吝。
　　 《象》曰：“频巽之吝”，志穷也。
　　 六四，悔亡，田获三品。
　　 《象》曰：“田获三品”，有功也。
　　 九五，贞吉，悔亡，无不利，无初有终。先庚三日，后庚三日，吉。
　　 《象》曰：九五之吉，位正中也。
　　 上九，巽在床下，丧其资斧，贞凶。
　　 《象》曰：“巽在床下”，上穷也。“丧其资斧”，正乎凶也。
----------------------------
巽卦，象征随顺、进入。巽为风，性入。风之入物，无所不至，无所不顺。凡物沿“顺”则能“入”。故巽为顺。巽象征顺从。
行事谦顺，可致顺利亨通，但巽卦是阴卦，只能小有亨通。
阴顺从阳，合乎自然的道理，前进有利，但顺从也办须选择对象，不可盲从，顺从伟大的人物有利。
        """
    },
    "22": {
        "name": "兑为泽卦",
        "guaci": """
　　 《兑》：亨。利贞。
----------------------------
　　 《彖》曰：兑，说也。刚中而柔外，说以利贞，是以顺乎天而应乎人。说以先民，民忘其劳。说以犯难，民忘其死。说之大，民劝矣哉！古
　　 《象》曰：丽泽，兑。君子以朋友讲习。
　　 初九，和兑，吉。
　　 《象》曰：“和兑之吉”，行未疑也。
　　 九二，孚兑，吉，悔亡。
　　 《象》曰：“孚兑之吉”，信志也。
　　 六三，来兑，凶。
　　 《象》曰：“来兑之凶”，位不当也。
　　 九四，商兑未宁，介疾有喜。
　　 《象》曰：“九四之喜”，有庆也。
　　 九五，孚于剥，有厉。
　　 《象》曰：“孚于剥”，位正当也。
　　 上六，引兑。
　　 《象》曰：上六“引兑”，未光也。
----------------------------
兑为泽，兑性悦，上下皆悦，为兑。故兑象征欣悦。
刚正不失外悦，柔悦不失内刚，内外刚柔兼济，不谄媚，不暴戾，亨通畅达。但须动机纯正，使人喜欢才会有利。
        """
    },
    "56": {
        "name": "风水涣卦",
        "guaci": """
　　 《涣》：亨。王假有庙。利涉大川，利贞。
----------------------------
　　 《彖》曰：“涣，亨”，刚来而不穷，柔得位乎外而上同。“王假有庙”，王乃在中也。“利涉大川”，乘木有功也。
　　 《象》曰：风行水上，涣。先王以享于帝，立庙。
　　 初六，用拯马壮，吉。
　　 《象》曰：初六之吉顺也。
　　 九二，涣奔其机，悔亡。
　　 《象》曰：“涣奔其机”，得愿也。
　　 六三，涣其躬，无悔。
　　 《象》曰：“涣其躬”，志在外也。
　　 六四，涣其群，元吉。涣有丘，匪夷所思。
　　 《象》曰：“涣其群元吉”，光大也。
　　 九五，涣汗其大号，涣王居，无咎。
　　 《象》曰：“王居无咎”，正位也。
　　 上九，涣其血，去逖出，无咎。
　　 《象》曰：“涣其血”，远害也。
----------------------------
坎为水，巽为风。风行水上，水波离散，为涣。涣象征涣散。有涣发离散的意思。处“涣”之时，形散而神聚。
散聚相依，必然亨通顺利。此时，君王应以至诚到宗庙祈祷，获得神的保佑，聚合人力来排险济难。 
        """
    },
    "62": {
        "name": "水泽节卦",
        "guaci": """
　　 《节》：亨。苦节，不可贞。
----------------------------
　　 《彖》曰：“节亨”。刚柔分而刚得中。“苦节不可贞”，其道穷也。说以行险，当位以节，中正以通。天地节而四时成。节以制度，不伤财，不害民。
　　 《象》曰：泽上有水，节。君子以制数度，议德行。
　　 初九，不出户庭，无咎。
　　 《象》曰：“不出户庭”，知通塞也。
　　 九二，不出门庭，凶。
　　 《象》曰：“不出门庭凶”，失时极也。
　　 六三，不节若，则嗟若，无咎。
　　 《象》曰：“不节之嗟”，又谁咎也。
　　 六四，安节。亨。
　　 《象》曰：“安节之亨”，承上道也。
　　 九五，甘节，吉，往有尚。
　　 《象》曰：“甘节之吉”，居位中也。
　　 上六，苦节，贞凶，悔亡。
　　 《象》曰：“苦节贞凶”，其道穷也。
----------------------------
节卦，象征节制、节俭。兑为泽，坎为水。泽之容水，会有限量，过度就会溢出，应加以节制。
节有止之义，象征节制。节制是美德，能自觉有所节制，处中守正必然亨通。但过分节制，会使自己吃苦，故要适中。 
        """
    },
    "52": {
        "name": "风泽中孚卦",
        "guaci": """
　　 《中孚》：豚鱼，吉。利涉大川，利贞。
----------------------------
　　 《彖》曰：“中孚”，柔在内而刚得中，说而巽，孚乃化邦也。“豚鱼吉”，信及豚鱼也。“利涉大川”，乘木舟虚也。中孚以利贞，乃应乎天也。
　　 《象》曰：泽上有风，中孚。君子以议狱缓死。
　　 初九，虞吉，有它不燕。
　　 《象》曰：初九“虞吉”，志未变也。
　　 九二，鸣鹤在阴，其子和之。我有好爵，吾与尔靡之。
　　 《象》曰：“其子和之”，中心愿也。
　　 六三，得敌，或鼓或罢，或泣或歌。
　　 《象》曰：“或鼓或罢”，位不当也。
　　 六四，月几望，马匹亡，无咎。
　　 《象》曰：“马匹亡”，绝类上也。
　　 九五，有孚挛如，无咎。
　　 《象》曰：“有孚挛如”，位正当也。
　　 上九，翰音登于天，贞凶。
　　 《象》曰：“翰音登于天”，何可长也？
----------------------------
中孚卦，象征诚信、诚实。兑为泽，巽为风。风行泽上，无所不至，上下交孚，有诚信之德，为中孚。所以中孚象征诚信。
诚信能感化万物，即使用简单的豚和鱼作为祭品，仍然会被神嘉纳赐福，所以吉祥。利于冒险排难，利于持正。
        """
    },
    "47": {
        "name": "雷山小过卦",
        "guaci": """
　　 《小过》：亨。利贞。可小事，不可大事。飞鸟遗之音，不宜上，宜下，大吉。
----------------------------
　　 《彖》曰：小过，小者过而亨也。过以利贞，与时行也。柔得中，是以小事吉也。刚失位而不中，是以不可大事也。有飞鸟之象焉，“飞鸟遗之音，不宜上，宜下，大吉”，上逆而下顺也。
　　 《象》曰：山上有雷，小过。君子以行过乎恭，丧过乎哀，用过乎俭。
　　 初六，飞鸟以凶。
　　 《象》曰：“飞鸟以凶”，不可如何也。
　　 六二，过其祖，遇其妣。不及其君，遇其臣。无咎。
　　 《象》曰：“不及其君”，臣不可过也。
　　 九三，弗过防之，従或戕之，凶。
　　 《象》曰：“従或戕之”，凶如何也？斋
　　 九四，无咎。弗过遇之，往厉必戒，勿用永贞。
　　 《象》曰：“弗过遇之”，位不当也。“往厉必戒”，终不可长也。
　　 六五，密云不雨，自我西郊。公弋取彼在穴。
　　 《象》曰：“密云不雨”，已上也。
　　 上六，弗遇过之，飞鸟离之，凶，是谓灾眚。
　　 《象》曰：“弗遇过之”，已亢也。
----------------------------
小过卦，象征小的过度、小的超越。艮为山，震为雷，山顶上响着震雷，其声过常，谓之小过。小过象征小有过越。有小的过失、过度等义。
小过升本身有亨通的含义，但必须守持正道，且只适用于日常小事，而不适用于天下大事，所以小有过度时，莫好高鹜远，应当务实，才会大吉大利。
        """
    },
    "63": {
        "name": "水火既济卦",
        "guaci": """
　　 《既济》：亨小，利贞。初吉终乱。
----------------------------
　　 《彖》曰：“既济，亨”，小者亨也。“利贞”。刚柔正而位当也。“初吉”，柔得中也。“终止则乱”，其道穷也。
　　 《象》曰：水在火上，既济。君子以思患而豫防之。
　　 初九，曳其轮，濡其尾，无咎。
　　 《象》曰：“曳其轮”，义无咎也。
　　 六二，“妇丧其茀，勿逐，七日得。
　　 《象》曰：“七日得”，以中道也。
　　 九三，高宗伐鬼方，三年克之，小人勿用。
　　 《象》曰：“三年克之”，惫也。
　　 六四，繻有衣袽，终日戒。
　　 《象》曰：“终日戒”，有所疑也。
　　 九五，东邻杀牛，不如西邻之禴祭，实受其福。
　　 《象》曰：“东邻杀牛”，不如西邻之时也。“实受其福”，吉大来也。
　　 上六，濡其首，厉。
　　 《象》曰：“濡其首厉”，何可久也？
----------------------------
既济卦，象征成功、完成。离为火，坎为水，水在火上，似煮成食物，谓既济。既济象征事已成、成功。六十四卦只有本卦六爻刚柔均当位。
但是过于完整，反而僵化，不能再有大的作为，因此，必须坚守正道，继续奋发努力。否则，必将是起初吉祥，最终危乱。
        """
    },
    "36": {
        "name": "火水未济卦",
        "guaci": """
　　 《未济》：亨。小狐汔济，濡其尾，无攸利。
----------------------------
　　 《彖》曰：“未济，亨”，柔得中也。“小狐汔济”，未出中也。“濡其尾，无攸利”，不续终也。虽不当位，刚柔应也。
　　 《象》曰：火在水上，未济。君子以慎辨物居方。
　　 初六，濡其尾，吝。
　　 《象》曰：“濡其尾”，亦不知极也。
　　 九二，曳其轮，贞吉。
　　 《象》曰：九二贞吉，中以行正也。
　　 六三，未济，征凶。利涉大川。
　　 《象》曰：“未济征凶”，位不当也。
　　 九四，贞吉，悔亡，震用伐鬼方，三年，有赏于大国。
　　 《象》曰：“贞吉悔亡”，志行也。
　　 六五，贞吉，无悔。君子之光，有孚吉。
　　 《象》曰：“君子之光”，其辉吉也。
　　 上九，有孚于饮酒，无咎。濡其首，有孚失是。
　　 《象》曰：“饮酒濡首”，亦不知节也。
----------------------------
未济卦，象征未完成、还没有终止。坎为水，离为火。火在水上，难以济物，为未济。未济象征事未成。本卦六爻均失正，有“事未成”之象。
但阳刚阴柔能相应，充满着发展的可能性。未济有可济之理，因而亨通。但若处事不谨慎，则没有什么利益。
        """
    }
}


def main():
    up = random.randint(1, 8)
    down = random.randint(1, 8)
    change = random.randint(1, 6)
    explain(up, down, change)


def explain(up, down, change):
    tmp = str(up)+str(down)
    print(m[tmp]["name"], "|", [change])
    print("----------------------------")
    print(m[tmp]["guaci"])


if __name__ == '__main__':
    main()
