# compas_timber

[![Github Actions Build Status](https://github.com/gramaziokohler/compas_timber/workflows/build/badge.svg)](https://github.com/gramaziokohler/compas_timber/actions)
[![codecov](https://codecov.io/gh/gramaziokohler/compas_timber/graph/badge.svg?token=EFI7G1T18Z)](https://codecov.io/gh/gramaziokohler/compas_timber)
[![License](https://img.shields.io/github/license/gramaziokohler/compas_timber.svg)](https://pypi.python.org/pypi/compas_timber)
[![pip downloads](https://img.shields.io/pypi/dm/compas_timber)](https://pypi.python.org/project/compas_timber)
[![PyPI Package latest release](https://img.shields.io/pypi/v/compas_timber.svg)](https://pypi.python.org/pypi/compas_timber)
[![Supported implementations](https://img.shields.io/pypi/implementation/compas_timber.svg)](https://pypi.python.org/pypi/compas_timber)
[![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.7934267.svg)](https://doi.org/10.5281/zenodo.7934267)
[![Twitter Follow](https://img.shields.io/twitter/follow/compas_dev?style=social)](https://twitter.com/compas_dev)

![COMPAS Timber](https://raw.githubusercontent.com/gramaziokohler/compas_timber/main/docs/_images/compas_timber.jpg)

`compas_timber` is a user-friendly open-source software toolkit to streamline the design of timber frame structures. Despite its advances in digitalization compared to other building techniques, timber construction is often perceived as a challenging field, involving intricate processes in design, planning, coordination, and fabrication. We aim to increase the use of timber in architecture by lowering the threshold of creating versatile and resource-aware designs.

## Installation

> It is recomended you install `compas_timber` inside a virtual environment.

```bash
pip install compas_timber
```

To install `compas_timber` to Rhino run

```bash
python -m compas_rhino.install
```

## First Steps

* [Documentation](https://gramaziokohler.github.io/compas_timber/)
* [COMPAS TIMBER Grasshopper Tutorial](https://gramaziokohler.github.io/compas_timber/latest/tutorials.html)
* [COMPAS TIMBER API Reference](https://gramaziokohler.github.io/compas_timber/latest/api.html)

## Questions and feedback

We encourage the use of the [COMPAS framework forum](https://forum.compas-framework.org/)
for questions and discussions.

## Issue tracker

If you found an issue or have a suggestion for a dandy new feature, please file a new issue in our [issue tracker](https://github.com/gramaziokohler/compas_timber/issues).

## Contributing

We love contributions!

Check the [Contributor's Guide](https://github.com/gramaziokohler/compas_timber/blob/main/CONTRIBUTING.md)
for more details.

## Credits

`compas_timber` is currently developed by Gramazio Kohler Research. See the [list of authors](https://github.com/gramaziokohler/compas_timber/blob/main/AUTHORS.md) for a complete overview.
