# This file was auto-generated by Fern from our API Definition.

import typing

import httpx

from .core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .dataset.client import AsyncDatasetClient, DatasetClient
from .environment import AthenaEnvironment
from .message.client import AsyncMessageClient, MessageClient
from .query.client import AsyncQueryClient, QueryClient
from .report.client import AsyncReportClient, ReportClient
from .snippet.client import AsyncSnippetClient, SnippetClient


class BaseAthena:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propogate to these functions.

    Parameters:
        - base_url: typing.Optional[str]. The base url to use for requests from the client.

        - environment: AthenaEnvironment. The environment to use for requests from the client. from .environment import AthenaEnvironment

                                          Defaults to AthenaEnvironment.DEFAULT

        - api_key: str.

        - timeout: typing.Optional[float]. The timeout to be used, in seconds, for requests by default the timeout is 60 seconds.

        - httpx_client: typing.Optional[httpx.Client]. The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.
    ---
    from athena.client import Athena

    client = Athena(
        api_key="YOUR_API_KEY",
    )
    """

    def __init__(
        self,
        *,
        base_url: typing.Optional[str] = None,
        environment: AthenaEnvironment = AthenaEnvironment.DEFAULT,
        api_key: str,
        timeout: typing.Optional[float] = 60,
        httpx_client: typing.Optional[httpx.Client] = None
    ):
        self._client_wrapper = SyncClientWrapper(
            base_url=_get_base_url(base_url=base_url, environment=environment),
            api_key=api_key,
            httpx_client=httpx.Client(timeout=timeout) if httpx_client is None else httpx_client,
        )
        self.message = MessageClient(client_wrapper=self._client_wrapper)
        self.dataset = DatasetClient(client_wrapper=self._client_wrapper)
        self.snippet = SnippetClient(client_wrapper=self._client_wrapper)
        self.report = ReportClient(client_wrapper=self._client_wrapper)
        self.query = QueryClient(client_wrapper=self._client_wrapper)


class AsyncBaseAthena:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propogate to these functions.

    Parameters:
        - base_url: typing.Optional[str]. The base url to use for requests from the client.

        - environment: AthenaEnvironment. The environment to use for requests from the client. from .environment import AthenaEnvironment

                                          Defaults to AthenaEnvironment.DEFAULT

        - api_key: str.

        - timeout: typing.Optional[float]. The timeout to be used, in seconds, for requests by default the timeout is 60 seconds.

        - httpx_client: typing.Optional[httpx.AsyncClient]. The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.
    ---
    from athena.client import AsyncAthena

    client = AsyncAthena(
        api_key="YOUR_API_KEY",
    )
    """

    def __init__(
        self,
        *,
        base_url: typing.Optional[str] = None,
        environment: AthenaEnvironment = AthenaEnvironment.DEFAULT,
        api_key: str,
        timeout: typing.Optional[float] = 60,
        httpx_client: typing.Optional[httpx.AsyncClient] = None
    ):
        self._client_wrapper = AsyncClientWrapper(
            base_url=_get_base_url(base_url=base_url, environment=environment),
            api_key=api_key,
            httpx_client=httpx.AsyncClient(timeout=timeout) if httpx_client is None else httpx_client,
        )
        self.message = AsyncMessageClient(client_wrapper=self._client_wrapper)
        self.dataset = AsyncDatasetClient(client_wrapper=self._client_wrapper)
        self.snippet = AsyncSnippetClient(client_wrapper=self._client_wrapper)
        self.report = AsyncReportClient(client_wrapper=self._client_wrapper)
        self.query = AsyncQueryClient(client_wrapper=self._client_wrapper)


def _get_base_url(*, base_url: typing.Optional[str] = None, environment: AthenaEnvironment) -> str:
    if base_url is not None:
        return base_url
    elif environment is not None:
        return environment.value
    else:
        raise Exception("Please pass in either base_url or environment to construct the client")
