# This file was auto-generated by Fern from our API Definition.

import time
import typing

from athena.types.message_out_dto import MessageOutDto

from .core import RequestOptions
from .message.client import AsyncMessageClient, MessageClient
from .types.model import Model
from .types.tools import Tools
from .types.status_enum import StatusEnum

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class MessagePollingClient(MessageClient):

    def submit_and_poll(
        self,
        *,
        content: str,
        model: typing.Optional[Model] = OMIT,
        tools: typing.Optional[typing.Sequence[Tools]] = OMIT,
        conversation_id: typing.Optional[str] = OMIT,
        conversation_name: typing.Optional[str] = OMIT,
        poll_interval: int = 2,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> MessageOutDto:
        """
        Parameters:
            - content: str.

            - model: typing.Optional[Model].

            - tools: typing.Optional[typing.Sequence[Tools]].

            - conversation_id: typing.Optional[str].

            - conversation_name: typing.Optional[str].

            - poll_interval: int. The polling interval in seconds.

            - request_options: typing.Optional[RequestOptions]. Request-specific configuration.
        ---
        from athena import Model, Tools
        from athena.client import Athena

        client = Athena(
            api_key="YOUR_API_KEY",
        )
        client.message.submit(
            content="visit www.athenaintelligence.ai and summarize the website in one paragraph",
            model=Model.GPT_4_TURBO_PREVIEW,
            tools=[Tools.SEARCH, Tools.BROWSE],
        )
        """
        response = super().submit(
          content=content,
          model=model,
          tools=tools,
          conversation_id=conversation_id, 
          conversation_name=conversation_name,
          request_options=request_options)
        message = self.get(id=response.id)
        while message.status == StatusEnum.PENDING:
            time.sleep(poll_interval)
            message = self.get(id=message.id)
        return message


class AsyncMessagePollingClient(AsyncMessageClient):

    async def submit_and_poll(
        self,
        *,
        content: str,
        model: typing.Optional[Model] = OMIT,
        tools: typing.Optional[typing.Sequence[Tools]] = OMIT,
        conversation_id: typing.Optional[str] = OMIT,
        conversation_name: typing.Optional[str] = OMIT,
        poll_interval: int = 2,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> MessageOutDto: 
        """
        Parameters:
            - content: str.

            - model: typing.Optional[Model].

            - tools: typing.Optional[typing.Sequence[Tools]].

            - conversation_id: typing.Optional[str].

            - conversation_name: typing.Optional[str].

            - poll_interval: int. The polling interval in seconds.

            - request_options: typing.Optional[RequestOptions]. Request-specific configuration.
        ---
        from athena import Model, Tools
        from athena.client import AsyncAthena

        client = AsyncAthena(
            api_key="YOUR_API_KEY"
        )
        client.message.submit(
            content="visit www.athenaintelligence.ai and summarize the website in one paragraph",
            model=Model.GPT_4_TURBO_PREVIEW,
            tools=[Tools.SEARCH, Tools.BROWSE],
        )
        """
        response = await super().submit(
          content=content,
          model=model,
          tools=tools,
          conversation_id=conversation_id, 
          conversation_name=conversation_name,
          request_options=request_options)
        message = await self.get(id=response.id)
        while message.status == StatusEnum.PENDING:
            time.sleep(poll_interval)
            message = await self.get(id=message.id)
        return message
