import shutil
import sys
from pathlib import Path

from pomerge import find_translations, main

FIXTURE_DIR = (Path(__file__).parent / "fixtures").resolve()


def test_simple_run(monkeypatch, tmp_path):
    shutil.copy(FIXTURE_DIR / "empty-sphinx.po", tmp_path)
    monkeypatch.setattr(
        sys,
        "argv",
        [
            "pomerge",
            "--from",
            str(FIXTURE_DIR / "sphinx.po"),
            "--to",
            str(tmp_path / "empty-sphinx.po"),
        ],
    )
    main()
    assert find_translations(str(FIXTURE_DIR / "sphinx.po")) == find_translations(
        str(tmp_path / "empty-sphinx.po")
    )


def test_clean(monkeypatch, tmp_path):
    shutil.copy(FIXTURE_DIR / "empty-sphinx.po", tmp_path)
    shutil.copy(FIXTURE_DIR / "empty-sphinx.po", tmp_path / "should-remain-empty.po")
    monkeypatch.setattr(
        sys,
        "argv",
        [
            "pomerge",
            "--from",
            str(FIXTURE_DIR / "sphinx.po"),
            "--to",
            str(tmp_path / "empty-sphinx.po"),
            "--clear",
        ],
    )
    main()
    monkeypatch.setattr(
        sys,
        "argv",
        ["pomerge", "--to", str(tmp_path / "should-remain-empty.po")],
    )
    main()
    assert find_translations(str(FIXTURE_DIR / "sphinx.po")) == find_translations(
        str(tmp_path / "empty-sphinx.po")
    )
    assert not find_translations(str(tmp_path / "should-remain-empty.po"))
