# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DynamicHostVolumeRegistrationArgs', 'DynamicHostVolumeRegistration']

@pulumi.input_type
class DynamicHostVolumeRegistrationArgs:
    def __init__(__self__, *,
                 capabilities: pulumi.Input[Sequence[pulumi.Input['DynamicHostVolumeRegistrationCapabilityArgs']]],
                 host_path: pulumi.Input[builtins.str],
                 node_id: pulumi.Input[builtins.str],
                 capacity: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 namespace: Optional[pulumi.Input[builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a DynamicHostVolumeRegistration resource.
        :param pulumi.Input[Sequence[pulumi.Input['DynamicHostVolumeRegistrationCapabilityArgs']]] capabilities: `(block: <optional>)` - Option for validating the capability of a
               volume. Each capability block has the following attributes:
        :param pulumi.Input[builtins.str] host_path: `(string)` - The path on disk where the volume exists.
        :param pulumi.Input[builtins.str] node_id: `(string: <required>)` - A specific node where the volume is
               mounted.
        :param pulumi.Input[builtins.str] capacity: `(string: <optional>)` - The size of a volume in bytes. Either the
               physical size of a disk or a quota, depending on the plugin. This field must
               be between the `capacity_min` and `capacity_max` values unless they are
               omitted. Accepts human-friendly suffixes such as `"100GiB"`.
        :param pulumi.Input[builtins.str] name: `(string: <required>)` - The name of the volume, which is used as the
               [`volume.source`][volume_source] field in job specifications that claim this
               volume. Host volume names must be unique per node. Names are visible to any
               user with `node:read` ACL, even across namespaces, so they should not be
               treated as sensitive values.
        :param pulumi.Input[builtins.str] namespace: `(string: <optional>)` - The namespace of the volume. This field
               overrides the namespace provided by the `-namespace` flag or `NOMAD_NAMESPACE`
               environment variable. Defaults to `"default"` if unset.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] parameters: `(map<string|string>: <optional>)` - A key-value map of strings
               passed directly to the plugin to configure the volume. The details of these
               parameters are specific to the plugin.
               
               
               [`access_mode`]: /nomad/docs/other-specifications/volume/capability#access_mode
               [`attachment_mode`]: /nomad/docs/other-specifications/volume/capability#attachment_mode
               [volume_source]: /nomad/docs/job-specification/volume#source
        """
        pulumi.set(__self__, "capabilities", capabilities)
        pulumi.set(__self__, "host_path", host_path)
        pulumi.set(__self__, "node_id", node_id)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def capabilities(self) -> pulumi.Input[Sequence[pulumi.Input['DynamicHostVolumeRegistrationCapabilityArgs']]]:
        """
        `(block: <optional>)` - Option for validating the capability of a
        volume. Each capability block has the following attributes:
        """
        return pulumi.get(self, "capabilities")

    @capabilities.setter
    def capabilities(self, value: pulumi.Input[Sequence[pulumi.Input['DynamicHostVolumeRegistrationCapabilityArgs']]]):
        pulumi.set(self, "capabilities", value)

    @property
    @pulumi.getter(name="hostPath")
    def host_path(self) -> pulumi.Input[builtins.str]:
        """
        `(string)` - The path on disk where the volume exists.
        """
        return pulumi.get(self, "host_path")

    @host_path.setter
    def host_path(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "host_path", value)

    @property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> pulumi.Input[builtins.str]:
        """
        `(string: <required>)` - A specific node where the volume is
        mounted.
        """
        return pulumi.get(self, "node_id")

    @node_id.setter
    def node_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "node_id", value)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `(string: <optional>)` - The size of a volume in bytes. Either the
        physical size of a disk or a quota, depending on the plugin. This field must
        be between the `capacity_min` and `capacity_max` values unless they are
        omitted. Accepts human-friendly suffixes such as `"100GiB"`.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `(string: <required>)` - The name of the volume, which is used as the
        [`volume.source`][volume_source] field in job specifications that claim this
        volume. Host volume names must be unique per node. Names are visible to any
        user with `node:read` ACL, even across namespaces, so they should not be
        treated as sensitive values.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `(string: <optional>)` - The namespace of the volume. This field
        overrides the namespace provided by the `-namespace` flag or `NOMAD_NAMESPACE`
        environment variable. Defaults to `"default"` if unset.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        `(map<string|string>: <optional>)` - A key-value map of strings
        passed directly to the plugin to configure the volume. The details of these
        parameters are specific to the plugin.


        [`access_mode`]: /nomad/docs/other-specifications/volume/capability#access_mode
        [`attachment_mode`]: /nomad/docs/other-specifications/volume/capability#attachment_mode
        [volume_source]: /nomad/docs/job-specification/volume#source
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class _DynamicHostVolumeRegistrationState:
    def __init__(__self__, *,
                 capabilities: Optional[pulumi.Input[Sequence[pulumi.Input['DynamicHostVolumeRegistrationCapabilityArgs']]]] = None,
                 capacity: Optional[pulumi.Input[builtins.str]] = None,
                 capacity_bytes: Optional[pulumi.Input[builtins.int]] = None,
                 capacity_max_bytes: Optional[pulumi.Input[builtins.int]] = None,
                 capacity_min_bytes: Optional[pulumi.Input[builtins.int]] = None,
                 constraints: Optional[pulumi.Input[Sequence[pulumi.Input['DynamicHostVolumeRegistrationConstraintArgs']]]] = None,
                 host_path: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 namespace: Optional[pulumi.Input[builtins.str]] = None,
                 node_id: Optional[pulumi.Input[builtins.str]] = None,
                 node_pool: Optional[pulumi.Input[builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 plugin_id: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering DynamicHostVolumeRegistration resources.
        :param pulumi.Input[Sequence[pulumi.Input['DynamicHostVolumeRegistrationCapabilityArgs']]] capabilities: `(block: <optional>)` - Option for validating the capability of a
               volume. Each capability block has the following attributes:
        :param pulumi.Input[builtins.str] capacity: `(string: <optional>)` - The size of a volume in bytes. Either the
               physical size of a disk or a quota, depending on the plugin. This field must
               be between the `capacity_min` and `capacity_max` values unless they are
               omitted. Accepts human-friendly suffixes such as `"100GiB"`.
        :param pulumi.Input[Sequence[pulumi.Input['DynamicHostVolumeRegistrationConstraintArgs']]] constraints: Constraints
        :param pulumi.Input[builtins.str] host_path: `(string)` - The path on disk where the volume exists.
        :param pulumi.Input[builtins.str] name: `(string: <required>)` - The name of the volume, which is used as the
               [`volume.source`][volume_source] field in job specifications that claim this
               volume. Host volume names must be unique per node. Names are visible to any
               user with `node:read` ACL, even across namespaces, so they should not be
               treated as sensitive values.
        :param pulumi.Input[builtins.str] namespace: `(string: <optional>)` - The namespace of the volume. This field
               overrides the namespace provided by the `-namespace` flag or `NOMAD_NAMESPACE`
               environment variable. Defaults to `"default"` if unset.
        :param pulumi.Input[builtins.str] node_id: `(string: <required>)` - A specific node where the volume is
               mounted.
        :param pulumi.Input[builtins.str] node_pool: Node pool
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] parameters: `(map<string|string>: <optional>)` - A key-value map of strings
               passed directly to the plugin to configure the volume. The details of these
               parameters are specific to the plugin.
               
               
               [`access_mode`]: /nomad/docs/other-specifications/volume/capability#access_mode
               [`attachment_mode`]: /nomad/docs/other-specifications/volume/capability#attachment_mode
               [volume_source]: /nomad/docs/job-specification/volume#source
        :param pulumi.Input[builtins.str] plugin_id: Plugin ID
        :param pulumi.Input[builtins.str] state: State
        """
        if capabilities is not None:
            pulumi.set(__self__, "capabilities", capabilities)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if capacity_bytes is not None:
            pulumi.set(__self__, "capacity_bytes", capacity_bytes)
        if capacity_max_bytes is not None:
            pulumi.set(__self__, "capacity_max_bytes", capacity_max_bytes)
        if capacity_min_bytes is not None:
            pulumi.set(__self__, "capacity_min_bytes", capacity_min_bytes)
        if constraints is not None:
            pulumi.set(__self__, "constraints", constraints)
        if host_path is not None:
            pulumi.set(__self__, "host_path", host_path)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if node_id is not None:
            pulumi.set(__self__, "node_id", node_id)
        if node_pool is not None:
            pulumi.set(__self__, "node_pool", node_pool)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if plugin_id is not None:
            pulumi.set(__self__, "plugin_id", plugin_id)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def capabilities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DynamicHostVolumeRegistrationCapabilityArgs']]]]:
        """
        `(block: <optional>)` - Option for validating the capability of a
        volume. Each capability block has the following attributes:
        """
        return pulumi.get(self, "capabilities")

    @capabilities.setter
    def capabilities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DynamicHostVolumeRegistrationCapabilityArgs']]]]):
        pulumi.set(self, "capabilities", value)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `(string: <optional>)` - The size of a volume in bytes. Either the
        physical size of a disk or a quota, depending on the plugin. This field must
        be between the `capacity_min` and `capacity_max` values unless they are
        omitted. Accepts human-friendly suffixes such as `"100GiB"`.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter(name="capacityBytes")
    def capacity_bytes(self) -> Optional[pulumi.Input[builtins.int]]:
        return pulumi.get(self, "capacity_bytes")

    @capacity_bytes.setter
    def capacity_bytes(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "capacity_bytes", value)

    @property
    @pulumi.getter(name="capacityMaxBytes")
    def capacity_max_bytes(self) -> Optional[pulumi.Input[builtins.int]]:
        return pulumi.get(self, "capacity_max_bytes")

    @capacity_max_bytes.setter
    def capacity_max_bytes(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "capacity_max_bytes", value)

    @property
    @pulumi.getter(name="capacityMinBytes")
    def capacity_min_bytes(self) -> Optional[pulumi.Input[builtins.int]]:
        return pulumi.get(self, "capacity_min_bytes")

    @capacity_min_bytes.setter
    def capacity_min_bytes(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "capacity_min_bytes", value)

    @property
    @pulumi.getter
    def constraints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DynamicHostVolumeRegistrationConstraintArgs']]]]:
        """
        Constraints
        """
        return pulumi.get(self, "constraints")

    @constraints.setter
    def constraints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DynamicHostVolumeRegistrationConstraintArgs']]]]):
        pulumi.set(self, "constraints", value)

    @property
    @pulumi.getter(name="hostPath")
    def host_path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `(string)` - The path on disk where the volume exists.
        """
        return pulumi.get(self, "host_path")

    @host_path.setter
    def host_path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "host_path", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `(string: <required>)` - The name of the volume, which is used as the
        [`volume.source`][volume_source] field in job specifications that claim this
        volume. Host volume names must be unique per node. Names are visible to any
        user with `node:read` ACL, even across namespaces, so they should not be
        treated as sensitive values.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `(string: <optional>)` - The namespace of the volume. This field
        overrides the namespace provided by the `-namespace` flag or `NOMAD_NAMESPACE`
        environment variable. Defaults to `"default"` if unset.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `(string: <required>)` - A specific node where the volume is
        mounted.
        """
        return pulumi.get(self, "node_id")

    @node_id.setter
    def node_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "node_id", value)

    @property
    @pulumi.getter(name="nodePool")
    def node_pool(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Node pool
        """
        return pulumi.get(self, "node_pool")

    @node_pool.setter
    def node_pool(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "node_pool", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        `(map<string|string>: <optional>)` - A key-value map of strings
        passed directly to the plugin to configure the volume. The details of these
        parameters are specific to the plugin.


        [`access_mode`]: /nomad/docs/other-specifications/volume/capability#access_mode
        [`attachment_mode`]: /nomad/docs/other-specifications/volume/capability#attachment_mode
        [volume_source]: /nomad/docs/job-specification/volume#source
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="pluginId")
    def plugin_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Plugin ID
        """
        return pulumi.get(self, "plugin_id")

    @plugin_id.setter
    def plugin_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "plugin_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        State
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)


@pulumi.type_token("nomad:index/dynamicHostVolumeRegistration:DynamicHostVolumeRegistration")
class DynamicHostVolumeRegistration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DynamicHostVolumeRegistrationCapabilityArgs', 'DynamicHostVolumeRegistrationCapabilityArgsDict']]]]] = None,
                 capacity: Optional[pulumi.Input[builtins.str]] = None,
                 host_path: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 namespace: Optional[pulumi.Input[builtins.str]] = None,
                 node_id: Optional[pulumi.Input[builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Registers a dynamic host volume in Nomad that has already been created. Note
        that Nomad supports two workflows for dynamic host volumes: create and
        register. Both resources result in the same data source with the same outputs.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DynamicHostVolumeRegistrationCapabilityArgs', 'DynamicHostVolumeRegistrationCapabilityArgsDict']]]] capabilities: `(block: <optional>)` - Option for validating the capability of a
               volume. Each capability block has the following attributes:
        :param pulumi.Input[builtins.str] capacity: `(string: <optional>)` - The size of a volume in bytes. Either the
               physical size of a disk or a quota, depending on the plugin. This field must
               be between the `capacity_min` and `capacity_max` values unless they are
               omitted. Accepts human-friendly suffixes such as `"100GiB"`.
        :param pulumi.Input[builtins.str] host_path: `(string)` - The path on disk where the volume exists.
        :param pulumi.Input[builtins.str] name: `(string: <required>)` - The name of the volume, which is used as the
               [`volume.source`][volume_source] field in job specifications that claim this
               volume. Host volume names must be unique per node. Names are visible to any
               user with `node:read` ACL, even across namespaces, so they should not be
               treated as sensitive values.
        :param pulumi.Input[builtins.str] namespace: `(string: <optional>)` - The namespace of the volume. This field
               overrides the namespace provided by the `-namespace` flag or `NOMAD_NAMESPACE`
               environment variable. Defaults to `"default"` if unset.
        :param pulumi.Input[builtins.str] node_id: `(string: <required>)` - A specific node where the volume is
               mounted.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] parameters: `(map<string|string>: <optional>)` - A key-value map of strings
               passed directly to the plugin to configure the volume. The details of these
               parameters are specific to the plugin.
               
               
               [`access_mode`]: /nomad/docs/other-specifications/volume/capability#access_mode
               [`attachment_mode`]: /nomad/docs/other-specifications/volume/capability#attachment_mode
               [volume_source]: /nomad/docs/job-specification/volume#source
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DynamicHostVolumeRegistrationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Registers a dynamic host volume in Nomad that has already been created. Note
        that Nomad supports two workflows for dynamic host volumes: create and
        register. Both resources result in the same data source with the same outputs.

        :param str resource_name: The name of the resource.
        :param DynamicHostVolumeRegistrationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DynamicHostVolumeRegistrationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DynamicHostVolumeRegistrationCapabilityArgs', 'DynamicHostVolumeRegistrationCapabilityArgsDict']]]]] = None,
                 capacity: Optional[pulumi.Input[builtins.str]] = None,
                 host_path: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 namespace: Optional[pulumi.Input[builtins.str]] = None,
                 node_id: Optional[pulumi.Input[builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DynamicHostVolumeRegistrationArgs.__new__(DynamicHostVolumeRegistrationArgs)

            if capabilities is None and not opts.urn:
                raise TypeError("Missing required property 'capabilities'")
            __props__.__dict__["capabilities"] = capabilities
            __props__.__dict__["capacity"] = capacity
            if host_path is None and not opts.urn:
                raise TypeError("Missing required property 'host_path'")
            __props__.__dict__["host_path"] = host_path
            __props__.__dict__["name"] = name
            __props__.__dict__["namespace"] = namespace
            if node_id is None and not opts.urn:
                raise TypeError("Missing required property 'node_id'")
            __props__.__dict__["node_id"] = node_id
            __props__.__dict__["parameters"] = parameters
            __props__.__dict__["capacity_bytes"] = None
            __props__.__dict__["capacity_max_bytes"] = None
            __props__.__dict__["capacity_min_bytes"] = None
            __props__.__dict__["constraints"] = None
            __props__.__dict__["node_pool"] = None
            __props__.__dict__["plugin_id"] = None
            __props__.__dict__["state"] = None
        super(DynamicHostVolumeRegistration, __self__).__init__(
            'nomad:index/dynamicHostVolumeRegistration:DynamicHostVolumeRegistration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DynamicHostVolumeRegistrationCapabilityArgs', 'DynamicHostVolumeRegistrationCapabilityArgsDict']]]]] = None,
            capacity: Optional[pulumi.Input[builtins.str]] = None,
            capacity_bytes: Optional[pulumi.Input[builtins.int]] = None,
            capacity_max_bytes: Optional[pulumi.Input[builtins.int]] = None,
            capacity_min_bytes: Optional[pulumi.Input[builtins.int]] = None,
            constraints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DynamicHostVolumeRegistrationConstraintArgs', 'DynamicHostVolumeRegistrationConstraintArgsDict']]]]] = None,
            host_path: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            namespace: Optional[pulumi.Input[builtins.str]] = None,
            node_id: Optional[pulumi.Input[builtins.str]] = None,
            node_pool: Optional[pulumi.Input[builtins.str]] = None,
            parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            plugin_id: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None) -> 'DynamicHostVolumeRegistration':
        """
        Get an existing DynamicHostVolumeRegistration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DynamicHostVolumeRegistrationCapabilityArgs', 'DynamicHostVolumeRegistrationCapabilityArgsDict']]]] capabilities: `(block: <optional>)` - Option for validating the capability of a
               volume. Each capability block has the following attributes:
        :param pulumi.Input[builtins.str] capacity: `(string: <optional>)` - The size of a volume in bytes. Either the
               physical size of a disk or a quota, depending on the plugin. This field must
               be between the `capacity_min` and `capacity_max` values unless they are
               omitted. Accepts human-friendly suffixes such as `"100GiB"`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DynamicHostVolumeRegistrationConstraintArgs', 'DynamicHostVolumeRegistrationConstraintArgsDict']]]] constraints: Constraints
        :param pulumi.Input[builtins.str] host_path: `(string)` - The path on disk where the volume exists.
        :param pulumi.Input[builtins.str] name: `(string: <required>)` - The name of the volume, which is used as the
               [`volume.source`][volume_source] field in job specifications that claim this
               volume. Host volume names must be unique per node. Names are visible to any
               user with `node:read` ACL, even across namespaces, so they should not be
               treated as sensitive values.
        :param pulumi.Input[builtins.str] namespace: `(string: <optional>)` - The namespace of the volume. This field
               overrides the namespace provided by the `-namespace` flag or `NOMAD_NAMESPACE`
               environment variable. Defaults to `"default"` if unset.
        :param pulumi.Input[builtins.str] node_id: `(string: <required>)` - A specific node where the volume is
               mounted.
        :param pulumi.Input[builtins.str] node_pool: Node pool
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] parameters: `(map<string|string>: <optional>)` - A key-value map of strings
               passed directly to the plugin to configure the volume. The details of these
               parameters are specific to the plugin.
               
               
               [`access_mode`]: /nomad/docs/other-specifications/volume/capability#access_mode
               [`attachment_mode`]: /nomad/docs/other-specifications/volume/capability#attachment_mode
               [volume_source]: /nomad/docs/job-specification/volume#source
        :param pulumi.Input[builtins.str] plugin_id: Plugin ID
        :param pulumi.Input[builtins.str] state: State
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DynamicHostVolumeRegistrationState.__new__(_DynamicHostVolumeRegistrationState)

        __props__.__dict__["capabilities"] = capabilities
        __props__.__dict__["capacity"] = capacity
        __props__.__dict__["capacity_bytes"] = capacity_bytes
        __props__.__dict__["capacity_max_bytes"] = capacity_max_bytes
        __props__.__dict__["capacity_min_bytes"] = capacity_min_bytes
        __props__.__dict__["constraints"] = constraints
        __props__.__dict__["host_path"] = host_path
        __props__.__dict__["name"] = name
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["node_id"] = node_id
        __props__.__dict__["node_pool"] = node_pool
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["plugin_id"] = plugin_id
        __props__.__dict__["state"] = state
        return DynamicHostVolumeRegistration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def capabilities(self) -> pulumi.Output[Sequence['outputs.DynamicHostVolumeRegistrationCapability']]:
        """
        `(block: <optional>)` - Option for validating the capability of a
        volume. Each capability block has the following attributes:
        """
        return pulumi.get(self, "capabilities")

    @property
    @pulumi.getter
    def capacity(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        `(string: <optional>)` - The size of a volume in bytes. Either the
        physical size of a disk or a quota, depending on the plugin. This field must
        be between the `capacity_min` and `capacity_max` values unless they are
        omitted. Accepts human-friendly suffixes such as `"100GiB"`.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter(name="capacityBytes")
    def capacity_bytes(self) -> pulumi.Output[builtins.int]:
        return pulumi.get(self, "capacity_bytes")

    @property
    @pulumi.getter(name="capacityMaxBytes")
    def capacity_max_bytes(self) -> pulumi.Output[builtins.int]:
        return pulumi.get(self, "capacity_max_bytes")

    @property
    @pulumi.getter(name="capacityMinBytes")
    def capacity_min_bytes(self) -> pulumi.Output[builtins.int]:
        return pulumi.get(self, "capacity_min_bytes")

    @property
    @pulumi.getter
    def constraints(self) -> pulumi.Output[Sequence['outputs.DynamicHostVolumeRegistrationConstraint']]:
        """
        Constraints
        """
        return pulumi.get(self, "constraints")

    @property
    @pulumi.getter(name="hostPath")
    def host_path(self) -> pulumi.Output[builtins.str]:
        """
        `(string)` - The path on disk where the volume exists.
        """
        return pulumi.get(self, "host_path")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        `(string: <required>)` - The name of the volume, which is used as the
        [`volume.source`][volume_source] field in job specifications that claim this
        volume. Host volume names must be unique per node. Names are visible to any
        user with `node:read` ACL, even across namespaces, so they should not be
        treated as sensitive values.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        `(string: <optional>)` - The namespace of the volume. This field
        overrides the namespace provided by the `-namespace` flag or `NOMAD_NAMESPACE`
        environment variable. Defaults to `"default"` if unset.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> pulumi.Output[builtins.str]:
        """
        `(string: <required>)` - A specific node where the volume is
        mounted.
        """
        return pulumi.get(self, "node_id")

    @property
    @pulumi.getter(name="nodePool")
    def node_pool(self) -> pulumi.Output[builtins.str]:
        """
        Node pool
        """
        return pulumi.get(self, "node_pool")

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        `(map<string|string>: <optional>)` - A key-value map of strings
        passed directly to the plugin to configure the volume. The details of these
        parameters are specific to the plugin.


        [`access_mode`]: /nomad/docs/other-specifications/volume/capability#access_mode
        [`attachment_mode`]: /nomad/docs/other-specifications/volume/capability#attachment_mode
        [volume_source]: /nomad/docs/job-specification/volume#source
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="pluginId")
    def plugin_id(self) -> pulumi.Output[builtins.str]:
        """
        Plugin ID
        """
        return pulumi.get(self, "plugin_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        State
        """
        return pulumi.get(self, "state")

