# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetDynamicHostVolumeResult',
    'AwaitableGetDynamicHostVolumeResult',
    'get_dynamic_host_volume',
    'get_dynamic_host_volume_output',
]

@pulumi.output_type
class GetDynamicHostVolumeResult:
    """
    A collection of values returned by getDynamicHostVolume.
    """
    def __init__(__self__, capabilities=None, capacity=None, capacity_bytes=None, capacity_max=None, capacity_max_bytes=None, capacity_min=None, capacity_min_bytes=None, constraints=None, host_path=None, id=None, name=None, namespace=None, node_id=None, node_pool=None, parameters=None, plugin_id=None, state=None):
        if capabilities and not isinstance(capabilities, list):
            raise TypeError("Expected argument 'capabilities' to be a list")
        pulumi.set(__self__, "capabilities", capabilities)
        if capacity and not isinstance(capacity, str):
            raise TypeError("Expected argument 'capacity' to be a str")
        pulumi.set(__self__, "capacity", capacity)
        if capacity_bytes and not isinstance(capacity_bytes, int):
            raise TypeError("Expected argument 'capacity_bytes' to be a int")
        pulumi.set(__self__, "capacity_bytes", capacity_bytes)
        if capacity_max and not isinstance(capacity_max, str):
            raise TypeError("Expected argument 'capacity_max' to be a str")
        pulumi.set(__self__, "capacity_max", capacity_max)
        if capacity_max_bytes and not isinstance(capacity_max_bytes, int):
            raise TypeError("Expected argument 'capacity_max_bytes' to be a int")
        pulumi.set(__self__, "capacity_max_bytes", capacity_max_bytes)
        if capacity_min and not isinstance(capacity_min, str):
            raise TypeError("Expected argument 'capacity_min' to be a str")
        pulumi.set(__self__, "capacity_min", capacity_min)
        if capacity_min_bytes and not isinstance(capacity_min_bytes, int):
            raise TypeError("Expected argument 'capacity_min_bytes' to be a int")
        pulumi.set(__self__, "capacity_min_bytes", capacity_min_bytes)
        if constraints and not isinstance(constraints, list):
            raise TypeError("Expected argument 'constraints' to be a list")
        pulumi.set(__self__, "constraints", constraints)
        if host_path and not isinstance(host_path, str):
            raise TypeError("Expected argument 'host_path' to be a str")
        pulumi.set(__self__, "host_path", host_path)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)
        if node_id and not isinstance(node_id, str):
            raise TypeError("Expected argument 'node_id' to be a str")
        pulumi.set(__self__, "node_id", node_id)
        if node_pool and not isinstance(node_pool, str):
            raise TypeError("Expected argument 'node_pool' to be a str")
        pulumi.set(__self__, "node_pool", node_pool)
        if parameters and not isinstance(parameters, dict):
            raise TypeError("Expected argument 'parameters' to be a dict")
        pulumi.set(__self__, "parameters", parameters)
        if plugin_id and not isinstance(plugin_id, str):
            raise TypeError("Expected argument 'plugin_id' to be a str")
        pulumi.set(__self__, "plugin_id", plugin_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def capabilities(self) -> Sequence['outputs.GetDynamicHostVolumeCapabilityResult']:
        """
        `(block)` - Option for validating the capability of a
        volume. Each capability block has the following attributes:
        """
        return pulumi.get(self, "capabilities")

    @property
    @pulumi.getter
    def capacity(self) -> builtins.str:
        """
        `(string)` - The size of the volume, in human-friendly format
        (ex. 10 GiB)
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter(name="capacityBytes")
    def capacity_bytes(self) -> builtins.int:
        """
        `(int)` - The size of the volume, in bytes.
        """
        return pulumi.get(self, "capacity_bytes")

    @property
    @pulumi.getter(name="capacityMax")
    def capacity_max(self) -> builtins.str:
        """
        `(string)` - The requested maximum capacity of the volume, in
        human-friendly format (ex. 10 GiB).
        """
        return pulumi.get(self, "capacity_max")

    @property
    @pulumi.getter(name="capacityMaxBytes")
    def capacity_max_bytes(self) -> builtins.int:
        """
        `(string)` - The requested maximum capacity of the
        volume, in bytes.
        """
        return pulumi.get(self, "capacity_max_bytes")

    @property
    @pulumi.getter(name="capacityMin")
    def capacity_min(self) -> builtins.str:
        """
        `(string)` - The requested minimum capacity of the volume, in
        human-friendly format (ex. 10 GiB).
        """
        return pulumi.get(self, "capacity_min")

    @property
    @pulumi.getter(name="capacityMinBytes")
    def capacity_min_bytes(self) -> builtins.int:
        """
        `(string)` - The requested minimum capacity of the
        volume, in bytes.
        """
        return pulumi.get(self, "capacity_min_bytes")

    @property
    @pulumi.getter
    def constraints(self) -> Sequence['outputs.GetDynamicHostVolumeConstraintResult']:
        """
        `(block)` - The restrictions used to place the volume on a node,
        similar to the [`constraint`][] block on a Nomad job specification. A volume
        may have multiple `constraint` blocks. Each constraint block has the following
        attributes.
        """
        return pulumi.get(self, "constraints")

    @property
    @pulumi.getter(name="hostPath")
    def host_path(self) -> builtins.str:
        """
        `(string)` - The path on disk where the volume exists.
        """
        return pulumi.get(self, "host_path")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        `(string)` - The name of the volume, which is used as the
        [`volume.source`][volume_source] field in job specifications that claim this
        volume. Host volume names are be unique per node. Names are visible to any
        user with `node:read` ACL, even across namespaces, so they should not be
        treated as sensitive values.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[builtins.str]:
        """
        `(string)` - The namespace of the volume.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> builtins.str:
        """
        `(string)` - A specific node where the volume is mounted.
        """
        return pulumi.get(self, "node_id")

    @property
    @pulumi.getter(name="nodePool")
    def node_pool(self) -> builtins.str:
        """
        `(string: <optional>)` - The node pool of the node where the
        volume is mounted.
        """
        return pulumi.get(self, "node_pool")

    @property
    @pulumi.getter
    def parameters(self) -> Mapping[str, builtins.str]:
        """
        `(map<string|string>)` - A key-value map of strings
        passed directly to the plugin to configure the volume. The details of these
        parameters are specific to the plugin.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="pluginId")
    def plugin_id(self) -> builtins.str:
        """
        `(string: <required>)` - The ID of the [dynamic host volume
        plugin][dhv_plugin] that manages this volume.
        """
        return pulumi.get(self, "plugin_id")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        return pulumi.get(self, "state")


class AwaitableGetDynamicHostVolumeResult(GetDynamicHostVolumeResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDynamicHostVolumeResult(
            capabilities=self.capabilities,
            capacity=self.capacity,
            capacity_bytes=self.capacity_bytes,
            capacity_max=self.capacity_max,
            capacity_max_bytes=self.capacity_max_bytes,
            capacity_min=self.capacity_min,
            capacity_min_bytes=self.capacity_min_bytes,
            constraints=self.constraints,
            host_path=self.host_path,
            id=self.id,
            name=self.name,
            namespace=self.namespace,
            node_id=self.node_id,
            node_pool=self.node_pool,
            parameters=self.parameters,
            plugin_id=self.plugin_id,
            state=self.state)


def get_dynamic_host_volume(id: Optional[builtins.str] = None,
                            namespace: Optional[builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDynamicHostVolumeResult:
    """
    Get information on a dynamic host volume from Nomad.

    ## Example Usage

    Check for the existing of a host volume:

    ```python
    import pulumi
    import pulumi_nomad as nomad

    example = nomad.get_dynamic_host_volume(namespace="prod",
        id="d688ff7a-d299-11ef-ae3c-6f2400953c18")
    ```

    This will check for a dynamic host volume with the ID
    `d688ff7a-d299-11ef-ae3c-6f2400953c18`.


    :param builtins.str id: `(string)` - the ID of the volume
    :param builtins.str namespace: `(string)` - the namespace of the volume. Defaults to `"default"`
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['namespace'] = namespace
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nomad:index/getDynamicHostVolume:getDynamicHostVolume', __args__, opts=opts, typ=GetDynamicHostVolumeResult).value

    return AwaitableGetDynamicHostVolumeResult(
        capabilities=pulumi.get(__ret__, 'capabilities'),
        capacity=pulumi.get(__ret__, 'capacity'),
        capacity_bytes=pulumi.get(__ret__, 'capacity_bytes'),
        capacity_max=pulumi.get(__ret__, 'capacity_max'),
        capacity_max_bytes=pulumi.get(__ret__, 'capacity_max_bytes'),
        capacity_min=pulumi.get(__ret__, 'capacity_min'),
        capacity_min_bytes=pulumi.get(__ret__, 'capacity_min_bytes'),
        constraints=pulumi.get(__ret__, 'constraints'),
        host_path=pulumi.get(__ret__, 'host_path'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        namespace=pulumi.get(__ret__, 'namespace'),
        node_id=pulumi.get(__ret__, 'node_id'),
        node_pool=pulumi.get(__ret__, 'node_pool'),
        parameters=pulumi.get(__ret__, 'parameters'),
        plugin_id=pulumi.get(__ret__, 'plugin_id'),
        state=pulumi.get(__ret__, 'state'))
def get_dynamic_host_volume_output(id: Optional[pulumi.Input[builtins.str]] = None,
                                   namespace: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDynamicHostVolumeResult]:
    """
    Get information on a dynamic host volume from Nomad.

    ## Example Usage

    Check for the existing of a host volume:

    ```python
    import pulumi
    import pulumi_nomad as nomad

    example = nomad.get_dynamic_host_volume(namespace="prod",
        id="d688ff7a-d299-11ef-ae3c-6f2400953c18")
    ```

    This will check for a dynamic host volume with the ID
    `d688ff7a-d299-11ef-ae3c-6f2400953c18`.


    :param builtins.str id: `(string)` - the ID of the volume
    :param builtins.str namespace: `(string)` - the namespace of the volume. Defaults to `"default"`
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['namespace'] = namespace
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nomad:index/getDynamicHostVolume:getDynamicHostVolume', __args__, opts=opts, typ=GetDynamicHostVolumeResult)
    return __ret__.apply(lambda __response__: GetDynamicHostVolumeResult(
        capabilities=pulumi.get(__response__, 'capabilities'),
        capacity=pulumi.get(__response__, 'capacity'),
        capacity_bytes=pulumi.get(__response__, 'capacity_bytes'),
        capacity_max=pulumi.get(__response__, 'capacity_max'),
        capacity_max_bytes=pulumi.get(__response__, 'capacity_max_bytes'),
        capacity_min=pulumi.get(__response__, 'capacity_min'),
        capacity_min_bytes=pulumi.get(__response__, 'capacity_min_bytes'),
        constraints=pulumi.get(__response__, 'constraints'),
        host_path=pulumi.get(__response__, 'host_path'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        namespace=pulumi.get(__response__, 'namespace'),
        node_id=pulumi.get(__response__, 'node_id'),
        node_pool=pulumi.get(__response__, 'node_pool'),
        parameters=pulumi.get(__response__, 'parameters'),
        plugin_id=pulumi.get(__response__, 'plugin_id'),
        state=pulumi.get(__response__, 'state')))
