# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetOrganizationRepositoryRoleResult',
    'AwaitableGetOrganizationRepositoryRoleResult',
    'get_organization_repository_role',
    'get_organization_repository_role_output',
]

@pulumi.output_type
class GetOrganizationRepositoryRoleResult:
    """
    A collection of values returned by getOrganizationRepositoryRole.
    """
    def __init__(__self__, base_role=None, description=None, id=None, name=None, permissions=None, role_id=None):
        if base_role and not isinstance(base_role, str):
            raise TypeError("Expected argument 'base_role' to be a str")
        pulumi.set(__self__, "base_role", base_role)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if permissions and not isinstance(permissions, list):
            raise TypeError("Expected argument 'permissions' to be a list")
        pulumi.set(__self__, "permissions", permissions)
        if role_id and not isinstance(role_id, int):
            raise TypeError("Expected argument 'role_id' to be a int")
        pulumi.set(__self__, "role_id", role_id)

    @_builtins.property
    @pulumi.getter(name="baseRole")
    def base_role(self) -> _builtins.str:
        """
        The system role from which this role inherits permissions.
        """
        return pulumi.get(self, "base_role")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the organization repository role.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the organization repository role.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> Sequence[_builtins.str]:
        """
        The permissions included in this role.
        """
        return pulumi.get(self, "permissions")

    @_builtins.property
    @pulumi.getter(name="roleId")
    def role_id(self) -> _builtins.int:
        """
        The ID of the organization repository role.
        """
        return pulumi.get(self, "role_id")


class AwaitableGetOrganizationRepositoryRoleResult(GetOrganizationRepositoryRoleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOrganizationRepositoryRoleResult(
            base_role=self.base_role,
            description=self.description,
            id=self.id,
            name=self.name,
            permissions=self.permissions,
            role_id=self.role_id)


def get_organization_repository_role(role_id: Optional[_builtins.int] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOrganizationRepositoryRoleResult:
    """
    Lookup a custom organization repository role.

    > **Note**: Custom organization repository roles are currently only available in GitHub Enterprise Cloud.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_github as github

    example = github.get_organization_repository_role(role_id=1234)
    ```


    :param _builtins.int role_id: The ID of the organization repository role.
    """
    __args__ = dict()
    __args__['roleId'] = role_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('github:index/getOrganizationRepositoryRole:getOrganizationRepositoryRole', __args__, opts=opts, typ=GetOrganizationRepositoryRoleResult).value

    return AwaitableGetOrganizationRepositoryRoleResult(
        base_role=pulumi.get(__ret__, 'base_role'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        permissions=pulumi.get(__ret__, 'permissions'),
        role_id=pulumi.get(__ret__, 'role_id'))
def get_organization_repository_role_output(role_id: Optional[pulumi.Input[_builtins.int]] = None,
                                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetOrganizationRepositoryRoleResult]:
    """
    Lookup a custom organization repository role.

    > **Note**: Custom organization repository roles are currently only available in GitHub Enterprise Cloud.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_github as github

    example = github.get_organization_repository_role(role_id=1234)
    ```


    :param _builtins.int role_id: The ID of the organization repository role.
    """
    __args__ = dict()
    __args__['roleId'] = role_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('github:index/getOrganizationRepositoryRole:getOrganizationRepositoryRole', __args__, opts=opts, typ=GetOrganizationRepositoryRoleResult)
    return __ret__.apply(lambda __response__: GetOrganizationRepositoryRoleResult(
        base_role=pulumi.get(__response__, 'base_role'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        permissions=pulumi.get(__response__, 'permissions'),
        role_id=pulumi.get(__response__, 'role_id')))
