"""Setup configuration for synq Python SDK."""

from setuptools import setup, find_packages
from pathlib import Path

# Read the contents of README
this_directory = Path(__file__).parent
long_description = (this_directory / "README.md").read_text(encoding="utf-8")

setup(
    name="synq-ai",
    version="0.3.0",
    author="Synq Team",
    author_email="support@synq.dev",
    description="Python SDK for Synq - Multi-Agent AI Interaction System",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/yourusername/synq",
    packages=find_packages(where="python"),
    package_dir={"": "python"},
    classifiers=[
        "Development Status :: 3 - Alpha",
        "Intended Audience :: Developers",
        "Topic :: Software Development :: Libraries :: Python Modules",
        "Topic :: Scientific/Engineering :: Artificial Intelligence",
        "License :: Other/Proprietary License",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
        "Programming Language :: Python :: 3.12",
    ],
    python_requires=">=3.8",
    install_requires=[
        "requests>=2.31.0",
        "typing-extensions>=4.0.0",
    ],
    extras_require={
        "dev": [
            "pytest>=7.0.0",
            "pytest-cov>=4.0.0",
            "black>=23.0.0",
            "flake8>=6.0.0",
            "mypy>=1.0.0",
        ],
    },
    keywords="ai agents multi-agent openai gpt chatbot simulation",
    project_urls={
        "Bug Reports": "https://github.com/yourusername/synq/issues",
        "Source": "https://github.com/yourusername/synq",
        "Documentation": "https://github.com/yourusername/synq#readme",
    },
)

