"""
OSDU Performance Tests - Locust Configuration
Generated by OSDU Performance Testing Framework

# Simple API-based performance testing for t service
"""

import os
from locust import events, task, tag
from osdu_perf import PerformanceUser


# STEP 1: Register custom CLI args with Locust
# Please dont remove this code as it is required for OSDU parameters.
@events.init_command_line_parser.add_listener
def add_custom_args(parser):
    """Add OSDU-specific command line arguments"""
    parser.add_argument("--partition", type=str, default=os.getenv("PARTITION"), help="OSDU Data Partition ID")
    # Note: --host is provided by Locust built-in, no need to add it here
    # Note: --token is not exposed as CLI arg for security, only via environment variable
    parser.add_argument("--appid", type=str, default=os.getenv("APPID"), help="Azure AD Application ID")


class OSDUUser(PerformanceUser):
    """
    OSDU Performance Test User
    
    This class automatically:
    - Handles Azure authentication and token management
    - Manages HTTP headers and request setup
    - Provides simple API methods (get, post, put, delete)
    - Manages Locust user simulation and load testing
    
    Usage:
        locust -f locustfile.py --host https://your-api.com --partition your-partition --appid your-app-id
    """
    
    # Optional: Customize user behavior
    # Default `wait_time` is provided by `PerformanceUser` (between(1, 3)).
    # To override in the generated file, uncomment and import `between` from locust:
    # from locust import between
    # wait_time = between(1, 3)  # realistic pacing (recommended)
    # wait_time = between(0, 0)  # no wait (maximum load)
    
    def on_start(self):
        """Called when a user starts - performs setup"""
        super().on_start()

        # Access OSDU parameters from Locust parsed options or environment variables.
        # The available APIs are detailed in the README and library documentation.
        # This code generation accelerates development by removing the need to manually refer to the library docs.
        # locust client is available as self.client. Also have self.get, self.put, self.post wrapper API to use
        # One time setup can be performed here.
        # each other load function must have task decorator.
        # token is supplied via environment variable which is not passed to azure load test. 

        self.partition = self.get_partition()
        self.host = self.get_host()
        self.headers = self.get_headers()
        self.appid = self.get_appid()
        self.logger = self.get_logger()

        self.logger.info(f"🚀 Started performance testing user")
        self.logger.info(f"   📍 Partition: {self.partition}")
        self.logger.info(f"   🌐 Host: {self.host}")
        self.logger.info(f"   🆔 App ID: {self.appid or 'Not provided'}")

    def on_stop(self):
        """Called when a user stops - performs cleanup"""
        self.logger.info("🛑 Stopped performance testing user")

    
    @tag("test")
    @task(1)
    def check_service_health(self):
        # *** Simple and clean consumer call ***
        self.get("/api/test/v2/liveness_check")

