# mypy-boto3-mediaconvert

[![PyPI - mypy-boto3-mediaconvert](https://img.shields.io/pypi/v/mypy-boto3-mediaconvert.svg?color=blue)](https://pypi.org/project/mypy-boto3-mediaconvert)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-mediaconvert.svg?color=blue)](https://pypi.org/project/mypy-boto3-mediaconvert)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.MediaConvert 1.14.58](https://boto3.amazonaws.com/v1/documentation/api/1.14.58/reference/services/mediaconvert.html#MediaConvert) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 3.0.4](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-mediaconvert](#mypy-boto3-mediaconvert)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `MediaConvert` service.

```bash
python -m pip install boto3-stubs[mediaconvert]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[mediaconvert]` in your environment: `python -m pip install 'boto3-stubs[mediaconvert]'`

Both type checking and auto-complete should work for `MediaConvert` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[mediaconvert]` in your environment: `python -m pip install 'boto3-stubs[mediaconvert]'`

Both type checking and auto-complete should work for `MediaConvert` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[mediaconvert]` in your environment: `python -m pip install 'boto3-stubs[mediaconvert]'`
- Run `mypy` as usual

Type checking should work for `MediaConvert` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[mediaconvert]` in your environment: `python -m pip install 'boto3-stubs[mediaconvert]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `MediaConvert` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`MediaConvertClient` provides annotations for `boto3.client("mediaconvert")`.

```python
import boto3

from mypy_boto3_mediaconvert import MediaConvertClient

client: MediaConvertClient = boto3.client("mediaconvert")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: MediaConvertClient = session.client("mediaconvert")
```

### Paginators annotations

`mypy_boto3_mediaconvert.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_mediaconvert import MediaConvertClient
from mypy_boto3_mediaconvert.paginator import (
    DescribeEndpointsPaginator,
    ListJobsPaginator,
    ListJobTemplatesPaginator,
    ListPresetsPaginator,
    ListQueuesPaginator,
)

client: MediaConvertClient = boto3.client("mediaconvert")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
describe_endpoints_paginator: DescribeEndpointsPaginator = client.get_paginator("describe_endpoints")
list_job_templates_paginator: ListJobTemplatesPaginator = client.get_paginator("list_job_templates")
list_jobs_paginator: ListJobsPaginator = client.get_paginator("list_jobs")
list_presets_paginator: ListPresetsPaginator = client.get_paginator("list_presets")
list_queues_paginator: ListQueuesPaginator = client.get_paginator("list_queues")
```







### Typed dictionations

`mypy_boto3_mediaconvert.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_mediaconvert.type_defs import (
    AacSettingsTypeDef,
    Ac3SettingsTypeDef,
    AccelerationSettingsTypeDef,
    AiffSettingsTypeDef,
    AncillarySourceSettingsTypeDef,
    AudioChannelTaggingSettingsTypeDef,
    AudioCodecSettingsTypeDef,
    AudioDescriptionTypeDef,
    AudioNormalizationSettingsTypeDef,
    AudioSelectorGroupTypeDef,
    AudioSelectorTypeDef,
    Av1QvbrSettingsTypeDef,
    Av1SettingsTypeDef,
    AvailBlankingTypeDef,
    BurninDestinationSettingsTypeDef,
    CaptionDescriptionPresetTypeDef,
    CaptionDescriptionTypeDef,
    CaptionDestinationSettingsTypeDef,
    CaptionSelectorTypeDef,
    CaptionSourceFramerateTypeDef,
    CaptionSourceSettingsTypeDef,
    ChannelMappingTypeDef,
    CmafAdditionalManifestTypeDef,
    CmafEncryptionSettingsTypeDef,
    CmafGroupSettingsTypeDef,
    CmfcSettingsTypeDef,
    ColorCorrectorTypeDef,
    ContainerSettingsTypeDef,
    CreateJobResponseTypeDef,
    CreateJobTemplateResponseTypeDef,
    CreatePresetResponseTypeDef,
    CreateQueueResponseTypeDef,
    DashAdditionalManifestTypeDef,
    DashIsoEncryptionSettingsTypeDef,
    DashIsoGroupSettingsTypeDef,
    DeinterlacerTypeDef,
    DescribeEndpointsResponseTypeDef,
    DestinationSettingsTypeDef,
    DolbyVisionLevel6MetadataTypeDef,
    DolbyVisionTypeDef,
    DvbNitSettingsTypeDef,
    DvbSdtSettingsTypeDef,
    DvbSubDestinationSettingsTypeDef,
    DvbSubSourceSettingsTypeDef,
    DvbTdtSettingsTypeDef,
    Eac3AtmosSettingsTypeDef,
    Eac3SettingsTypeDef,
    EmbeddedDestinationSettingsTypeDef,
    EmbeddedSourceSettingsTypeDef,
    EndpointTypeDef,
    EsamManifestConfirmConditionNotificationTypeDef,
    EsamSettingsTypeDef,
    EsamSignalProcessingNotificationTypeDef,
    F4vSettingsTypeDef,
    FileGroupSettingsTypeDef,
    FileSourceSettingsTypeDef,
    FrameCaptureSettingsTypeDef,
    GetJobResponseTypeDef,
    GetJobTemplateResponseTypeDef,
    GetPresetResponseTypeDef,
    GetQueueResponseTypeDef,
    H264QvbrSettingsTypeDef,
    H264SettingsTypeDef,
    H265QvbrSettingsTypeDef,
    H265SettingsTypeDef,
    Hdr10MetadataTypeDef,
    HlsAdditionalManifestTypeDef,
    HlsCaptionLanguageMappingTypeDef,
    HlsEncryptionSettingsTypeDef,
    HlsGroupSettingsTypeDef,
    HlsSettingsTypeDef,
    HopDestinationTypeDef,
    Id3InsertionTypeDef,
    ImageInserterTypeDef,
    ImscDestinationSettingsTypeDef,
    InputClippingTypeDef,
    InputDecryptionSettingsTypeDef,
    InputTemplateTypeDef,
    InputTypeDef,
    InsertableImageTypeDef,
    JobMessagesTypeDef,
    JobSettingsTypeDef,
    JobTemplateSettingsTypeDef,
    JobTemplateTypeDef,
    JobTypeDef,
    ListJobsResponseTypeDef,
    ListJobTemplatesResponseTypeDef,
    ListPresetsResponseTypeDef,
    ListQueuesResponseTypeDef,
    ListTagsForResourceResponseTypeDef,
    M2tsScte35EsamTypeDef,
    M2tsSettingsTypeDef,
    M3u8SettingsTypeDef,
    MotionImageInserterTypeDef,
    MotionImageInsertionFramerateTypeDef,
    MotionImageInsertionOffsetTypeDef,
    MovSettingsTypeDef,
    Mp2SettingsTypeDef,
    Mp3SettingsTypeDef,
    Mp4SettingsTypeDef,
    MpdSettingsTypeDef,
    Mpeg2SettingsTypeDef,
    MsSmoothAdditionalManifestTypeDef,
    MsSmoothEncryptionSettingsTypeDef,
    MsSmoothGroupSettingsTypeDef,
    MxfSettingsTypeDef,
    NexGuardFileMarkerSettingsTypeDef,
    NielsenConfigurationTypeDef,
    NoiseReducerFilterSettingsTypeDef,
    NoiseReducerSpatialFilterSettingsTypeDef,
    NoiseReducerTemporalFilterSettingsTypeDef,
    NoiseReducerTypeDef,
    OpusSettingsTypeDef,
    OutputChannelMappingTypeDef,
    OutputDetailTypeDef,
    OutputGroupDetailTypeDef,
    OutputGroupSettingsTypeDef,
    OutputGroupTypeDef,
    OutputSettingsTypeDef,
    OutputTypeDef,
    PaginatorConfigTypeDef,
    PartnerWatermarkingTypeDef,
    PresetSettingsTypeDef,
    PresetTypeDef,
    ProresSettingsTypeDef,
    QueueTransitionTypeDef,
    QueueTypeDef,
    RectangleTypeDef,
    RemixSettingsTypeDef,
    ReservationPlanSettingsTypeDef,
    ReservationPlanTypeDef,
    ResourceTagsTypeDef,
    S3DestinationAccessControlTypeDef,
    S3DestinationSettingsTypeDef,
    S3EncryptionSettingsTypeDef,
    SccDestinationSettingsTypeDef,
    SpekeKeyProviderCmafTypeDef,
    SpekeKeyProviderTypeDef,
    StaticKeyProviderTypeDef,
    TeletextDestinationSettingsTypeDef,
    TeletextSourceSettingsTypeDef,
    TimecodeBurninTypeDef,
    TimecodeConfigTypeDef,
    TimedMetadataInsertionTypeDef,
    TimingTypeDef,
    TrackSourceSettingsTypeDef,
    TtmlDestinationSettingsTypeDef,
    UpdateJobTemplateResponseTypeDef,
    UpdatePresetResponseTypeDef,
    UpdateQueueResponseTypeDef,
    VideoCodecSettingsTypeDef,
    VideoDescriptionTypeDef,
    VideoDetailTypeDef,
    VideoPreprocessorTypeDef,
    VideoSelectorTypeDef,
    VorbisSettingsTypeDef,
    Vp8SettingsTypeDef,
    Vp9SettingsTypeDef,
    WavSettingsTypeDef,
)

def get_structure() -> AacSettingsTypeDef:
    return {
      ...
    }
```
