# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from typing import List, Optional
from typing_extensions import Literal

from .._models import BaseModel

__all__ = ["ChatCompletionsResponse", "Choice", "ChoiceMessage", "Usage"]


class ChoiceMessage(BaseModel):
    content: Optional[str] = None

    role: Literal["assistant"]


class Choice(BaseModel):
    finish_reason: Literal["stop", "length", "tool_calls", "content_filter", "function_call"]

    index: int

    message: ChoiceMessage


class Usage(BaseModel):
    completion_tokens: int
    """The number of tokens generated in the completion response.

    This counts only the tokens in the assistant's reply.
    """

    prompt_tokens: int
    """The number of tokens in the prompt/input.

    This includes all messages sent to the API in the conversation history.
    """

    total_tokens: int


class ChatCompletionsResponse(BaseModel):
    id: str
    """A unique identifier for this chat completion response.

    Can be used for tracking or debugging.
    """

    choices: List[Choice]
    """An array of completion choices.

    Each choice represents a possible completion for the input prompt, though
    currently only one choice is typically returned.
    """

    created: int
    """
    The Unix timestamp (in seconds) indicating when this completion was generated by
    the API.
    """

    model: str
    """The specific model used to generate this completion.

    This will be the model's full identifier string.
    """

    object: Literal["chat.completion"]
    """
    The type of object returned, always "chat.completion" for chat completion
    responses.
    """

    system_fingerprint: Optional[str] = None
    """A unique identifier for the system state that generated this response.

    Useful for tracking model behavior across requests.
    """

    usage: Optional[Usage] = None
    """Statistics about token usage for this request and response.

    May be omitted in error cases or when not available.
    """
