# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.alert_status import AlertStatus
from ..types.get_alerts_response import GetAlertsResponse
from .raw_client import AsyncRawAlertsClient, RawAlertsClient


class AlertsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawAlertsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawAlertsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawAlertsClient
        """
        return self._raw_client

    def list(
        self,
        *,
        start_ts: typing.Optional[str] = None,
        end_ts: typing.Optional[str] = None,
        cluster_id: typing.Optional[str] = None,
        application_id: typing.Optional[str] = None,
        alert_status: typing.Optional[AlertStatus] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetAlertsResponse:
        """
        Get alerts for a given application or cluster filtered by start and end timestamp

        Parameters
        ----------
        start_ts : typing.Optional[str]
            Start timestamp (ISO format) for querying events

        end_ts : typing.Optional[str]
            End timestamp (ISO format) for querying events

        cluster_id : typing.Optional[str]
            Cluster id

        application_id : typing.Optional[str]
            Application id

        alert_status : typing.Optional[AlertStatus]
            Alert status

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetAlertsResponse
            Returns an object with alert name as key and list of alerts as value

        Examples
        --------
        from truefoundry_sdk import AlertStatus, TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.alerts.list(
            start_ts="startTs",
            end_ts="endTs",
            cluster_id="clusterId",
            application_id="applicationId",
            alert_status=AlertStatus.FIRING,
        )
        """
        _response = self._raw_client.list(
            start_ts=start_ts,
            end_ts=end_ts,
            cluster_id=cluster_id,
            application_id=application_id,
            alert_status=alert_status,
            request_options=request_options,
        )
        return _response.data


class AsyncAlertsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawAlertsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawAlertsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawAlertsClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        start_ts: typing.Optional[str] = None,
        end_ts: typing.Optional[str] = None,
        cluster_id: typing.Optional[str] = None,
        application_id: typing.Optional[str] = None,
        alert_status: typing.Optional[AlertStatus] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetAlertsResponse:
        """
        Get alerts for a given application or cluster filtered by start and end timestamp

        Parameters
        ----------
        start_ts : typing.Optional[str]
            Start timestamp (ISO format) for querying events

        end_ts : typing.Optional[str]
            End timestamp (ISO format) for querying events

        cluster_id : typing.Optional[str]
            Cluster id

        application_id : typing.Optional[str]
            Application id

        alert_status : typing.Optional[AlertStatus]
            Alert status

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetAlertsResponse
            Returns an object with alert name as key and list of alerts as value

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AlertStatus, AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.alerts.list(
                start_ts="startTs",
                end_ts="endTs",
                cluster_id="clusterId",
                application_id="applicationId",
                alert_status=AlertStatus.FIRING,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list(
            start_ts=start_ts,
            end_ts=end_ts,
            cluster_id=cluster_id,
            application_id=application_id,
            alert_status=alert_status,
            request_options=request_options,
        )
        return _response.data
