# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..errors.bad_request_error import BadRequestError
from ..errors.forbidden_error import ForbiddenError
from ..types.alert_status import AlertStatus
from ..types.get_alerts_response import GetAlertsResponse
from ..types.http_error import HttpError


class RawAlertsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list(
        self,
        *,
        start_ts: typing.Optional[str] = None,
        end_ts: typing.Optional[str] = None,
        cluster_id: typing.Optional[str] = None,
        application_id: typing.Optional[str] = None,
        alert_status: typing.Optional[AlertStatus] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GetAlertsResponse]:
        """
        Get alerts for a given application or cluster filtered by start and end timestamp

        Parameters
        ----------
        start_ts : typing.Optional[str]
            Start timestamp (ISO format) for querying events

        end_ts : typing.Optional[str]
            End timestamp (ISO format) for querying events

        cluster_id : typing.Optional[str]
            Cluster id

        application_id : typing.Optional[str]
            Application id

        alert_status : typing.Optional[AlertStatus]
            Alert status

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GetAlertsResponse]
            Returns an object with alert name as key and list of alerts as value
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/svc/v1/alerts",
            method="GET",
            params={
                "startTs": start_ts,
                "endTs": end_ts,
                "clusterId": cluster_id,
                "applicationId": application_id,
                "alertStatus": alert_status,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetAlertsResponse,
                    parse_obj_as(
                        type_=GetAlertsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpError,
                        parse_obj_as(
                            type_=HttpError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawAlertsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list(
        self,
        *,
        start_ts: typing.Optional[str] = None,
        end_ts: typing.Optional[str] = None,
        cluster_id: typing.Optional[str] = None,
        application_id: typing.Optional[str] = None,
        alert_status: typing.Optional[AlertStatus] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GetAlertsResponse]:
        """
        Get alerts for a given application or cluster filtered by start and end timestamp

        Parameters
        ----------
        start_ts : typing.Optional[str]
            Start timestamp (ISO format) for querying events

        end_ts : typing.Optional[str]
            End timestamp (ISO format) for querying events

        cluster_id : typing.Optional[str]
            Cluster id

        application_id : typing.Optional[str]
            Application id

        alert_status : typing.Optional[AlertStatus]
            Alert status

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GetAlertsResponse]
            Returns an object with alert name as key and list of alerts as value
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/svc/v1/alerts",
            method="GET",
            params={
                "startTs": start_ts,
                "endTs": end_ts,
                "clusterId": cluster_id,
                "applicationId": application_id,
                "alertStatus": alert_status,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetAlertsResponse,
                    parse_obj_as(
                        type_=GetAlertsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpError,
                        parse_obj_as(
                            type_=HttpError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
