# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..core.pagination import AsyncPager, BaseHttpResponse, SyncPager
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..errors.bad_request_error import BadRequestError
from ..errors.conflict_error import ConflictError
from ..errors.forbidden_error import ForbiddenError
from ..errors.method_not_allowed_error import MethodNotAllowedError
from ..errors.not_found_error import NotFoundError
from ..errors.not_implemented_error import NotImplementedError
from ..types.application import Application
from ..types.delete_application_response import DeleteApplicationResponse
from ..types.deployment import Deployment
from ..types.get_application_deployment_response import GetApplicationDeploymentResponse
from ..types.get_application_response import GetApplicationResponse
from ..types.http_error import HttpError
from ..types.list_applications_response import ListApplicationsResponse
from .types.applications_cancel_deployment_response import ApplicationsCancelDeploymentResponse
from .types.applications_list_request_device_type_filter import ApplicationsListRequestDeviceTypeFilter
from .types.applications_list_request_lifecycle_stage import ApplicationsListRequestLifecycleStage

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawApplicationsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list(
        self,
        *,
        limit: typing.Optional[int] = 100,
        offset: typing.Optional[int] = 0,
        application_id: typing.Optional[str] = None,
        workspace_id: typing.Optional[str] = None,
        application_name: typing.Optional[str] = None,
        fqn: typing.Optional[str] = None,
        workspace_fqn: typing.Optional[str] = None,
        application_type: typing.Optional[str] = None,
        name_search_query: typing.Optional[str] = None,
        environment_id: typing.Optional[str] = None,
        cluster_id: typing.Optional[str] = None,
        application_set_id: typing.Optional[str] = None,
        paused: typing.Optional[bool] = None,
        device_type_filter: typing.Optional[ApplicationsListRequestDeviceTypeFilter] = None,
        last_deployed_by_subjects: typing.Optional[str] = None,
        lifecycle_stage: typing.Optional[ApplicationsListRequestLifecycleStage] = None,
        is_recommendation_present_and_visible: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[Application]:
        """
        Retrieves a list of all latest applications. Supports filtering by application ID, name, type, and other parameters. Pagination is available based on query parameters.

        Parameters
        ----------
        limit : typing.Optional[int]
            Number of items per page

        offset : typing.Optional[int]
            Number of items to skip

        application_id : typing.Optional[str]
            Application id of the application

        workspace_id : typing.Optional[str]
            Workspace id of the application (comma separated for multiple)

        application_name : typing.Optional[str]
            Name of application

        fqn : typing.Optional[str]
            Fully qualified name (FQN) of the application

        workspace_fqn : typing.Optional[str]
            Fully qualified name (FQN) of the workspace

        application_type : typing.Optional[str]
            Type of application (comma separated for multiple). Allowed Values: async-service, service, job, spark-job, helm, notebook, codeserver, rstudio, ssh-server, volume, application, application-set, intercept, workflow

        name_search_query : typing.Optional[str]
            Search query for application name

        environment_id : typing.Optional[str]
            Filter by Environment ids of the application (comma separated for multiple)

        cluster_id : typing.Optional[str]
            Filter by Cluster ids of the application (comma separated for multiple)

        application_set_id : typing.Optional[str]
            Filter by Application Set id of the application

        paused : typing.Optional[bool]
            Filter by Application Paused status

        device_type_filter : typing.Optional[ApplicationsListRequestDeviceTypeFilter]
            Filter by device type of the application. Allowed values: cpu, nvidia_gpu, aws_inferentia, nvidia_mig_gpu, nvidia_timeslicing_gpu, gcp_tpu

        last_deployed_by_subjects : typing.Optional[str]
            Filter by last deployed by specific users

        lifecycle_stage : typing.Optional[ApplicationsListRequestLifecycleStage]
            Filter by application lifecycle state

        is_recommendation_present_and_visible : typing.Optional[bool]
            Filter out applications with recommendations that are allowed to be shown

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[Application]
            Retrieve latest applications based on the specified query parameters. If pagination parameters are provided, the response includes paginated data.
        """
        offset = offset if offset is not None else 0

        _response = self._client_wrapper.httpx_client.request(
            "api/svc/v1/apps",
            method="GET",
            params={
                "limit": limit,
                "offset": offset,
                "applicationId": application_id,
                "workspaceId": workspace_id,
                "applicationName": application_name,
                "fqn": fqn,
                "workspaceFqn": workspace_fqn,
                "applicationType": application_type,
                "nameSearchQuery": name_search_query,
                "environmentId": environment_id,
                "clusterId": cluster_id,
                "applicationSetId": application_set_id,
                "paused": paused,
                "deviceTypeFilter": device_type_filter,
                "lastDeployedBySubjects": last_deployed_by_subjects,
                "lifecycleStage": lifecycle_stage,
                "isRecommendationPresentAndVisible": is_recommendation_present_and_visible,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _parsed_response = typing.cast(
                    ListApplicationsResponse,
                    parse_obj_as(
                        type_=ListApplicationsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                _items = _parsed_response.data
                _has_next = True
                _get_next = lambda: self.list(
                    limit=limit,
                    offset=offset + len(_items),
                    application_id=application_id,
                    workspace_id=workspace_id,
                    application_name=application_name,
                    fqn=fqn,
                    workspace_fqn=workspace_fqn,
                    application_type=application_type,
                    name_search_query=name_search_query,
                    environment_id=environment_id,
                    cluster_id=cluster_id,
                    application_set_id=application_set_id,
                    paused=paused,
                    device_type_filter=device_type_filter,
                    last_deployed_by_subjects=last_deployed_by_subjects,
                    lifecycle_stage=lifecycle_stage,
                    is_recommendation_present_and_visible=is_recommendation_present_and_visible,
                    request_options=request_options,
                )
                return SyncPager(
                    has_next=_has_next, items=_items, get_next=_get_next, response=BaseHttpResponse(response=_response)
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create_or_update(
        self,
        *,
        manifest: typing.Dict[str, typing.Optional[typing.Any]],
        dry_run: typing.Optional[bool] = OMIT,
        force_deploy: typing.Optional[bool] = OMIT,
        trigger_on_deploy: typing.Optional[bool] = OMIT,
        workspace_id: typing.Optional[str] = OMIT,
        application_id: typing.Optional[str] = OMIT,
        name: typing.Optional[str] = OMIT,
        application_set_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GetApplicationDeploymentResponse]:
        """
        Create a new Application Deployment based on the provided manifest.

        Parameters
        ----------
        manifest : typing.Dict[str, typing.Optional[typing.Any]]
            Manifest of application

        dry_run : typing.Optional[bool]
            Dry run

        force_deploy : typing.Optional[bool]
            Cancels any ongoing deployments

        trigger_on_deploy : typing.Optional[bool]
            Trigger on deploy

        workspace_id : typing.Optional[str]
            workspace id of the workspace

        application_id : typing.Optional[str]
            Id of the application

        name : typing.Optional[str]
            Name of application

        application_set_id : typing.Optional[str]
            Application Set Id

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GetApplicationDeploymentResponse]
            Returns new deployment on successful creation
                  - It also creates an application if not already present
                  - validates third party requirements
                  - updates application, version
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/svc/v1/apps",
            method="PUT",
            json={
                "manifest": manifest,
                "dryRun": dry_run,
                "forceDeploy": force_deploy,
                "triggerOnDeploy": trigger_on_deploy,
                "workspaceId": workspace_id,
                "applicationId": application_id,
                "name": name,
                "applicationSetId": application_set_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetApplicationDeploymentResponse,
                    parse_obj_as(
                        type_=GetApplicationDeploymentResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpError,
                        parse_obj_as(
                            type_=HttpError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 409:
                raise ConflictError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpError,
                        parse_obj_as(
                            type_=HttpError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[GetApplicationResponse]:
        """
        Get Application associated with the provided application ID.

        Parameters
        ----------
        id : str
            Id of the application

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GetApplicationResponse]
            Application details retrieved successfully
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/svc/v1/apps/{jsonable_encoder(id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetApplicationResponse,
                    parse_obj_as(
                        type_=GetApplicationResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpError,
                        parse_obj_as(
                            type_=HttpError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def delete(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[DeleteApplicationResponse]:
        """
        Delete Application associated with the provided application ID.

        Parameters
        ----------
        id : str
            Id of the application

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[DeleteApplicationResponse]
            Delete application response.
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/svc/v1/apps/{jsonable_encoder(id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DeleteApplicationResponse,
                    parse_obj_as(
                        type_=DeleteApplicationResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpError,
                        parse_obj_as(
                            type_=HttpError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def scale_to_zero(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> HttpResponse[None]:
        """
        Pause a running application by scaling to 0 replicas

        Parameters
        ----------
        id : str
            Id of the application

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[None]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/svc/v1/apps/{jsonable_encoder(id)}/scale-to-zero",
            method="PATCH",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return HttpResponse(response=_response, data=None)
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpError,
                        parse_obj_as(
                            type_=HttpError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 405:
                raise MethodNotAllowedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 501:
                raise NotImplementedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpError,
                        parse_obj_as(
                            type_=HttpError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def scale_to_original(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[Deployment]:
        """
        Resume a paused application by scaling back to the original number of replicas

        Parameters
        ----------
        id : str
            Id of the application

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[Deployment]
            Scales back a paused applicaion to the original number of replicas
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/svc/v1/apps/{jsonable_encoder(id)}/scale-to-original",
            method="PATCH",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Deployment,
                    parse_obj_as(
                        type_=Deployment,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpError,
                        parse_obj_as(
                            type_=HttpError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 501:
                raise NotImplementedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpError,
                        parse_obj_as(
                            type_=HttpError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def cancel_deployment(
        self, id: str, deployment_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[ApplicationsCancelDeploymentResponse]:
        """
        Cancel an ongoing deployment associated with the provided application ID and deployment ID.

        Parameters
        ----------
        id : str
            Application id of the application

        deployment_id : str
            Deployment id of the deployment

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ApplicationsCancelDeploymentResponse]
            Deployment cancelled successfully.
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/svc/v1/apps/{jsonable_encoder(id)}/deployments/{jsonable_encoder(deployment_id)}/cancel",
            method="POST",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ApplicationsCancelDeploymentResponse,
                    parse_obj_as(
                        type_=ApplicationsCancelDeploymentResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpError,
                        parse_obj_as(
                            type_=HttpError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 409:
                raise ConflictError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpError,
                        parse_obj_as(
                            type_=HttpError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawApplicationsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list(
        self,
        *,
        limit: typing.Optional[int] = 100,
        offset: typing.Optional[int] = 0,
        application_id: typing.Optional[str] = None,
        workspace_id: typing.Optional[str] = None,
        application_name: typing.Optional[str] = None,
        fqn: typing.Optional[str] = None,
        workspace_fqn: typing.Optional[str] = None,
        application_type: typing.Optional[str] = None,
        name_search_query: typing.Optional[str] = None,
        environment_id: typing.Optional[str] = None,
        cluster_id: typing.Optional[str] = None,
        application_set_id: typing.Optional[str] = None,
        paused: typing.Optional[bool] = None,
        device_type_filter: typing.Optional[ApplicationsListRequestDeviceTypeFilter] = None,
        last_deployed_by_subjects: typing.Optional[str] = None,
        lifecycle_stage: typing.Optional[ApplicationsListRequestLifecycleStage] = None,
        is_recommendation_present_and_visible: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[Application]:
        """
        Retrieves a list of all latest applications. Supports filtering by application ID, name, type, and other parameters. Pagination is available based on query parameters.

        Parameters
        ----------
        limit : typing.Optional[int]
            Number of items per page

        offset : typing.Optional[int]
            Number of items to skip

        application_id : typing.Optional[str]
            Application id of the application

        workspace_id : typing.Optional[str]
            Workspace id of the application (comma separated for multiple)

        application_name : typing.Optional[str]
            Name of application

        fqn : typing.Optional[str]
            Fully qualified name (FQN) of the application

        workspace_fqn : typing.Optional[str]
            Fully qualified name (FQN) of the workspace

        application_type : typing.Optional[str]
            Type of application (comma separated for multiple). Allowed Values: async-service, service, job, spark-job, helm, notebook, codeserver, rstudio, ssh-server, volume, application, application-set, intercept, workflow

        name_search_query : typing.Optional[str]
            Search query for application name

        environment_id : typing.Optional[str]
            Filter by Environment ids of the application (comma separated for multiple)

        cluster_id : typing.Optional[str]
            Filter by Cluster ids of the application (comma separated for multiple)

        application_set_id : typing.Optional[str]
            Filter by Application Set id of the application

        paused : typing.Optional[bool]
            Filter by Application Paused status

        device_type_filter : typing.Optional[ApplicationsListRequestDeviceTypeFilter]
            Filter by device type of the application. Allowed values: cpu, nvidia_gpu, aws_inferentia, nvidia_mig_gpu, nvidia_timeslicing_gpu, gcp_tpu

        last_deployed_by_subjects : typing.Optional[str]
            Filter by last deployed by specific users

        lifecycle_stage : typing.Optional[ApplicationsListRequestLifecycleStage]
            Filter by application lifecycle state

        is_recommendation_present_and_visible : typing.Optional[bool]
            Filter out applications with recommendations that are allowed to be shown

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[Application]
            Retrieve latest applications based on the specified query parameters. If pagination parameters are provided, the response includes paginated data.
        """
        offset = offset if offset is not None else 0

        _response = await self._client_wrapper.httpx_client.request(
            "api/svc/v1/apps",
            method="GET",
            params={
                "limit": limit,
                "offset": offset,
                "applicationId": application_id,
                "workspaceId": workspace_id,
                "applicationName": application_name,
                "fqn": fqn,
                "workspaceFqn": workspace_fqn,
                "applicationType": application_type,
                "nameSearchQuery": name_search_query,
                "environmentId": environment_id,
                "clusterId": cluster_id,
                "applicationSetId": application_set_id,
                "paused": paused,
                "deviceTypeFilter": device_type_filter,
                "lastDeployedBySubjects": last_deployed_by_subjects,
                "lifecycleStage": lifecycle_stage,
                "isRecommendationPresentAndVisible": is_recommendation_present_and_visible,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _parsed_response = typing.cast(
                    ListApplicationsResponse,
                    parse_obj_as(
                        type_=ListApplicationsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                _items = _parsed_response.data
                _has_next = True

                async def _get_next():
                    return await self.list(
                        limit=limit,
                        offset=offset + len(_items),
                        application_id=application_id,
                        workspace_id=workspace_id,
                        application_name=application_name,
                        fqn=fqn,
                        workspace_fqn=workspace_fqn,
                        application_type=application_type,
                        name_search_query=name_search_query,
                        environment_id=environment_id,
                        cluster_id=cluster_id,
                        application_set_id=application_set_id,
                        paused=paused,
                        device_type_filter=device_type_filter,
                        last_deployed_by_subjects=last_deployed_by_subjects,
                        lifecycle_stage=lifecycle_stage,
                        is_recommendation_present_and_visible=is_recommendation_present_and_visible,
                        request_options=request_options,
                    )

                return AsyncPager(
                    has_next=_has_next, items=_items, get_next=_get_next, response=BaseHttpResponse(response=_response)
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create_or_update(
        self,
        *,
        manifest: typing.Dict[str, typing.Optional[typing.Any]],
        dry_run: typing.Optional[bool] = OMIT,
        force_deploy: typing.Optional[bool] = OMIT,
        trigger_on_deploy: typing.Optional[bool] = OMIT,
        workspace_id: typing.Optional[str] = OMIT,
        application_id: typing.Optional[str] = OMIT,
        name: typing.Optional[str] = OMIT,
        application_set_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GetApplicationDeploymentResponse]:
        """
        Create a new Application Deployment based on the provided manifest.

        Parameters
        ----------
        manifest : typing.Dict[str, typing.Optional[typing.Any]]
            Manifest of application

        dry_run : typing.Optional[bool]
            Dry run

        force_deploy : typing.Optional[bool]
            Cancels any ongoing deployments

        trigger_on_deploy : typing.Optional[bool]
            Trigger on deploy

        workspace_id : typing.Optional[str]
            workspace id of the workspace

        application_id : typing.Optional[str]
            Id of the application

        name : typing.Optional[str]
            Name of application

        application_set_id : typing.Optional[str]
            Application Set Id

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GetApplicationDeploymentResponse]
            Returns new deployment on successful creation
                  - It also creates an application if not already present
                  - validates third party requirements
                  - updates application, version
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/svc/v1/apps",
            method="PUT",
            json={
                "manifest": manifest,
                "dryRun": dry_run,
                "forceDeploy": force_deploy,
                "triggerOnDeploy": trigger_on_deploy,
                "workspaceId": workspace_id,
                "applicationId": application_id,
                "name": name,
                "applicationSetId": application_set_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetApplicationDeploymentResponse,
                    parse_obj_as(
                        type_=GetApplicationDeploymentResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpError,
                        parse_obj_as(
                            type_=HttpError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 409:
                raise ConflictError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpError,
                        parse_obj_as(
                            type_=HttpError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[GetApplicationResponse]:
        """
        Get Application associated with the provided application ID.

        Parameters
        ----------
        id : str
            Id of the application

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GetApplicationResponse]
            Application details retrieved successfully
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/svc/v1/apps/{jsonable_encoder(id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetApplicationResponse,
                    parse_obj_as(
                        type_=GetApplicationResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpError,
                        parse_obj_as(
                            type_=HttpError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def delete(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[DeleteApplicationResponse]:
        """
        Delete Application associated with the provided application ID.

        Parameters
        ----------
        id : str
            Id of the application

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[DeleteApplicationResponse]
            Delete application response.
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/svc/v1/apps/{jsonable_encoder(id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DeleteApplicationResponse,
                    parse_obj_as(
                        type_=DeleteApplicationResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpError,
                        parse_obj_as(
                            type_=HttpError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def scale_to_zero(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[None]:
        """
        Pause a running application by scaling to 0 replicas

        Parameters
        ----------
        id : str
            Id of the application

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[None]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/svc/v1/apps/{jsonable_encoder(id)}/scale-to-zero",
            method="PATCH",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return AsyncHttpResponse(response=_response, data=None)
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpError,
                        parse_obj_as(
                            type_=HttpError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 405:
                raise MethodNotAllowedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 501:
                raise NotImplementedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpError,
                        parse_obj_as(
                            type_=HttpError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def scale_to_original(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[Deployment]:
        """
        Resume a paused application by scaling back to the original number of replicas

        Parameters
        ----------
        id : str
            Id of the application

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[Deployment]
            Scales back a paused applicaion to the original number of replicas
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/svc/v1/apps/{jsonable_encoder(id)}/scale-to-original",
            method="PATCH",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Deployment,
                    parse_obj_as(
                        type_=Deployment,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpError,
                        parse_obj_as(
                            type_=HttpError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 501:
                raise NotImplementedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpError,
                        parse_obj_as(
                            type_=HttpError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def cancel_deployment(
        self, id: str, deployment_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[ApplicationsCancelDeploymentResponse]:
        """
        Cancel an ongoing deployment associated with the provided application ID and deployment ID.

        Parameters
        ----------
        id : str
            Application id of the application

        deployment_id : str
            Deployment id of the deployment

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ApplicationsCancelDeploymentResponse]
            Deployment cancelled successfully.
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/svc/v1/apps/{jsonable_encoder(id)}/deployments/{jsonable_encoder(deployment_id)}/cancel",
            method="POST",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ApplicationsCancelDeploymentResponse,
                    parse_obj_as(
                        type_=ApplicationsCancelDeploymentResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpError,
                        parse_obj_as(
                            type_=HttpError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 409:
                raise ConflictError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpError,
                        parse_obj_as(
                            type_=HttpError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
