# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import os
import typing

import httpx
from .core.api_error import ApiError
from .core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .core.request_options import RequestOptions
from .raw_base_client import AsyncRawBaseTrueFoundry, RawBaseTrueFoundry
from .types.true_foundry_apply_request_manifest import TrueFoundryApplyRequestManifest
from .types.true_foundry_apply_response import TrueFoundryApplyResponse
from .types.true_foundry_delete_request_manifest import TrueFoundryDeleteRequestManifest

if typing.TYPE_CHECKING:
    from .alerts.client import AlertsClient, AsyncAlertsClient
    from .application_versions.client import ApplicationVersionsClient, AsyncApplicationVersionsClient
    from .applications.client import ApplicationsClient, AsyncApplicationsClient
    from .artifact_versions.client import ArtifactVersionsClient, AsyncArtifactVersionsClient
    from .artifacts.client import ArtifactsClient, AsyncArtifactsClient
    from .clusters.client import AsyncClustersClient, ClustersClient
    from .data_directories.client import AsyncDataDirectoriesClient, DataDirectoriesClient
    from .environments.client import AsyncEnvironmentsClient, EnvironmentsClient
    from .events.client import AsyncEventsClient, EventsClient
    from .internal.client import AsyncInternalClient, InternalClient
    from .jobs.client import AsyncJobsClient, JobsClient
    from .logs.client import AsyncLogsClient, LogsClient
    from .ml_repos.client import AsyncMlReposClient, MlReposClient
    from .model_versions.client import AsyncModelVersionsClient, ModelVersionsClient
    from .models.client import AsyncModelsClient, ModelsClient
    from .personal_access_tokens.client import AsyncPersonalAccessTokensClient, PersonalAccessTokensClient
    from .prompt_versions.client import AsyncPromptVersionsClient, PromptVersionsClient
    from .prompts.client import AsyncPromptsClient, PromptsClient
    from .secret_groups.client import AsyncSecretGroupsClient, SecretGroupsClient
    from .secrets.client import AsyncSecretsClient, SecretsClient
    from .teams.client import AsyncTeamsClient, TeamsClient
    from .traces.client import AsyncTracesClient, TracesClient
    from .users.client import AsyncUsersClient, UsersClient
    from .virtual_accounts.client import AsyncVirtualAccountsClient, VirtualAccountsClient
    from .workspaces.client import AsyncWorkspacesClient, WorkspacesClient
# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class BaseTrueFoundry:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    base_url : str
        The base url to use for requests from the client.

    api_key : typing.Optional[typing.Union[str, typing.Callable[[], str]]]
    headers : typing.Optional[typing.Dict[str, str]]
        Additional headers to send with every request.

    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default the timeout is 60 seconds, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.Client]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from truefoundry_sdk import TrueFoundry

    client = TrueFoundry(
        api_key="YOUR_API_KEY",
        base_url="https://yourhost.com/path/to/api",
    )
    """

    def __init__(
        self,
        *,
        base_url: str,
        api_key: typing.Optional[typing.Union[str, typing.Callable[[], str]]] = os.getenv("TFY_API_KEY"),
        headers: typing.Optional[typing.Dict[str, str]] = None,
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.Client] = None,
    ):
        _defaulted_timeout = (
            timeout if timeout is not None else 60 if httpx_client is None else httpx_client.timeout.read
        )
        if api_key is None:
            raise ApiError(body="The client must be instantiated be either passing in api_key or setting TFY_API_KEY")
        self._client_wrapper = SyncClientWrapper(
            base_url=base_url,
            api_key=api_key,
            headers=headers,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.Client(timeout=_defaulted_timeout, follow_redirects=follow_redirects)
            if follow_redirects is not None
            else httpx.Client(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self._raw_client = RawBaseTrueFoundry(client_wrapper=self._client_wrapper)
        self._internal: typing.Optional[InternalClient] = None
        self._users: typing.Optional[UsersClient] = None
        self._teams: typing.Optional[TeamsClient] = None
        self._personal_access_tokens: typing.Optional[PersonalAccessTokensClient] = None
        self._virtual_accounts: typing.Optional[VirtualAccountsClient] = None
        self._secrets: typing.Optional[SecretsClient] = None
        self._secret_groups: typing.Optional[SecretGroupsClient] = None
        self._clusters: typing.Optional[ClustersClient] = None
        self._environments: typing.Optional[EnvironmentsClient] = None
        self._applications: typing.Optional[ApplicationsClient] = None
        self._application_versions: typing.Optional[ApplicationVersionsClient] = None
        self._jobs: typing.Optional[JobsClient] = None
        self._workspaces: typing.Optional[WorkspacesClient] = None
        self._events: typing.Optional[EventsClient] = None
        self._alerts: typing.Optional[AlertsClient] = None
        self._logs: typing.Optional[LogsClient] = None
        self._ml_repos: typing.Optional[MlReposClient] = None
        self._traces: typing.Optional[TracesClient] = None
        self._artifacts: typing.Optional[ArtifactsClient] = None
        self._prompts: typing.Optional[PromptsClient] = None
        self._models: typing.Optional[ModelsClient] = None
        self._artifact_versions: typing.Optional[ArtifactVersionsClient] = None
        self._model_versions: typing.Optional[ModelVersionsClient] = None
        self._prompt_versions: typing.Optional[PromptVersionsClient] = None
        self._data_directories: typing.Optional[DataDirectoriesClient] = None

    @property
    def with_raw_response(self) -> RawBaseTrueFoundry:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawBaseTrueFoundry
        """
        return self._raw_client

    def apply(
        self,
        *,
        manifest: TrueFoundryApplyRequestManifest,
        dry_run: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TrueFoundryApplyResponse:
        """
        Applies a given manifest to create or update resources of specific types, such as provider-account, cluster, workspace, or ml-repo.

        Parameters
        ----------
        manifest : TrueFoundryApplyRequestManifest
            manifest of the resource to be created or updated

        dry_run : typing.Optional[bool]
            Dry run the apply operation without actually applying

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TrueFoundryApplyResponse
            The resource has been successfully created or updated.

        Examples
        --------
        from truefoundry_sdk import Collaborator, MlRepoManifest, TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.apply(
            manifest=MlRepoManifest(
                name="name",
                storage_integration_fqn="storage_integration_fqn",
                collaborators=[
                    Collaborator(
                        subject="subject",
                        role_id="role_id",
                    )
                ],
            ),
        )
        """
        _response = self._raw_client.apply(manifest=manifest, dry_run=dry_run, request_options=request_options)
        return _response.data

    def delete(
        self, *, manifest: TrueFoundryDeleteRequestManifest, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Deletes resources of specific types, such as provider-account, cluster, workspace, or application.

        Parameters
        ----------
        manifest : TrueFoundryDeleteRequestManifest
            manifest of the resource to be deleted

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from truefoundry_sdk import Collaborator, MlRepoManifest, TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.delete(
            manifest=MlRepoManifest(
                name="name",
                storage_integration_fqn="storage_integration_fqn",
                collaborators=[
                    Collaborator(
                        subject="subject",
                        role_id="role_id",
                    )
                ],
            ),
        )
        """
        _response = self._raw_client.delete(manifest=manifest, request_options=request_options)
        return _response.data

    @property
    def internal(self):
        if self._internal is None:
            from .internal.client import InternalClient  # noqa: E402

            self._internal = InternalClient(client_wrapper=self._client_wrapper)
        return self._internal

    @property
    def users(self):
        if self._users is None:
            from .users.client import UsersClient  # noqa: E402

            self._users = UsersClient(client_wrapper=self._client_wrapper)
        return self._users

    @property
    def teams(self):
        if self._teams is None:
            from .teams.client import TeamsClient  # noqa: E402

            self._teams = TeamsClient(client_wrapper=self._client_wrapper)
        return self._teams

    @property
    def personal_access_tokens(self):
        if self._personal_access_tokens is None:
            from .personal_access_tokens.client import PersonalAccessTokensClient  # noqa: E402

            self._personal_access_tokens = PersonalAccessTokensClient(client_wrapper=self._client_wrapper)
        return self._personal_access_tokens

    @property
    def virtual_accounts(self):
        if self._virtual_accounts is None:
            from .virtual_accounts.client import VirtualAccountsClient  # noqa: E402

            self._virtual_accounts = VirtualAccountsClient(client_wrapper=self._client_wrapper)
        return self._virtual_accounts

    @property
    def secrets(self):
        if self._secrets is None:
            from .secrets.client import SecretsClient  # noqa: E402

            self._secrets = SecretsClient(client_wrapper=self._client_wrapper)
        return self._secrets

    @property
    def secret_groups(self):
        if self._secret_groups is None:
            from .secret_groups.client import SecretGroupsClient  # noqa: E402

            self._secret_groups = SecretGroupsClient(client_wrapper=self._client_wrapper)
        return self._secret_groups

    @property
    def clusters(self):
        if self._clusters is None:
            from .clusters.client import ClustersClient  # noqa: E402

            self._clusters = ClustersClient(client_wrapper=self._client_wrapper)
        return self._clusters

    @property
    def environments(self):
        if self._environments is None:
            from .environments.client import EnvironmentsClient  # noqa: E402

            self._environments = EnvironmentsClient(client_wrapper=self._client_wrapper)
        return self._environments

    @property
    def applications(self):
        if self._applications is None:
            from .applications.client import ApplicationsClient  # noqa: E402

            self._applications = ApplicationsClient(client_wrapper=self._client_wrapper)
        return self._applications

    @property
    def application_versions(self):
        if self._application_versions is None:
            from .application_versions.client import ApplicationVersionsClient  # noqa: E402

            self._application_versions = ApplicationVersionsClient(client_wrapper=self._client_wrapper)
        return self._application_versions

    @property
    def jobs(self):
        if self._jobs is None:
            from .jobs.client import JobsClient  # noqa: E402

            self._jobs = JobsClient(client_wrapper=self._client_wrapper)
        return self._jobs

    @property
    def workspaces(self):
        if self._workspaces is None:
            from .workspaces.client import WorkspacesClient  # noqa: E402

            self._workspaces = WorkspacesClient(client_wrapper=self._client_wrapper)
        return self._workspaces

    @property
    def events(self):
        if self._events is None:
            from .events.client import EventsClient  # noqa: E402

            self._events = EventsClient(client_wrapper=self._client_wrapper)
        return self._events

    @property
    def alerts(self):
        if self._alerts is None:
            from .alerts.client import AlertsClient  # noqa: E402

            self._alerts = AlertsClient(client_wrapper=self._client_wrapper)
        return self._alerts

    @property
    def logs(self):
        if self._logs is None:
            from .logs.client import LogsClient  # noqa: E402

            self._logs = LogsClient(client_wrapper=self._client_wrapper)
        return self._logs

    @property
    def ml_repos(self):
        if self._ml_repos is None:
            from .ml_repos.client import MlReposClient  # noqa: E402

            self._ml_repos = MlReposClient(client_wrapper=self._client_wrapper)
        return self._ml_repos

    @property
    def traces(self):
        if self._traces is None:
            from .traces.client import TracesClient  # noqa: E402

            self._traces = TracesClient(client_wrapper=self._client_wrapper)
        return self._traces

    @property
    def artifacts(self):
        if self._artifacts is None:
            from .artifacts.client import ArtifactsClient  # noqa: E402

            self._artifacts = ArtifactsClient(client_wrapper=self._client_wrapper)
        return self._artifacts

    @property
    def prompts(self):
        if self._prompts is None:
            from .prompts.client import PromptsClient  # noqa: E402

            self._prompts = PromptsClient(client_wrapper=self._client_wrapper)
        return self._prompts

    @property
    def models(self):
        if self._models is None:
            from .models.client import ModelsClient  # noqa: E402

            self._models = ModelsClient(client_wrapper=self._client_wrapper)
        return self._models

    @property
    def artifact_versions(self):
        if self._artifact_versions is None:
            from .artifact_versions.client import ArtifactVersionsClient  # noqa: E402

            self._artifact_versions = ArtifactVersionsClient(client_wrapper=self._client_wrapper)
        return self._artifact_versions

    @property
    def model_versions(self):
        if self._model_versions is None:
            from .model_versions.client import ModelVersionsClient  # noqa: E402

            self._model_versions = ModelVersionsClient(client_wrapper=self._client_wrapper)
        return self._model_versions

    @property
    def prompt_versions(self):
        if self._prompt_versions is None:
            from .prompt_versions.client import PromptVersionsClient  # noqa: E402

            self._prompt_versions = PromptVersionsClient(client_wrapper=self._client_wrapper)
        return self._prompt_versions

    @property
    def data_directories(self):
        if self._data_directories is None:
            from .data_directories.client import DataDirectoriesClient  # noqa: E402

            self._data_directories = DataDirectoriesClient(client_wrapper=self._client_wrapper)
        return self._data_directories


class AsyncBaseTrueFoundry:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    base_url : str
        The base url to use for requests from the client.

    api_key : typing.Optional[typing.Union[str, typing.Callable[[], str]]]
    headers : typing.Optional[typing.Dict[str, str]]
        Additional headers to send with every request.

    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default the timeout is 60 seconds, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.AsyncClient]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from truefoundry_sdk import AsyncTrueFoundry

    client = AsyncTrueFoundry(
        api_key="YOUR_API_KEY",
        base_url="https://yourhost.com/path/to/api",
    )
    """

    def __init__(
        self,
        *,
        base_url: str,
        api_key: typing.Optional[typing.Union[str, typing.Callable[[], str]]] = os.getenv("TFY_API_KEY"),
        headers: typing.Optional[typing.Dict[str, str]] = None,
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.AsyncClient] = None,
    ):
        _defaulted_timeout = (
            timeout if timeout is not None else 60 if httpx_client is None else httpx_client.timeout.read
        )
        if api_key is None:
            raise ApiError(body="The client must be instantiated be either passing in api_key or setting TFY_API_KEY")
        self._client_wrapper = AsyncClientWrapper(
            base_url=base_url,
            api_key=api_key,
            headers=headers,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.AsyncClient(timeout=_defaulted_timeout, follow_redirects=follow_redirects)
            if follow_redirects is not None
            else httpx.AsyncClient(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self._raw_client = AsyncRawBaseTrueFoundry(client_wrapper=self._client_wrapper)
        self._internal: typing.Optional[AsyncInternalClient] = None
        self._users: typing.Optional[AsyncUsersClient] = None
        self._teams: typing.Optional[AsyncTeamsClient] = None
        self._personal_access_tokens: typing.Optional[AsyncPersonalAccessTokensClient] = None
        self._virtual_accounts: typing.Optional[AsyncVirtualAccountsClient] = None
        self._secrets: typing.Optional[AsyncSecretsClient] = None
        self._secret_groups: typing.Optional[AsyncSecretGroupsClient] = None
        self._clusters: typing.Optional[AsyncClustersClient] = None
        self._environments: typing.Optional[AsyncEnvironmentsClient] = None
        self._applications: typing.Optional[AsyncApplicationsClient] = None
        self._application_versions: typing.Optional[AsyncApplicationVersionsClient] = None
        self._jobs: typing.Optional[AsyncJobsClient] = None
        self._workspaces: typing.Optional[AsyncWorkspacesClient] = None
        self._events: typing.Optional[AsyncEventsClient] = None
        self._alerts: typing.Optional[AsyncAlertsClient] = None
        self._logs: typing.Optional[AsyncLogsClient] = None
        self._ml_repos: typing.Optional[AsyncMlReposClient] = None
        self._traces: typing.Optional[AsyncTracesClient] = None
        self._artifacts: typing.Optional[AsyncArtifactsClient] = None
        self._prompts: typing.Optional[AsyncPromptsClient] = None
        self._models: typing.Optional[AsyncModelsClient] = None
        self._artifact_versions: typing.Optional[AsyncArtifactVersionsClient] = None
        self._model_versions: typing.Optional[AsyncModelVersionsClient] = None
        self._prompt_versions: typing.Optional[AsyncPromptVersionsClient] = None
        self._data_directories: typing.Optional[AsyncDataDirectoriesClient] = None

    @property
    def with_raw_response(self) -> AsyncRawBaseTrueFoundry:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawBaseTrueFoundry
        """
        return self._raw_client

    async def apply(
        self,
        *,
        manifest: TrueFoundryApplyRequestManifest,
        dry_run: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TrueFoundryApplyResponse:
        """
        Applies a given manifest to create or update resources of specific types, such as provider-account, cluster, workspace, or ml-repo.

        Parameters
        ----------
        manifest : TrueFoundryApplyRequestManifest
            manifest of the resource to be created or updated

        dry_run : typing.Optional[bool]
            Dry run the apply operation without actually applying

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TrueFoundryApplyResponse
            The resource has been successfully created or updated.

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry, Collaborator, MlRepoManifest

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.apply(
                manifest=MlRepoManifest(
                    name="name",
                    storage_integration_fqn="storage_integration_fqn",
                    collaborators=[
                        Collaborator(
                            subject="subject",
                            role_id="role_id",
                        )
                    ],
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.apply(manifest=manifest, dry_run=dry_run, request_options=request_options)
        return _response.data

    async def delete(
        self, *, manifest: TrueFoundryDeleteRequestManifest, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Deletes resources of specific types, such as provider-account, cluster, workspace, or application.

        Parameters
        ----------
        manifest : TrueFoundryDeleteRequestManifest
            manifest of the resource to be deleted

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry, Collaborator, MlRepoManifest

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.delete(
                manifest=MlRepoManifest(
                    name="name",
                    storage_integration_fqn="storage_integration_fqn",
                    collaborators=[
                        Collaborator(
                            subject="subject",
                            role_id="role_id",
                        )
                    ],
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(manifest=manifest, request_options=request_options)
        return _response.data

    @property
    def internal(self):
        if self._internal is None:
            from .internal.client import AsyncInternalClient  # noqa: E402

            self._internal = AsyncInternalClient(client_wrapper=self._client_wrapper)
        return self._internal

    @property
    def users(self):
        if self._users is None:
            from .users.client import AsyncUsersClient  # noqa: E402

            self._users = AsyncUsersClient(client_wrapper=self._client_wrapper)
        return self._users

    @property
    def teams(self):
        if self._teams is None:
            from .teams.client import AsyncTeamsClient  # noqa: E402

            self._teams = AsyncTeamsClient(client_wrapper=self._client_wrapper)
        return self._teams

    @property
    def personal_access_tokens(self):
        if self._personal_access_tokens is None:
            from .personal_access_tokens.client import AsyncPersonalAccessTokensClient  # noqa: E402

            self._personal_access_tokens = AsyncPersonalAccessTokensClient(client_wrapper=self._client_wrapper)
        return self._personal_access_tokens

    @property
    def virtual_accounts(self):
        if self._virtual_accounts is None:
            from .virtual_accounts.client import AsyncVirtualAccountsClient  # noqa: E402

            self._virtual_accounts = AsyncVirtualAccountsClient(client_wrapper=self._client_wrapper)
        return self._virtual_accounts

    @property
    def secrets(self):
        if self._secrets is None:
            from .secrets.client import AsyncSecretsClient  # noqa: E402

            self._secrets = AsyncSecretsClient(client_wrapper=self._client_wrapper)
        return self._secrets

    @property
    def secret_groups(self):
        if self._secret_groups is None:
            from .secret_groups.client import AsyncSecretGroupsClient  # noqa: E402

            self._secret_groups = AsyncSecretGroupsClient(client_wrapper=self._client_wrapper)
        return self._secret_groups

    @property
    def clusters(self):
        if self._clusters is None:
            from .clusters.client import AsyncClustersClient  # noqa: E402

            self._clusters = AsyncClustersClient(client_wrapper=self._client_wrapper)
        return self._clusters

    @property
    def environments(self):
        if self._environments is None:
            from .environments.client import AsyncEnvironmentsClient  # noqa: E402

            self._environments = AsyncEnvironmentsClient(client_wrapper=self._client_wrapper)
        return self._environments

    @property
    def applications(self):
        if self._applications is None:
            from .applications.client import AsyncApplicationsClient  # noqa: E402

            self._applications = AsyncApplicationsClient(client_wrapper=self._client_wrapper)
        return self._applications

    @property
    def application_versions(self):
        if self._application_versions is None:
            from .application_versions.client import AsyncApplicationVersionsClient  # noqa: E402

            self._application_versions = AsyncApplicationVersionsClient(client_wrapper=self._client_wrapper)
        return self._application_versions

    @property
    def jobs(self):
        if self._jobs is None:
            from .jobs.client import AsyncJobsClient  # noqa: E402

            self._jobs = AsyncJobsClient(client_wrapper=self._client_wrapper)
        return self._jobs

    @property
    def workspaces(self):
        if self._workspaces is None:
            from .workspaces.client import AsyncWorkspacesClient  # noqa: E402

            self._workspaces = AsyncWorkspacesClient(client_wrapper=self._client_wrapper)
        return self._workspaces

    @property
    def events(self):
        if self._events is None:
            from .events.client import AsyncEventsClient  # noqa: E402

            self._events = AsyncEventsClient(client_wrapper=self._client_wrapper)
        return self._events

    @property
    def alerts(self):
        if self._alerts is None:
            from .alerts.client import AsyncAlertsClient  # noqa: E402

            self._alerts = AsyncAlertsClient(client_wrapper=self._client_wrapper)
        return self._alerts

    @property
    def logs(self):
        if self._logs is None:
            from .logs.client import AsyncLogsClient  # noqa: E402

            self._logs = AsyncLogsClient(client_wrapper=self._client_wrapper)
        return self._logs

    @property
    def ml_repos(self):
        if self._ml_repos is None:
            from .ml_repos.client import AsyncMlReposClient  # noqa: E402

            self._ml_repos = AsyncMlReposClient(client_wrapper=self._client_wrapper)
        return self._ml_repos

    @property
    def traces(self):
        if self._traces is None:
            from .traces.client import AsyncTracesClient  # noqa: E402

            self._traces = AsyncTracesClient(client_wrapper=self._client_wrapper)
        return self._traces

    @property
    def artifacts(self):
        if self._artifacts is None:
            from .artifacts.client import AsyncArtifactsClient  # noqa: E402

            self._artifacts = AsyncArtifactsClient(client_wrapper=self._client_wrapper)
        return self._artifacts

    @property
    def prompts(self):
        if self._prompts is None:
            from .prompts.client import AsyncPromptsClient  # noqa: E402

            self._prompts = AsyncPromptsClient(client_wrapper=self._client_wrapper)
        return self._prompts

    @property
    def models(self):
        if self._models is None:
            from .models.client import AsyncModelsClient  # noqa: E402

            self._models = AsyncModelsClient(client_wrapper=self._client_wrapper)
        return self._models

    @property
    def artifact_versions(self):
        if self._artifact_versions is None:
            from .artifact_versions.client import AsyncArtifactVersionsClient  # noqa: E402

            self._artifact_versions = AsyncArtifactVersionsClient(client_wrapper=self._client_wrapper)
        return self._artifact_versions

    @property
    def model_versions(self):
        if self._model_versions is None:
            from .model_versions.client import AsyncModelVersionsClient  # noqa: E402

            self._model_versions = AsyncModelVersionsClient(client_wrapper=self._client_wrapper)
        return self._model_versions

    @property
    def prompt_versions(self):
        if self._prompt_versions is None:
            from .prompt_versions.client import AsyncPromptVersionsClient  # noqa: E402

            self._prompt_versions = AsyncPromptVersionsClient(client_wrapper=self._client_wrapper)
        return self._prompt_versions

    @property
    def data_directories(self):
        if self._data_directories is None:
            from .data_directories.client import AsyncDataDirectoriesClient  # noqa: E402

            self._data_directories = AsyncDataDirectoriesClient(client_wrapper=self._client_wrapper)
        return self._data_directories
