# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.pagination import AsyncPager, SyncPager
from ..core.request_options import RequestOptions
from ..types.cluster import Cluster
from ..types.cluster_manifest import ClusterManifest
from ..types.get_cluster_response import GetClusterResponse
from ..types.is_cluster_connected_response import IsClusterConnectedResponse
from ..types.list_cluster_addons_response import ListClusterAddonsResponse
from .raw_client import AsyncRawClustersClient, RawClustersClient
from .types.clusters_delete_response import ClustersDeleteResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class ClustersClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawClustersClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawClustersClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawClustersClient
        """
        return self._raw_client

    def list(
        self,
        *,
        limit: typing.Optional[int] = 100,
        offset: typing.Optional[int] = 0,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[Cluster]:
        """
        Retrieves a list of all latest Clusters. Pagination is available based on query parameters.

        Parameters
        ----------
        limit : typing.Optional[int]
            Number of items per page

        offset : typing.Optional[int]
            Number of items to skip

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[Cluster]
            Retrieve latest Clusters. If pagination parameters are provided, the response includes paginated data.

        Examples
        --------
        from truefoundry_sdk import TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        response = client.clusters.list(
            limit=10,
            offset=0,
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(limit=limit, offset=offset, request_options=request_options)

    def create_or_update(
        self,
        *,
        manifest: ClusterManifest,
        dry_run: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetClusterResponse:
        """
        Create or Update cluster with provided manifest

        Parameters
        ----------
        manifest : ClusterManifest
            Cluster manifest

        dry_run : typing.Optional[bool]
            Dry run the cluster creation/update

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetClusterResponse
            Returns newly created/updated cluster on success

        Examples
        --------
        from truefoundry_sdk import (
            ClusterManifest,
            ClusterManifestClusterType,
            Collaborator,
            TrueFoundry,
        )

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.clusters.create_or_update(
            manifest=ClusterManifest(
                name="name",
                cluster_type=ClusterManifestClusterType.AWS_EKS,
                environment_names=["environment_names"],
                collaborators=[
                    Collaborator(
                        subject="subject",
                        role_id="role_id",
                    )
                ],
            ),
        )
        """
        _response = self._raw_client.create_or_update(
            manifest=manifest, dry_run=dry_run, request_options=request_options
        )
        return _response.data

    def get(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> GetClusterResponse:
        """
        Get cluster associated with provided id

        Parameters
        ----------
        id : str
            Cluster id of the cluster

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetClusterResponse
            Return the cluster associated with provided id

        Examples
        --------
        from truefoundry_sdk import TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.clusters.get(
            id="id",
        )
        """
        _response = self._raw_client.get(id, request_options=request_options)
        return _response.data

    def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> ClustersDeleteResponse:
        """
        Delete cluster associated with provided cluster id

        Parameters
        ----------
        id : str
            Cluster id of the cluster

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ClustersDeleteResponse
            Returns success message on successful deletion

        Examples
        --------
        from truefoundry_sdk import TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.clusters.delete(
            id="id",
        )
        """
        _response = self._raw_client.delete(id, request_options=request_options)
        return _response.data

    def get_addons(
        self,
        id: str,
        *,
        limit: typing.Optional[int] = 100,
        offset: typing.Optional[int] = 0,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ListClusterAddonsResponse:
        """
        List addons for the provided cluster. Pagination is available based on query parameters.

        Parameters
        ----------
        id : str
            Cluster id of the cluster

        limit : typing.Optional[int]
            Number of items per page

        offset : typing.Optional[int]
            Number of items to skip

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListClusterAddonsResponse
            Returns a paginated list of addons for the cluster

        Examples
        --------
        from truefoundry_sdk import TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.clusters.get_addons(
            id="id",
            limit=10,
            offset=0,
        )
        """
        _response = self._raw_client.get_addons(id, limit=limit, offset=offset, request_options=request_options)
        return _response.data

    def is_connected(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> IsClusterConnectedResponse:
        """
        Get the status of provided cluster

        Parameters
        ----------
        id : str
            Cluster id of the cluster

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        IsClusterConnectedResponse
            Returns the status of provided cluster

        Examples
        --------
        from truefoundry_sdk import TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.clusters.is_connected(
            id="id",
        )
        """
        _response = self._raw_client.is_connected(id, request_options=request_options)
        return _response.data


class AsyncClustersClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawClustersClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawClustersClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawClustersClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        limit: typing.Optional[int] = 100,
        offset: typing.Optional[int] = 0,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[Cluster]:
        """
        Retrieves a list of all latest Clusters. Pagination is available based on query parameters.

        Parameters
        ----------
        limit : typing.Optional[int]
            Number of items per page

        offset : typing.Optional[int]
            Number of items to skip

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[Cluster]
            Retrieve latest Clusters. If pagination parameters are provided, the response includes paginated data.

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            response = await client.clusters.list(
                limit=10,
                offset=0,
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(limit=limit, offset=offset, request_options=request_options)

    async def create_or_update(
        self,
        *,
        manifest: ClusterManifest,
        dry_run: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetClusterResponse:
        """
        Create or Update cluster with provided manifest

        Parameters
        ----------
        manifest : ClusterManifest
            Cluster manifest

        dry_run : typing.Optional[bool]
            Dry run the cluster creation/update

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetClusterResponse
            Returns newly created/updated cluster on success

        Examples
        --------
        import asyncio

        from truefoundry_sdk import (
            AsyncTrueFoundry,
            ClusterManifest,
            ClusterManifestClusterType,
            Collaborator,
        )

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.clusters.create_or_update(
                manifest=ClusterManifest(
                    name="name",
                    cluster_type=ClusterManifestClusterType.AWS_EKS,
                    environment_names=["environment_names"],
                    collaborators=[
                        Collaborator(
                            subject="subject",
                            role_id="role_id",
                        )
                    ],
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_or_update(
            manifest=manifest, dry_run=dry_run, request_options=request_options
        )
        return _response.data

    async def get(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> GetClusterResponse:
        """
        Get cluster associated with provided id

        Parameters
        ----------
        id : str
            Cluster id of the cluster

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetClusterResponse
            Return the cluster associated with provided id

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.clusters.get(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(id, request_options=request_options)
        return _response.data

    async def delete(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ClustersDeleteResponse:
        """
        Delete cluster associated with provided cluster id

        Parameters
        ----------
        id : str
            Cluster id of the cluster

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ClustersDeleteResponse
            Returns success message on successful deletion

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.clusters.delete(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(id, request_options=request_options)
        return _response.data

    async def get_addons(
        self,
        id: str,
        *,
        limit: typing.Optional[int] = 100,
        offset: typing.Optional[int] = 0,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ListClusterAddonsResponse:
        """
        List addons for the provided cluster. Pagination is available based on query parameters.

        Parameters
        ----------
        id : str
            Cluster id of the cluster

        limit : typing.Optional[int]
            Number of items per page

        offset : typing.Optional[int]
            Number of items to skip

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListClusterAddonsResponse
            Returns a paginated list of addons for the cluster

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.clusters.get_addons(
                id="id",
                limit=10,
                offset=0,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_addons(id, limit=limit, offset=offset, request_options=request_options)
        return _response.data

    async def is_connected(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> IsClusterConnectedResponse:
        """
        Get the status of provided cluster

        Parameters
        ----------
        id : str
            Cluster id of the cluster

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        IsClusterConnectedResponse
            Returns the status of provided cluster

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.clusters.is_connected(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.is_connected(id, request_options=request_options)
        return _response.data
