# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..errors.bad_request_error import BadRequestError
from ..errors.forbidden_error import ForbiddenError
from ..errors.not_found_error import NotFoundError
from ..types.get_events_response import GetEventsResponse
from ..types.http_error import HttpError


class RawEventsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def get(
        self,
        *,
        start_ts: typing.Optional[str] = None,
        end_ts: typing.Optional[str] = None,
        application_id: typing.Optional[str] = None,
        application_fqn: typing.Optional[str] = None,
        pod_names: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        job_run_name: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GetEventsResponse]:
        """
        Get Events for Pod, Job Run, Application. The events are sourced from Kubernetes as well as events captured by truefoundry. Optional query parameters include startTs, endTs for filtering.

        Parameters
        ----------
        start_ts : typing.Optional[str]
            Start timestamp (ISO format) for querying events

        end_ts : typing.Optional[str]
            End timestamp (ISO format) for querying events

        application_id : typing.Optional[str]
            Application ID

        application_fqn : typing.Optional[str]
            Application FQN

        pod_names : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Name of the pods

        job_run_name : typing.Optional[str]
            Job run name

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GetEventsResponse]
            Returns a list of events matching the query parameters.
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/svc/v1/events",
            method="GET",
            params={
                "startTs": start_ts,
                "endTs": end_ts,
                "applicationId": application_id,
                "applicationFqn": application_fqn,
                "podNames": pod_names,
                "jobRunName": job_run_name,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetEventsResponse,
                    parse_obj_as(
                        type_=GetEventsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpError,
                        parse_obj_as(
                            type_=HttpError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawEventsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def get(
        self,
        *,
        start_ts: typing.Optional[str] = None,
        end_ts: typing.Optional[str] = None,
        application_id: typing.Optional[str] = None,
        application_fqn: typing.Optional[str] = None,
        pod_names: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        job_run_name: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GetEventsResponse]:
        """
        Get Events for Pod, Job Run, Application. The events are sourced from Kubernetes as well as events captured by truefoundry. Optional query parameters include startTs, endTs for filtering.

        Parameters
        ----------
        start_ts : typing.Optional[str]
            Start timestamp (ISO format) for querying events

        end_ts : typing.Optional[str]
            End timestamp (ISO format) for querying events

        application_id : typing.Optional[str]
            Application ID

        application_fqn : typing.Optional[str]
            Application FQN

        pod_names : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Name of the pods

        job_run_name : typing.Optional[str]
            Job run name

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GetEventsResponse]
            Returns a list of events matching the query parameters.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/svc/v1/events",
            method="GET",
            params={
                "startTs": start_ts,
                "endTs": end_ts,
                "applicationId": application_id,
                "applicationFqn": application_fqn,
                "podNames": pod_names,
                "jobRunName": job_run_name,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetEventsResponse,
                    parse_obj_as(
                        type_=GetEventsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpError,
                        parse_obj_as(
                            type_=HttpError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
