# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.pagination import AsyncPager, SyncPager
from ...core.request_options import RequestOptions
from ...types.internal_list_artifact_versions_response_data_item import InternalListArtifactVersionsResponseDataItem
from .raw_client import AsyncRawArtifactVersionsClient, RawArtifactVersionsClient


class ArtifactVersionsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawArtifactVersionsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawArtifactVersionsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawArtifactVersionsClient
        """
        return self._raw_client

    def list(
        self,
        *,
        tag: typing.Optional[str] = None,
        fqn: typing.Optional[str] = None,
        artifact_id: typing.Optional[str] = None,
        ml_repo_id: typing.Optional[str] = None,
        name: typing.Optional[str] = None,
        version: typing.Optional[int] = None,
        run_ids: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        run_steps: typing.Optional[typing.Union[int, typing.Sequence[int]]] = None,
        offset: typing.Optional[int] = 0,
        limit: typing.Optional[int] = 100,
        include_internal_metadata: typing.Optional[bool] = False,
        include_model_versions: typing.Optional[bool] = False,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[InternalListArtifactVersionsResponseDataItem]:
        """
        List artifact version API

        Parameters
        ----------
        tag : typing.Optional[str]

        fqn : typing.Optional[str]

        artifact_id : typing.Optional[str]

        ml_repo_id : typing.Optional[str]

        name : typing.Optional[str]

        version : typing.Optional[int]

        run_ids : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        run_steps : typing.Optional[typing.Union[int, typing.Sequence[int]]]

        offset : typing.Optional[int]

        limit : typing.Optional[int]

        include_internal_metadata : typing.Optional[bool]

        include_model_versions : typing.Optional[bool]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[InternalListArtifactVersionsResponseDataItem]
            Successful Response

        Examples
        --------
        from truefoundry_sdk import TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        response = client.internal.artifact_versions.list(
            tag="tag",
            fqn="fqn",
            artifact_id="artifact_id",
            ml_repo_id="ml_repo_id",
            name="name",
            version=1,
            offset=1,
            limit=1,
            include_internal_metadata=True,
            include_model_versions=True,
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(
            tag=tag,
            fqn=fqn,
            artifact_id=artifact_id,
            ml_repo_id=ml_repo_id,
            name=name,
            version=version,
            run_ids=run_ids,
            run_steps=run_steps,
            offset=offset,
            limit=limit,
            include_internal_metadata=include_internal_metadata,
            include_model_versions=include_model_versions,
            request_options=request_options,
        )


class AsyncArtifactVersionsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawArtifactVersionsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawArtifactVersionsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawArtifactVersionsClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        tag: typing.Optional[str] = None,
        fqn: typing.Optional[str] = None,
        artifact_id: typing.Optional[str] = None,
        ml_repo_id: typing.Optional[str] = None,
        name: typing.Optional[str] = None,
        version: typing.Optional[int] = None,
        run_ids: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        run_steps: typing.Optional[typing.Union[int, typing.Sequence[int]]] = None,
        offset: typing.Optional[int] = 0,
        limit: typing.Optional[int] = 100,
        include_internal_metadata: typing.Optional[bool] = False,
        include_model_versions: typing.Optional[bool] = False,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[InternalListArtifactVersionsResponseDataItem]:
        """
        List artifact version API

        Parameters
        ----------
        tag : typing.Optional[str]

        fqn : typing.Optional[str]

        artifact_id : typing.Optional[str]

        ml_repo_id : typing.Optional[str]

        name : typing.Optional[str]

        version : typing.Optional[int]

        run_ids : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        run_steps : typing.Optional[typing.Union[int, typing.Sequence[int]]]

        offset : typing.Optional[int]

        limit : typing.Optional[int]

        include_internal_metadata : typing.Optional[bool]

        include_model_versions : typing.Optional[bool]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[InternalListArtifactVersionsResponseDataItem]
            Successful Response

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            response = await client.internal.artifact_versions.list(
                tag="tag",
                fqn="fqn",
                artifact_id="artifact_id",
                ml_repo_id="ml_repo_id",
                name="name",
                version=1,
                offset=1,
                limit=1,
                include_internal_metadata=True,
                include_model_versions=True,
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(
            tag=tag,
            fqn=fqn,
            artifact_id=artifact_id,
            ml_repo_id=ml_repo_id,
            name=name,
            version=version,
            run_ids=run_ids,
            run_steps=run_steps,
            offset=offset,
            limit=limit,
            include_internal_metadata=include_internal_metadata,
            include_model_versions=include_model_versions,
            request_options=request_options,
        )
