# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.pagination import AsyncPager, BaseHttpResponse, SyncPager
from ...core.pydantic_utilities import parse_obj_as
from ...core.request_options import RequestOptions
from ...errors.unprocessable_entity_error import UnprocessableEntityError
from ...types.internal_list_artifact_versions_response import InternalListArtifactVersionsResponse
from ...types.internal_list_artifact_versions_response_data_item import InternalListArtifactVersionsResponseDataItem


class RawArtifactVersionsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list(
        self,
        *,
        tag: typing.Optional[str] = None,
        fqn: typing.Optional[str] = None,
        artifact_id: typing.Optional[str] = None,
        ml_repo_id: typing.Optional[str] = None,
        name: typing.Optional[str] = None,
        version: typing.Optional[int] = None,
        run_ids: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        run_steps: typing.Optional[typing.Union[int, typing.Sequence[int]]] = None,
        offset: typing.Optional[int] = 0,
        limit: typing.Optional[int] = 100,
        include_internal_metadata: typing.Optional[bool] = False,
        include_model_versions: typing.Optional[bool] = False,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[InternalListArtifactVersionsResponseDataItem]:
        """
        List artifact version API

        Parameters
        ----------
        tag : typing.Optional[str]

        fqn : typing.Optional[str]

        artifact_id : typing.Optional[str]

        ml_repo_id : typing.Optional[str]

        name : typing.Optional[str]

        version : typing.Optional[int]

        run_ids : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        run_steps : typing.Optional[typing.Union[int, typing.Sequence[int]]]

        offset : typing.Optional[int]

        limit : typing.Optional[int]

        include_internal_metadata : typing.Optional[bool]

        include_model_versions : typing.Optional[bool]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[InternalListArtifactVersionsResponseDataItem]
            Successful Response
        """
        offset = offset if offset is not None else 0

        _response = self._client_wrapper.httpx_client.request(
            "api/ml/v1/x/artifact-versions",
            method="GET",
            params={
                "tag": tag,
                "fqn": fqn,
                "artifact_id": artifact_id,
                "ml_repo_id": ml_repo_id,
                "name": name,
                "version": version,
                "run_ids": run_ids,
                "run_steps": run_steps,
                "offset": offset,
                "limit": limit,
                "include_internal_metadata": include_internal_metadata,
                "include_model_versions": include_model_versions,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _parsed_response = typing.cast(
                    InternalListArtifactVersionsResponse,
                    parse_obj_as(
                        type_=InternalListArtifactVersionsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                _items = _parsed_response.data
                _has_next = True
                _get_next = lambda: self.list(
                    tag=tag,
                    fqn=fqn,
                    artifact_id=artifact_id,
                    ml_repo_id=ml_repo_id,
                    name=name,
                    version=version,
                    run_ids=run_ids,
                    run_steps=run_steps,
                    offset=offset + len(_items),
                    limit=limit,
                    include_internal_metadata=include_internal_metadata,
                    include_model_versions=include_model_versions,
                    request_options=request_options,
                )
                return SyncPager(
                    has_next=_has_next, items=_items, get_next=_get_next, response=BaseHttpResponse(response=_response)
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawArtifactVersionsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list(
        self,
        *,
        tag: typing.Optional[str] = None,
        fqn: typing.Optional[str] = None,
        artifact_id: typing.Optional[str] = None,
        ml_repo_id: typing.Optional[str] = None,
        name: typing.Optional[str] = None,
        version: typing.Optional[int] = None,
        run_ids: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        run_steps: typing.Optional[typing.Union[int, typing.Sequence[int]]] = None,
        offset: typing.Optional[int] = 0,
        limit: typing.Optional[int] = 100,
        include_internal_metadata: typing.Optional[bool] = False,
        include_model_versions: typing.Optional[bool] = False,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[InternalListArtifactVersionsResponseDataItem]:
        """
        List artifact version API

        Parameters
        ----------
        tag : typing.Optional[str]

        fqn : typing.Optional[str]

        artifact_id : typing.Optional[str]

        ml_repo_id : typing.Optional[str]

        name : typing.Optional[str]

        version : typing.Optional[int]

        run_ids : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        run_steps : typing.Optional[typing.Union[int, typing.Sequence[int]]]

        offset : typing.Optional[int]

        limit : typing.Optional[int]

        include_internal_metadata : typing.Optional[bool]

        include_model_versions : typing.Optional[bool]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[InternalListArtifactVersionsResponseDataItem]
            Successful Response
        """
        offset = offset if offset is not None else 0

        _response = await self._client_wrapper.httpx_client.request(
            "api/ml/v1/x/artifact-versions",
            method="GET",
            params={
                "tag": tag,
                "fqn": fqn,
                "artifact_id": artifact_id,
                "ml_repo_id": ml_repo_id,
                "name": name,
                "version": version,
                "run_ids": run_ids,
                "run_steps": run_steps,
                "offset": offset,
                "limit": limit,
                "include_internal_metadata": include_internal_metadata,
                "include_model_versions": include_model_versions,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _parsed_response = typing.cast(
                    InternalListArtifactVersionsResponse,
                    parse_obj_as(
                        type_=InternalListArtifactVersionsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                _items = _parsed_response.data
                _has_next = True

                async def _get_next():
                    return await self.list(
                        tag=tag,
                        fqn=fqn,
                        artifact_id=artifact_id,
                        ml_repo_id=ml_repo_id,
                        name=name,
                        version=version,
                        run_ids=run_ids,
                        run_steps=run_steps,
                        offset=offset + len(_items),
                        limit=limit,
                        include_internal_metadata=include_internal_metadata,
                        include_model_versions=include_model_versions,
                        request_options=request_options,
                    )

                return AsyncPager(
                    has_next=_has_next, items=_items, get_next=_get_next, response=BaseHttpResponse(response=_response)
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
