# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.http_response import AsyncHttpResponse, HttpResponse
from ...core.jsonable_encoder import jsonable_encoder
from ...core.pydantic_utilities import parse_obj_as
from ...core.request_options import RequestOptions
from ...errors.bad_request_error import BadRequestError
from ...errors.method_not_allowed_error import MethodNotAllowedError
from ...errors.not_found_error import NotFoundError
from ...types.get_charts_response import GetChartsResponse
from .types.metrics_get_charts_request_filter_entity import MetricsGetChartsRequestFilterEntity


class RawMetricsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def get_charts(
        self,
        workspace_id: str,
        *,
        application_id: str,
        filter_entity: MetricsGetChartsRequestFilterEntity,
        start_ts: typing.Optional[str] = None,
        end_ts: typing.Optional[str] = None,
        filter_query: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GetChartsResponse]:
        """
        List charts for a given Application based on parameters passed in the query.

        Parameters
        ----------
        workspace_id : str

        application_id : str

        filter_entity : MetricsGetChartsRequestFilterEntity

        start_ts : typing.Optional[str]
            Start Timestamp

        end_ts : typing.Optional[str]
            End Timestamp

        filter_query : typing.Optional[str]
            Query params to filter metrics

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GetChartsResponse]
            Charts have been successfully retrieved.
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/svc/v1/metrics/{jsonable_encoder(workspace_id)}/charts",
            method="GET",
            params={
                "applicationId": application_id,
                "startTs": start_ts,
                "endTs": end_ts,
                "filterEntity": filter_entity,
                "filterQuery": filter_query,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetChartsResponse,
                    parse_obj_as(
                        type_=GetChartsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 405:
                raise MethodNotAllowedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawMetricsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def get_charts(
        self,
        workspace_id: str,
        *,
        application_id: str,
        filter_entity: MetricsGetChartsRequestFilterEntity,
        start_ts: typing.Optional[str] = None,
        end_ts: typing.Optional[str] = None,
        filter_query: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GetChartsResponse]:
        """
        List charts for a given Application based on parameters passed in the query.

        Parameters
        ----------
        workspace_id : str

        application_id : str

        filter_entity : MetricsGetChartsRequestFilterEntity

        start_ts : typing.Optional[str]
            Start Timestamp

        end_ts : typing.Optional[str]
            End Timestamp

        filter_query : typing.Optional[str]
            Query params to filter metrics

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GetChartsResponse]
            Charts have been successfully retrieved.
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/svc/v1/metrics/{jsonable_encoder(workspace_id)}/charts",
            method="GET",
            params={
                "applicationId": application_id,
                "startTs": start_ts,
                "endTs": end_ts,
                "filterEntity": filter_entity,
                "filterQuery": filter_query,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetChartsResponse,
                    parse_obj_as(
                        type_=GetChartsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 405:
                raise MethodNotAllowedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
