# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.http_response import AsyncHttpResponse, HttpResponse
from ...core.pydantic_utilities import parse_obj_as
from ...core.request_options import RequestOptions
from ...types.get_authenticated_vcsurl_response import GetAuthenticatedVcsurlResponse
from ...types.git_repository_exists_response import GitRepositoryExistsResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawVcsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def get_repository_details(
        self, *, repo_url: str, id: typing.Optional[str] = OMIT, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[GitRepositoryExistsResponse]:
        """
        Parameters
        ----------
        repo_url : str
            The URL of the repository

        id : typing.Optional[str]
            The integration id of the repository

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GitRepositoryExistsResponse]
            Returns git repository details if git repository exists and is accessible
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/svc/v1/vcs/repository/details",
            method="POST",
            json={
                "repoURL": repo_url,
                "id": id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GitRepositoryExistsResponse,
                    parse_obj_as(
                        type_=GitRepositoryExistsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_authenticated_url(
        self, *, repo_url: str, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[GetAuthenticatedVcsurlResponse]:
        """
        Parameters
        ----------
        repo_url : str
            Repository URL (e.g., https://github.com/user/repo, https://bitbucket.org/user/repo)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GetAuthenticatedVcsurlResponse]
            Returns an authenticated VCS URL for the repository
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/svc/v1/vcs/repository/authenticated-url",
            method="POST",
            json={
                "repoURL": repo_url,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetAuthenticatedVcsurlResponse,
                    parse_obj_as(
                        type_=GetAuthenticatedVcsurlResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawVcsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def get_repository_details(
        self, *, repo_url: str, id: typing.Optional[str] = OMIT, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[GitRepositoryExistsResponse]:
        """
        Parameters
        ----------
        repo_url : str
            The URL of the repository

        id : typing.Optional[str]
            The integration id of the repository

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GitRepositoryExistsResponse]
            Returns git repository details if git repository exists and is accessible
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/svc/v1/vcs/repository/details",
            method="POST",
            json={
                "repoURL": repo_url,
                "id": id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GitRepositoryExistsResponse,
                    parse_obj_as(
                        type_=GitRepositoryExistsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_authenticated_url(
        self, *, repo_url: str, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[GetAuthenticatedVcsurlResponse]:
        """
        Parameters
        ----------
        repo_url : str
            Repository URL (e.g., https://github.com/user/repo, https://bitbucket.org/user/repo)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GetAuthenticatedVcsurlResponse]
            Returns an authenticated VCS URL for the repository
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/svc/v1/vcs/repository/authenticated-url",
            method="POST",
            json={
                "repoURL": repo_url,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetAuthenticatedVcsurlResponse,
                    parse_obj_as(
                        type_=GetAuthenticatedVcsurlResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
