# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.http_response import AsyncHttpResponse, HttpResponse
from ...core.jsonable_encoder import jsonable_encoder
from ...core.pydantic_utilities import parse_obj_as
from ...core.request_options import RequestOptions
from ...errors.bad_request_error import BadRequestError
from ...errors.not_found_error import NotFoundError
from .types.workflows_execute_workflow_response import WorkflowsExecuteWorkflowResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawWorkflowsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def execute_workflow(
        self,
        application_id: str,
        *,
        inputs: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        inputs_literal_map: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[WorkflowsExecuteWorkflowResponse]:
        """
        Execute a workflow for the specified application

        Parameters
        ----------
        application_id : str
            Id of the application

        inputs : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            Workflow inputs

        inputs_literal_map : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            Workflow inputs literal map

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[WorkflowsExecuteWorkflowResponse]
            Returns execution name of the workflow
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/svc/v1/workflow/{jsonable_encoder(application_id)}/executions",
            method="POST",
            json={
                "inputs": inputs,
                "inputsLiteralMap": inputs_literal_map,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    WorkflowsExecuteWorkflowResponse,
                    parse_obj_as(
                        type_=WorkflowsExecuteWorkflowResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawWorkflowsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def execute_workflow(
        self,
        application_id: str,
        *,
        inputs: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        inputs_literal_map: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[WorkflowsExecuteWorkflowResponse]:
        """
        Execute a workflow for the specified application

        Parameters
        ----------
        application_id : str
            Id of the application

        inputs : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            Workflow inputs

        inputs_literal_map : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            Workflow inputs literal map

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[WorkflowsExecuteWorkflowResponse]
            Returns execution name of the workflow
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/svc/v1/workflow/{jsonable_encoder(application_id)}/executions",
            method="POST",
            json={
                "inputs": inputs,
                "inputsLiteralMap": inputs_literal_map,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    WorkflowsExecuteWorkflowResponse,
                    parse_obj_as(
                        type_=WorkflowsExecuteWorkflowResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
