# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.pagination import AsyncPager, SyncPager
from ..core.request_options import RequestOptions
from ..types.empty_response import EmptyResponse
from ..types.get_ml_repo_response import GetMlRepoResponse
from ..types.ml_repo import MlRepo
from ..types.ml_repo_manifest import MlRepoManifest
from .raw_client import AsyncRawMlReposClient, RawMlReposClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class MlReposClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawMlReposClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawMlReposClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawMlReposClient
        """
        return self._raw_client

    def create_or_update(
        self, *, manifest: MlRepoManifest, request_options: typing.Optional[RequestOptions] = None
    ) -> GetMlRepoResponse:
        """
        Creates or updates an MLRepo entity based on the provided manifest.

        Parameters
        ----------
        manifest : MlRepoManifest
            MLRepo manifest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetMlRepoResponse
            Returns the created or updated MLRepo entity based on the provided manifest.

        Examples
        --------
        from truefoundry_sdk import Collaborator, MlRepoManifest, TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.ml_repos.create_or_update(
            manifest=MlRepoManifest(
                name="name",
                storage_integration_fqn="storage_integration_fqn",
                collaborators=[
                    Collaborator(
                        subject="subject",
                        role_id="role_id",
                    )
                ],
            ),
        )
        """
        _response = self._raw_client.create_or_update(manifest=manifest, request_options=request_options)
        return _response.data

    def get(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> GetMlRepoResponse:
        """
        Get a ml repo by id
        Args:
            id: Unique identifier of the ml repo to get
            user_info: Authenticated user information

        Returns:
            GetMLRepoResponse: The ml repo

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetMlRepoResponse
            Successful Response

        Examples
        --------
        from truefoundry_sdk import TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.ml_repos.get(
            id="id",
        )
        """
        _response = self._raw_client.get(id, request_options=request_options)
        return _response.data

    def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> EmptyResponse:
        """
        Delete a ml repo
        Args:
            id: Unique identifier of the ml repo to delete
            user_info: Authenticated user information

        Returns:
            EmptyResponse: Empty response indicating successful deletion

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EmptyResponse
            Successful Response

        Examples
        --------
        from truefoundry_sdk import TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.ml_repos.delete(
            id="id",
        )
        """
        _response = self._raw_client.delete(id, request_options=request_options)
        return _response.data

    def list(
        self,
        *,
        name: typing.Optional[str] = None,
        limit: typing.Optional[int] = 100,
        offset: typing.Optional[int] = 0,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[MlRepo]:
        """
        List ml repos
        Args:
            filters: Filters for the ml repos
            user_info: Authenticated user information

        Returns:
            ListMLReposResponse: List of ml repos

        Parameters
        ----------
        name : typing.Optional[str]

        limit : typing.Optional[int]

        offset : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[MlRepo]
            Successful Response

        Examples
        --------
        from truefoundry_sdk import TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        response = client.ml_repos.list(
            name="name",
            limit=1,
            offset=1,
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(name=name, limit=limit, offset=offset, request_options=request_options)


class AsyncMlReposClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawMlReposClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawMlReposClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawMlReposClient
        """
        return self._raw_client

    async def create_or_update(
        self, *, manifest: MlRepoManifest, request_options: typing.Optional[RequestOptions] = None
    ) -> GetMlRepoResponse:
        """
        Creates or updates an MLRepo entity based on the provided manifest.

        Parameters
        ----------
        manifest : MlRepoManifest
            MLRepo manifest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetMlRepoResponse
            Returns the created or updated MLRepo entity based on the provided manifest.

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry, Collaborator, MlRepoManifest

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.ml_repos.create_or_update(
                manifest=MlRepoManifest(
                    name="name",
                    storage_integration_fqn="storage_integration_fqn",
                    collaborators=[
                        Collaborator(
                            subject="subject",
                            role_id="role_id",
                        )
                    ],
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_or_update(manifest=manifest, request_options=request_options)
        return _response.data

    async def get(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> GetMlRepoResponse:
        """
        Get a ml repo by id
        Args:
            id: Unique identifier of the ml repo to get
            user_info: Authenticated user information

        Returns:
            GetMLRepoResponse: The ml repo

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetMlRepoResponse
            Successful Response

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.ml_repos.get(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(id, request_options=request_options)
        return _response.data

    async def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> EmptyResponse:
        """
        Delete a ml repo
        Args:
            id: Unique identifier of the ml repo to delete
            user_info: Authenticated user information

        Returns:
            EmptyResponse: Empty response indicating successful deletion

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EmptyResponse
            Successful Response

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.ml_repos.delete(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(id, request_options=request_options)
        return _response.data

    async def list(
        self,
        *,
        name: typing.Optional[str] = None,
        limit: typing.Optional[int] = 100,
        offset: typing.Optional[int] = 0,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[MlRepo]:
        """
        List ml repos
        Args:
            filters: Filters for the ml repos
            user_info: Authenticated user information

        Returns:
            ListMLReposResponse: List of ml repos

        Parameters
        ----------
        name : typing.Optional[str]

        limit : typing.Optional[int]

        offset : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[MlRepo]
            Successful Response

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            response = await client.ml_repos.list(
                name="name",
                limit=1,
                offset=1,
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(name=name, limit=limit, offset=offset, request_options=request_options)
