# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.pagination import AsyncPager, SyncPager
from ..core.request_options import RequestOptions
from ..types.sort_direction import SortDirection
from ..types.subject_type import SubjectType
from ..types.trace_span import TraceSpan
from .raw_client import AsyncRawTracesClient, RawTracesClient
from .types.query_spans_request_filters_item import QuerySpansRequestFiltersItem

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class TracesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawTracesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawTracesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawTracesClient
        """
        return self._raw_client

    def query_spans(
        self,
        *,
        start_time: str,
        tracing_project_fqn: str,
        end_time: typing.Optional[str] = OMIT,
        trace_ids: typing.Optional[typing.Sequence[str]] = OMIT,
        span_ids: typing.Optional[typing.Sequence[str]] = OMIT,
        parent_span_ids: typing.Optional[typing.Sequence[str]] = OMIT,
        created_by_subject_types: typing.Optional[typing.Sequence[SubjectType]] = OMIT,
        created_by_subject_slugs: typing.Optional[typing.Sequence[str]] = OMIT,
        application_names: typing.Optional[typing.Sequence[str]] = OMIT,
        limit: typing.Optional[int] = OMIT,
        sort_direction: typing.Optional[SortDirection] = OMIT,
        page_token: typing.Optional[str] = OMIT,
        filters: typing.Optional[typing.Sequence[QuerySpansRequestFiltersItem]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[TraceSpan]:
        """
        Parameters
        ----------
        start_time : str
            Start time in ISO 8601 format (e.g., 2025-03-12T00:00:09.872Z)

        tracing_project_fqn : str
            Tracing project FQN (e.g., truefoundry:tracing-project:tfy-default)

        end_time : typing.Optional[str]
            End time in ISO 8601 format (e.g., 2025-03-12T00:10:00.000Z). Defaults to current time if not provided.

        trace_ids : typing.Optional[typing.Sequence[str]]
            Array of trace IDs to filter by

        span_ids : typing.Optional[typing.Sequence[str]]
            Array of span IDs to filter by

        parent_span_ids : typing.Optional[typing.Sequence[str]]
            Array of parent span IDs to filter by

        created_by_subject_types : typing.Optional[typing.Sequence[SubjectType]]
            Array of subject types to filter by

        created_by_subject_slugs : typing.Optional[typing.Sequence[str]]
            Array of subject slugs to filter by

        application_names : typing.Optional[typing.Sequence[str]]
            Array of application names to filter by

        limit : typing.Optional[int]
            The maximum number of spans to return per page. Defaults to 200 if not provided.

        sort_direction : typing.Optional[SortDirection]
            Sort direction for results based on time. Defaults to descending (latest first)

        page_token : typing.Optional[str]
            An opaque string that should be passed as-is from previous response for fetching the next page. Pass `$response.pagination.nextPageToken` from previous response for fetching the next page.

        filters : typing.Optional[typing.Sequence[QuerySpansRequestFiltersItem]]
            Array of filters

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[TraceSpan]
            Returns all the spans matching the query.

        Examples
        --------
        from truefoundry_sdk import TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        response = client.traces.query_spans(
            start_time="startTime",
            tracing_project_fqn="tracingProjectFqn",
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.query_spans(
            start_time=start_time,
            tracing_project_fqn=tracing_project_fqn,
            end_time=end_time,
            trace_ids=trace_ids,
            span_ids=span_ids,
            parent_span_ids=parent_span_ids,
            created_by_subject_types=created_by_subject_types,
            created_by_subject_slugs=created_by_subject_slugs,
            application_names=application_names,
            limit=limit,
            sort_direction=sort_direction,
            page_token=page_token,
            filters=filters,
            request_options=request_options,
        )


class AsyncTracesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawTracesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawTracesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawTracesClient
        """
        return self._raw_client

    async def query_spans(
        self,
        *,
        start_time: str,
        tracing_project_fqn: str,
        end_time: typing.Optional[str] = OMIT,
        trace_ids: typing.Optional[typing.Sequence[str]] = OMIT,
        span_ids: typing.Optional[typing.Sequence[str]] = OMIT,
        parent_span_ids: typing.Optional[typing.Sequence[str]] = OMIT,
        created_by_subject_types: typing.Optional[typing.Sequence[SubjectType]] = OMIT,
        created_by_subject_slugs: typing.Optional[typing.Sequence[str]] = OMIT,
        application_names: typing.Optional[typing.Sequence[str]] = OMIT,
        limit: typing.Optional[int] = OMIT,
        sort_direction: typing.Optional[SortDirection] = OMIT,
        page_token: typing.Optional[str] = OMIT,
        filters: typing.Optional[typing.Sequence[QuerySpansRequestFiltersItem]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[TraceSpan]:
        """
        Parameters
        ----------
        start_time : str
            Start time in ISO 8601 format (e.g., 2025-03-12T00:00:09.872Z)

        tracing_project_fqn : str
            Tracing project FQN (e.g., truefoundry:tracing-project:tfy-default)

        end_time : typing.Optional[str]
            End time in ISO 8601 format (e.g., 2025-03-12T00:10:00.000Z). Defaults to current time if not provided.

        trace_ids : typing.Optional[typing.Sequence[str]]
            Array of trace IDs to filter by

        span_ids : typing.Optional[typing.Sequence[str]]
            Array of span IDs to filter by

        parent_span_ids : typing.Optional[typing.Sequence[str]]
            Array of parent span IDs to filter by

        created_by_subject_types : typing.Optional[typing.Sequence[SubjectType]]
            Array of subject types to filter by

        created_by_subject_slugs : typing.Optional[typing.Sequence[str]]
            Array of subject slugs to filter by

        application_names : typing.Optional[typing.Sequence[str]]
            Array of application names to filter by

        limit : typing.Optional[int]
            The maximum number of spans to return per page. Defaults to 200 if not provided.

        sort_direction : typing.Optional[SortDirection]
            Sort direction for results based on time. Defaults to descending (latest first)

        page_token : typing.Optional[str]
            An opaque string that should be passed as-is from previous response for fetching the next page. Pass `$response.pagination.nextPageToken` from previous response for fetching the next page.

        filters : typing.Optional[typing.Sequence[QuerySpansRequestFiltersItem]]
            Array of filters

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[TraceSpan]
            Returns all the spans matching the query.

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            response = await client.traces.query_spans(
                start_time="startTime",
                tracing_project_fqn="tracingProjectFqn",
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.query_spans(
            start_time=start_time,
            tracing_project_fqn=tracing_project_fqn,
            end_time=end_time,
            trace_ids=trace_ids,
            span_ids=span_ids,
            parent_span_ids=parent_span_ids,
            created_by_subject_types=created_by_subject_types,
            created_by_subject_slugs=created_by_subject_slugs,
            application_names=application_names,
            limit=limit,
            sort_direction=sort_direction,
            page_token=page_token,
            filters=filters,
            request_options=request_options,
        )
