# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .ai21integrations import Ai21Integrations
from .ai21key_auth import Ai21KeyAuth
from .collaborator import Collaborator
from .owned_by import OwnedBy


class Ai21ProviderAccount(UniversalBaseModel):
    """
    AI21
    """

    type: typing.Literal["provider-account/ai21"] = pydantic.Field(default="provider-account/ai21")
    """
    +value=provider-account/ai21
    """

    name: str = pydantic.Field()
    """
    The name of the AI21 provider account
    """

    auth_data: Ai21KeyAuth
    integrations: typing.Optional[typing.List[Ai21Integrations]] = pydantic.Field(default=None)
    """
    List of integrations that are associated with the AI21 provider account
    """

    collaborators: typing.Optional[typing.List[Collaborator]] = pydantic.Field(default=None)
    """
    List of users who have access to this provider account
    """

    owned_by: typing_extensions.Annotated[typing.Optional[OwnedBy], FieldMetadata(alias="ownedBy")] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
