# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .alert_config_resource import AlertConfigResource
from .notification_target_for_alert_rule import NotificationTargetForAlertRule
from .prometheus_alert_rule import PrometheusAlertRule


class AlertConfig(UniversalBaseModel):
    type: typing.Literal["alert-config"] = pydantic.Field(default="alert-config")
    """
    Type
    """

    name: str = pydantic.Field()
    """
    Name - 3 to 35 lower case characters long alphanumeric word, may contain - in between, cannot start with a number
    """

    resource: AlertConfigResource
    notification_targets: typing.List[NotificationTargetForAlertRule] = pydantic.Field()
    """
    Configure one or more notification targets where alerts will be sent. Each target specifies a notification channel (email or slack).
    """

    rules: typing.List[PrometheusAlertRule] = pydantic.Field()
    """
    Define one or more alert rules that specify the conditions to monitor, when to trigger alerts, and how they should be handled.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
