# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class AmqpInputConfig(UniversalBaseModel):
    """
    Describes the configuration for the input AMQP worker
    """

    type: typing.Literal["amqp"] = pydantic.Field(default="amqp")
    """
    +value=amqp
    """

    url: str = pydantic.Field()
    """
    AMQP Queue URL of Subscriber
    """

    queue_name: str = pydantic.Field()
    """
    AMQP Queue Name
    """

    wait_time_seconds: int = pydantic.Field(default=5)
    """
    Wait timeout for long polling.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
