# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class AmqpOutputConfig(UniversalBaseModel):
    """
    Describes the configuration for the output AMQP worker
    """

    type: typing.Literal["amqp"] = pydantic.Field(default="amqp")
    """
    +value=amqp
    """

    url: str = pydantic.Field()
    """
    AMQP Queue URL of Publisher
    """

    routing_key: str = pydantic.Field()
    """
    AMQP Routing Key to publish to.
    """

    exchange_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    AMQP Exchange Name
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
