# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .anthropic_integrations import AnthropicIntegrations
from .anthropic_key_auth import AnthropicKeyAuth
from .collaborator import Collaborator
from .owned_by import OwnedBy


class AnthropicProviderAccount(UniversalBaseModel):
    """
    Anthropic
    """

    type: typing.Literal["provider-account/anthropic"] = pydantic.Field(default="provider-account/anthropic")
    """
    +value=provider-account/anthropic
    """

    name: str = pydantic.Field()
    """
    The name of the Anthropic provider account
    """

    auth_data: AnthropicKeyAuth
    integrations: typing.Optional[typing.List[AnthropicIntegrations]] = pydantic.Field(default=None)
    """
    List of integrations that are associated with the Anthropic provider account
    """

    collaborators: typing.Optional[typing.List[Collaborator]] = pydantic.Field(default=None)
    """
    List of users who have access to this provider account
    """

    owned_by: typing_extensions.Annotated[typing.Optional[OwnedBy], FieldMetadata(alias="ownedBy")] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
