# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .application_set_components_item import ApplicationSetComponentsItem


class ApplicationSet(UniversalBaseModel):
    """
    Describes the configuration for the application set
    """

    type: typing.Literal["application-set"] = pydantic.Field(default="application-set")
    """
    +value=application-set
    """

    name: str = pydantic.Field()
    """
    Name of the application set.
    """

    components: typing.Optional[typing.List[ApplicationSetComponentsItem]] = pydantic.Field(default=None)
    """
    Array of components with their specifications.
    """

    template: typing.Optional[str] = pydantic.Field(default=None)
    """
    Template to be used for the application set.
    """

    values: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    Values to be used to render components for the application set.
    """

    workspace_fqn: typing.Optional[str] = pydantic.Field(default=None)
    """
    Fully qualified name of the workspace
    """

    convert_template_manifest: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Flag to indicate if the template manifest should be converted to TrueFoundry manifest
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
