# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .assistant_message_content import AssistantMessageContent
from .tool_call import ToolCall


class AssistantMessage(UniversalBaseModel):
    """
    Assistant message turn
    """

    role: typing.Literal["assistant"] = pydantic.Field(default="assistant")
    """
    Role of the message
    """

    content: typing.Optional[AssistantMessageContent] = pydantic.Field(default=None)
    """
    Text content for the assistant message
    """

    tool_calls: typing.Optional[typing.List[ToolCall]] = pydantic.Field(default=None)
    """
    List of tool calls made by the assistant
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Name of the assistant this message is from
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
