# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .aws_bedrock_guardrail_config_auth_data import AwsBedrockGuardrailConfigAuthData
from .aws_bedrock_guardrail_config_operation import AwsBedrockGuardrailConfigOperation
from .aws_region import AwsRegion


class AwsBedrockGuardrailConfig(UniversalBaseModel):
    """
    AWS Bedrock
    """

    name: str = pydantic.Field()
    """
    The name of the Guardrail Config.
    """

    type: typing.Literal["integration/guardrail-config/aws-bedrock"] = pydantic.Field(
        default="integration/guardrail-config/aws-bedrock"
    )
    """
    +uiType=Hidden
    +value=integration/guardrail-config/aws-bedrock
    """

    operation: AwsBedrockGuardrailConfigOperation = pydantic.Field()
    """
    The operation type to use for the Guardrail. Validate guardrails are used to validate requests and mutate can validate as well as mutate requests.
    Validate guardrails are run in parallel while mutate guardrails are run sequentially.
    """

    auth_data: typing.Optional[AwsBedrockGuardrailConfigAuthData] = pydantic.Field(default=None)
    """
    Authentication data for the AWS account
    """

    guardrail_id: str = pydantic.Field()
    """
    The unique identifier of the Bedrock Guardrail created in AWS console
    """

    guardrail_version: str = pydantic.Field()
    """
    Version number of the guardrail to use (e.g., 2 for version 2)
    """

    region: AwsRegion

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
