# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .aws_bedrock_provider_account_auth_data import AwsBedrockProviderAccountAuthData
from .aws_region import AwsRegion
from .bedrock_model import BedrockModel
from .collaborator import Collaborator
from .owned_by import OwnedBy


class AwsBedrockProviderAccount(UniversalBaseModel):
    """
    AWS Bedrock
    """

    type: typing.Literal["provider-account/aws-bedrock"] = pydantic.Field(default="provider-account/aws-bedrock")
    """
    +value=provider-account/aws-bedrock
    """

    name: str = pydantic.Field()
    """
    The name of the AWS Bedrock provider account
    """

    region: AwsRegion
    auth_data: typing.Optional[AwsBedrockProviderAccountAuthData] = pydantic.Field(default=None)
    """
    Authentication data for the AWS account
    """

    integrations: typing.List[BedrockModel] = pydantic.Field()
    """
    List of integrations that are associated with the AWS Bedrock provider account
    """

    collaborators: typing.Optional[typing.List[Collaborator]] = pydantic.Field(default=None)
    """
    List of users who have access to this provider account
    """

    owned_by: typing_extensions.Annotated[typing.Optional[OwnedBy], FieldMetadata(alias="ownedBy")] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
