# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .aws_eks_integration_auth_data import AwsEksIntegrationAuthData
from .aws_region import AwsRegion


class AwsEksIntegration(UniversalBaseModel):
    """
    AWS EKS
    """

    type: typing.Literal["integration/cluster/aws/eks"] = pydantic.Field(default="integration/cluster/aws/eks")
    """
    +value=integration/cluster/aws/eks
    """

    name: str = pydantic.Field()
    """
    The name of the integration that will be displayed in the TrueFoundry UI.
    """

    region: AwsRegion
    cluster_name: str = pydantic.Field()
    """
    Name of the cluster given in the cloud account.
    """

    auth_data: typing.Optional[AwsEksIntegrationAuthData] = pydantic.Field(default=None)
    """
    Custom authentication data for the integration.
    """

    authorized_subjects: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    List of subjects that are authorized to access this integration. List of user fqn in format <user_type>:<username>.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
