# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .aws_integrations import AwsIntegrations
from .aws_provider_account_auth_data import AwsProviderAccountAuthData
from .owned_by import OwnedBy


class AwsProviderAccount(UniversalBaseModel):
    """
    AWS
    """

    type: typing.Literal["provider-account/aws"] = pydantic.Field(default="provider-account/aws")
    """
    +value=provider-account/aws
    """

    name: str = pydantic.Field()
    """
    The name of the AWS provider account.
    """

    aws_account_id: str = pydantic.Field()
    """
    The AWS account ID.
    """

    auth_data: typing.Optional[AwsProviderAccountAuthData] = pydantic.Field(default=None)
    """
    Authentication data for the AWS account.
    """

    integrations: typing.List[AwsIntegrations] = pydantic.Field()
    """
    List of integrations that are associated with the AWS provider account.
    """

    owned_by: typing_extensions.Annotated[typing.Optional[OwnedBy], FieldMetadata(alias="ownedBy")] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
