# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .aws_region import AwsRegion
from .aws_s3auth_data import AwsS3AuthData


class AwsS3(UniversalBaseModel):
    """
    AWS S3
    """

    type: typing.Literal["integration/blob-storage/aws/s3"] = pydantic.Field(default="integration/blob-storage/aws/s3")
    """
    +value=integration/blob-storage/aws/s3
    """

    name: str = pydantic.Field()
    """
    The name of the integration that will be displayed in the TrueFoundry UI.
    """

    storage_root: str = pydantic.Field()
    """
    The root path of the storage.
    """

    region: AwsRegion
    auth_data: typing.Optional[AwsS3AuthData] = pydantic.Field(default=None)
    """
    Custom authentication data for the integration.
    """

    authorized_subjects: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    List of subjects that are authorized to access this integration. List of user fqn in format <user_type>:<username>.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
