# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .aws_region import AwsRegion
from .aws_sagemaker_provider_account_auth_data import AwsSagemakerProviderAccountAuthData
from .collaborator import Collaborator
from .owned_by import OwnedBy
from .sagemaker_model import SagemakerModel


class AwsSagemakerProviderAccount(UniversalBaseModel):
    """
    Sagemaker
    """

    type: typing.Literal["provider-account/aws-sagemaker"] = pydantic.Field(default="provider-account/aws-sagemaker")
    """
    +value=provider-account/aws-sagemaker
    """

    name: str = pydantic.Field()
    """
    The name of the Sagemaker provider account
    """

    region: AwsRegion
    auth_data: typing.Optional[AwsSagemakerProviderAccountAuthData] = pydantic.Field(default=None)
    """
    Authentication data for the AWS account
    """

    integrations: typing.List[SagemakerModel] = pydantic.Field()
    """
    List of integrations that are associated with the Sagemaker provider account
    """

    collaborators: typing.Optional[typing.List[Collaborator]] = pydantic.Field(default=None)
    """
    List of users who have access to this provider account
    """

    owned_by: typing_extensions.Annotated[typing.Optional[OwnedBy], FieldMetadata(alias="ownedBy")] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
