# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .aws_region import AwsRegion
from .aws_secrets_manager_auth_data import AwsSecretsManagerAuthData


class AwsSecretsManager(UniversalBaseModel):
    """
    AWS Secrets Manager
    """

    type: typing.Literal["integration/secret-store/aws/secrets-manager"] = pydantic.Field(
        default="integration/secret-store/aws/secrets-manager"
    )
    """
    +value=integration/secret-store/aws/secrets-manager
    """

    name: str = pydantic.Field()
    """
    The name of the integration that will be displayed in the TrueFoundry UI.
    """

    region: AwsRegion
    auth_data: typing.Optional[AwsSecretsManagerAuthData] = pydantic.Field(default=None)
    """
    Custom authentication data for the integration.
    """

    authorized_subjects: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    List of subjects that are authorized to access this integration. List of user fqn in format <user_type>:<username>.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
