# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .azure_o_auth import AzureOAuth


class AzureAksIntegration(UniversalBaseModel):
    """
    Azure AKS
    """

    type: typing.Literal["integration/cluster/azure/aks"] = pydantic.Field(default="integration/cluster/azure/aks")
    """
    +value=integration/cluster/azure/aks
    """

    name: str = pydantic.Field()
    """
    The name of the integration that will be displayed in the TrueFoundry UI.
    """

    resource_group: str = pydantic.Field()
    """
    The resource group of the cluster in the cloud account.
    """

    cluster_name: str = pydantic.Field()
    """
    Name of the cluster given in the cloud account.
    """

    auth_data: typing.Optional[AzureOAuth] = None
    authorized_subjects: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    List of subjects that are authorized to access this integration. List of user fqn in format <user_type>:<username>.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
