# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .azure_key_auth import AzureKeyAuth
from .model_cost_metric import ModelCostMetric
from .model_type import ModelType


class AzureFoundryModel(UniversalBaseModel):
    """
    Azure Foundry Model
    """

    type: typing.Literal["integration/model/azure-foundry"] = pydantic.Field(default="integration/model/azure-foundry")
    """
    +value=integration/model/azure-foundry
    """

    name: str = pydantic.Field()
    """
    A descriptive name to identify this model integration in the UI
    """

    auth_data: AzureKeyAuth
    model_types: typing.List[ModelType] = pydantic.Field()
    """
    Types of models supported by this Azure AI Foundry deployment
    """

    model_id: str = pydantic.Field()
    """
    The model deployment name created in your Azure AI Foundry project. This is the deployment name you configured in Azure AI Foundry, not the base model name.
    """

    azure_endpoint: str = pydantic.Field()
    """
    The Azure AI Foundry endpoint URL
    """

    api_version: str = pydantic.Field()
    """
    The API version for the Azure Foundry model
    """

    cost: typing.Optional[ModelCostMetric] = None
    authorized_subjects: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    List of subjects that are authorized to access this integration. List of user fqn in format <user_type>:<username>.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
