# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .azure_foundry_model import AzureFoundryModel
from .collaborator import Collaborator
from .owned_by import OwnedBy


class AzureFoundryProviderAccount(UniversalBaseModel):
    """
    Azure Foundry Provider Account
    """

    type: typing.Literal["provider-account/azure-foundry"] = pydantic.Field(default="provider-account/azure-foundry")
    """
    +value=provider-account/azure-foundry
    """

    name: str = pydantic.Field()
    """
    The name of the Azure Foundry provider account
    """

    integrations: typing.List[AzureFoundryModel] = pydantic.Field()
    """
    List of integrations that are associated with the Azure Foundry provider account
    """

    collaborators: typing.Optional[typing.List[Collaborator]] = pydantic.Field(default=None)
    """
    List of users who have access to this provider account
    """

    owned_by: typing_extensions.Annotated[typing.Optional[OwnedBy], FieldMetadata(alias="ownedBy")] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
