# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class AzureOAuth(UniversalBaseModel):
    """
    Azure OAuth
    """

    type: typing.Literal["oauth"] = pydantic.Field(default="oauth")
    """
    +value=oauth
    """

    tenant_id: str = pydantic.Field()
    """
    The Azure Active Directory tenant (directory) ID.
    """

    client_id: str = pydantic.Field()
    """
    The client (application) ID of an App Registration in the tenant.
    """

    client_secret: str = pydantic.Field()
    """
    A client secret that was generated for the App Registration.
    """

    subscription_id: str = pydantic.Field()
    """
    The ID of the target subscription. The value must be an UUID.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
