# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .azure_key_auth import AzureKeyAuth
from .azure_pii_category import AzurePiiCategory
from .azure_pii_guardrail_config_domain import AzurePiiGuardrailConfigDomain


class AzurePiiGuardrailConfig(UniversalBaseModel):
    """
    Azure PII
    """

    name: str = pydantic.Field()
    """
    The name of the Guardrail Config.
    """

    type: typing.Literal["integration/guardrail-config/azure-pii"] = pydantic.Field(
        default="integration/guardrail-config/azure-pii"
    )
    """
    +uiType=Hidden
    +value=integration/guardrail-config/azure-pii
    """

    resource_name: str = pydantic.Field()
    """
    Name of your Azure AI Language resource where the PII detection service is deployed (e.g., my-language-resource)
    """

    api_version: str = pydantic.Field(default="2024-11-01")
    """
    API version for the PII detection API
    """

    custom_host: typing.Optional[str] = pydantic.Field(default=None)
    """
    Custom endpoint URL for the PII detection API (optional, uses default Azure endpoint if not specified)
    """

    domain: AzurePiiGuardrailConfigDomain = pydantic.Field()
    """
    Specialized domain for PII detection. Use healthcare for PHI (Protected Health Information) or none for general text
    """

    pii_categories: typing.List[AzurePiiCategory] = pydantic.Field()
    """
    Categories of PII to detect.
    """

    model_version: str = pydantic.Field(default="latest")
    """
    Version of the PII detection model to use, use latest for the newest model or specify a specific version for consistency
    """

    language: str = pydantic.Field(default="en")
    """
    Language code for PII detection (e.g., en for English)
    """

    auth_data: AzureKeyAuth

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
