# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .azure_integrations import AzureIntegrations
from .owned_by import OwnedBy


class AzureProviderAccount(UniversalBaseModel):
    """
    Azure
    """

    type: typing.Literal["provider-account/azure"] = pydantic.Field(default="provider-account/azure")
    """
    +value=provider-account/azure
    """

    name: str = pydantic.Field()
    """
    The name of the Azure provider account.
    """

    subscription_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The ID of the target subscription. The value must be an UUID.
    """

    integrations: typing.List[AzureIntegrations] = pydantic.Field()
    """
    List of integrations that are associated with the Azure provider account.
    """

    owned_by: typing_extensions.Annotated[typing.Optional[OwnedBy], FieldMetadata(alias="ownedBy")] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
