# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .base_o_auth2login_jwt_source import BaseOAuth2LoginJwtSource


class BaseOAuth2Login(UniversalBaseModel):
    """
    OAuth2 client configuration to get the JWT.
    """

    client_id: str = pydantic.Field()
    """
    client ID for OAuth2.
    """

    client_secret: typing.Optional[str] = pydantic.Field(default=None)
    """
    Client secret or the TrueFoundry secret containing the client secret for OAuth2.
    """

    authorization_url: str = pydantic.Field()
    """
    URL for the authorization request
    """

    token_url: str = pydantic.Field()
    """
    The endpoint to exchange auth code for tokens.
    """

    scopes: typing.List[str] = pydantic.Field()
    """
    List of scopes to request from the OAuth2 provider.
    """

    jwt_source: BaseOAuth2LoginJwtSource = pydantic.Field()
    """
    Source of the JWT token to be used for verification.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
