# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .aws_region import AwsRegion
from .model_cost_metric import ModelCostMetric
from .model_type import ModelType


class BedrockModel(UniversalBaseModel):
    """
    Bedrock Model
    """

    name: str = pydantic.Field()
    """
    A descriptive name to identify this model integration in the UI
    """

    model_id: str = pydantic.Field()
    """
    The AWS Bedrock model identifier or inference profile. Can be a foundation model ID (e.g., anthropic.claude-3-5-sonnet-20240620-v1:0, amazon.titan-text-express-v1), an inference profile ID (e.g., us.anthropic.claude-3-5-sonnet-20240620-v1:0), or an inference profile ARN (e.g., arn:aws:bedrock:us-east-1:123456789012:inference-profile/my-profile).
    """

    type: typing.Literal["integration/model/bedrock"] = pydantic.Field(default="integration/model/bedrock")
    """
    +value=integration/model/bedrock
    """

    model_types: typing.List[ModelType] = pydantic.Field()
    """
    Specify the type of the Bedrock model
    """

    region: typing.Optional[AwsRegion] = None
    cost: typing.Optional[ModelCostMetric] = None
    authorized_subjects: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    List of subjects that are authorized to access this integration. List of user fqn in format <user_type>:<username>.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
